/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.literal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.swrlapi.exceptions.LiteralException;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;

public interface Literal {
    public boolean isNumeric();

    public boolean isByte();

    public boolean isShort();

    public boolean isInt();

    public boolean isLong();

    public boolean isFloat();

    public boolean isDouble();

    public boolean isString();

    public boolean isBoolean();

    public boolean isAnyURI();

    public boolean isTime();

    public boolean isDate();

    public boolean isDateTime();

    public boolean isDuration();

    public boolean isDecimal();

    public boolean isInteger();

    public boolean isNegativeInteger();

    public boolean isPositiveInteger();

    public boolean isNonNegativeInteger();

    public boolean isNonPositiveInteger();

    public boolean isUnsignedLong();

    public boolean isUnsignedInt();

    public boolean isUnsignedShort();

    public boolean isUnsignedByte();

    public boolean isRDFPlainLiteral();

    public boolean isRDFSLiteral();

    public boolean isRDFXMLLiteral();

    public byte getByte() throws LiteralException;

    public short getShort() throws LiteralException;

    public int getInt() throws LiteralException;

    public long getLong() throws LiteralException;

    public float getFloat() throws LiteralException;

    public double getDouble() throws LiteralException;

    public boolean getBoolean() throws LiteralException;

    public @NonNull String getString() throws LiteralException;

    public @NonNull URI getAnyURI() throws LiteralException;

    public @NonNull XSDTime getTime() throws LiteralException;

    public @NonNull XSDDate getDate() throws LiteralException;

    public @NonNull XSDDateTime getDateTime() throws LiteralException;

    public @NonNull XSDDuration getDuration() throws LiteralException;

    public @NonNull BigDecimal getDecimal() throws LiteralException;

    public @NonNull BigInteger getInteger() throws LiteralException;

    public @NonNull BigInteger getNonNegativeInteger() throws LiteralException;

    public @NonNull BigInteger getNonPositiveInteger() throws LiteralException;

    public @NonNull BigInteger getNegativeInteger() throws LiteralException;

    public @NonNull BigInteger getPositiveInteger() throws LiteralException;

    public @NonNull long getUnsignedLong() throws LiteralException;

    public @NonNull long getUnsignedInt() throws LiteralException;

    public @NonNull int getUnsignedShort() throws LiteralException;

    public @NonNull short getUnsignedByte() throws LiteralException;

    public @NonNull String getRDFPlainLiteral() throws LiteralException;

    public @NonNull String getRDFSLiteral() throws LiteralException;

    public @NonNull String getRDFXMLLiteral() throws LiteralException;

    public @NonNull String getValue();

    public boolean isComparable();

    public boolean isQuotableType();

    @SideEffectFree
    public @NonNull String toString();

    public @NonNull String toQuotedString();

    public @NonNull OWLLiteral getOWLLiteral();

    public @NonNull OWLDatatype getOWLDatatype();

    public @NonNull String getOWLDatatypeName();
}

