/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.literal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.exceptions.SWRLAPIInternalException;
import org.swrlapi.factory.NaturalOrderComparator;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;

public final class OWLLiteralComparator
implements Comparator<OWLLiteral> {
    private static final @NonNull Comparator<String> naturalOrderComparator = NaturalOrderComparator.NUMERICAL_ORDER;
    public static final @NonNull Comparator<OWLLiteral> COMPARATOR = new OWLLiteralComparator();

    @Override
    public int compare(@NonNull OWLLiteral l1, @NonNull OWLLiteral l2) {
        return this.compareOWLLiterals(l1, l2);
    }

    public static boolean isNumeric(@NonNull OWLLiteral literal) {
        return literal.getDatatype().getIRI().equals((Object)XSDVocabulary.BYTE.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.SHORT.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.INT.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.LONG.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.FLOAT.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.DOUBLE.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.DECIMAL.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.INTEGER.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.POSITIVE_INTEGER.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.NEGATIVE_INTEGER.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.NON_NEGATIVE_INTEGER.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.NON_POSITIVE_INTEGER.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_LONG.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_INT.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_SHORT.getIRI()) || literal.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_BYTE.getIRI());
    }

    private int compareOWLLiterals(@NonNull OWLLiteral l1, @NonNull OWLLiteral l2) {
        try {
            if (this.areAllLiteralsNumeric(l1, l2)) {
                if (this.areTypesIdentical(l1, l2)) {
                    if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.BYTE.getIRI())) {
                        Byte b1 = Byte.parseByte(l1.getLiteral());
                        Byte b2 = Byte.parseByte(l2.getLiteral());
                        return b1.compareTo(b2);
                    }
                    if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.SHORT.getIRI()) || l1.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_BYTE.getIRI())) {
                        Short s1 = Short.parseShort(l1.getLiteral());
                        Short s2 = Short.parseShort(l2.getLiteral());
                        return s1.compareTo(s2);
                    }
                    if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.INT.getIRI()) || l1.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_SHORT.getIRI())) {
                        Integer i1 = Integer.parseInt(l1.getLiteral());
                        Integer i2 = Integer.parseInt(l2.getLiteral());
                        return i1.compareTo(i2);
                    }
                    if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.LONG.getIRI()) || l1.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_INT.getIRI())) {
                        Long long1 = Long.parseLong(l1.getLiteral());
                        Long long2 = Long.parseLong(l2.getLiteral());
                        return long1.compareTo(long2);
                    }
                    if (l1.getDatatype().isFloat()) {
                        Float f1 = Float.valueOf(Float.parseFloat(l1.getLiteral()));
                        Float f2 = Float.valueOf(Float.parseFloat(l2.getLiteral()));
                        return f1.compareTo(f2);
                    }
                    if (l1.getDatatype().isDouble()) {
                        Double d1 = Double.parseDouble(l1.getLiteral());
                        Double d2 = Double.parseDouble(l2.getLiteral());
                        return d1.compareTo(d2);
                    }
                    if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.DECIMAL.getIRI())) {
                        BigDecimal d1 = new BigDecimal(l1.getLiteral());
                        BigDecimal d2 = new BigDecimal(l2.getLiteral());
                        return d1.compareTo(d2);
                    }
                    if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.INTEGER.getIRI()) || l1.getDatatype().getIRI().equals((Object)XSDVocabulary.POSITIVE_INTEGER.getIRI()) || l1.getDatatype().getIRI().equals((Object)XSDVocabulary.NON_NEGATIVE_INTEGER.getIRI()) || l1.getDatatype().getIRI().equals((Object)XSDVocabulary.NEGATIVE_INTEGER.getIRI()) || l1.getDatatype().getIRI().equals((Object)XSDVocabulary.NON_POSITIVE_INTEGER.getIRI()) || l1.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_LONG.getIRI())) {
                        BigInteger d1 = new BigInteger(l1.getLiteral());
                        BigInteger d2 = new BigInteger(l2.getLiteral());
                        return d1.compareTo(d2);
                    }
                    throw new SWRLAPIInternalException("unsupported numeric datatype " + l1.getDatatype().getIRI() + " for OWL literal with value " + l1.getLiteral());
                }
                BigDecimal d1 = new BigDecimal(l1.getLiteral());
                BigDecimal d2 = new BigDecimal(l2.getLiteral());
                return d1.compareTo(d2);
            }
            if (!this.areTypesIdentical(l1, l2)) {
                return -1;
            }
            if (l1.getDatatype().isBoolean()) {
                Boolean b1 = Boolean.parseBoolean(l1.getLiteral());
                Boolean b2 = Boolean.parseBoolean(l2.getLiteral());
                return b1.compareTo(b2);
            }
            if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.ANY_URI.getIRI())) {
                URI u1 = URI.create(l1.getLiteral());
                URI u2 = URI.create(l2.getLiteral());
                return u1.compareTo(u2);
            }
            if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.TIME.getIRI())) {
                XSDTime t1 = new XSDTime(l1.getLiteral());
                XSDTime t2 = new XSDTime(l2.getLiteral());
                return t1.compareTo(t2);
            }
            if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.DATE.getIRI())) {
                XSDDate d1 = new XSDDate(l1.getLiteral());
                XSDDate d2 = new XSDDate(l2.getLiteral());
                return d1.compareTo(d2);
            }
            if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.DATE_TIME.getIRI())) {
                XSDDateTime dt1 = new XSDDateTime(l1.getLiteral());
                XSDDateTime dt2 = new XSDDateTime(l2.getLiteral());
                return dt1.compareTo(dt2);
            }
            if (l1.getDatatype().getIRI().equals((Object)XSDVocabulary.DURATION.getIRI())) {
                XSDDuration d1 = new XSDDuration(l1.getLiteral());
                XSDDuration d2 = new XSDDuration(l2.getLiteral());
                return d1.compareTo(d2);
            }
            return naturalOrderComparator.compare(l1.getLiteral(), l2.getLiteral());
        }
        catch (IllegalArgumentException e) {
            throw new SWRLAPIException("Literal " + l1.getLiteral() + " or " + l2.getLiteral() + " not valid " + l1.getDatatype().getIRI());
        }
    }

    private boolean areTypesIdentical(@NonNull OWLLiteral literal1, @NonNull OWLLiteral literal2) {
        return literal1.getDatatype().getIRI().equals((Object)literal2.getDatatype().getIRI());
    }

    private boolean areAllLiteralsNumeric(OWLLiteral ... literals) {
        for (OWLLiteral literal : literals) {
            if (OWLLiteralComparator.isNumeric(literal)) continue;
            return false;
        }
        return true;
    }
}

