/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.literal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;

public class OWLLiteralValidator {
    public static boolean isValid(@NonNull String literal, @NonNull OWLDatatype datatype) {
        try {
            if (datatype.getIRI().equals((Object)XSDVocabulary.DECIMAL.getIRI())) {
                new BigDecimal(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.INTEGER.getIRI())) {
                new BigInteger(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.BYTE.getIRI())) {
                Byte.parseByte(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.SHORT.getIRI())) {
                Short.parseShort(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.INT.getIRI())) {
                Integer.parseInt(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.LONG.getIRI())) {
                Long.parseLong(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.FLOAT.getIRI())) {
                Float.parseFloat(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.DOUBLE.getIRI())) {
                Double.parseDouble(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.BOOLEAN.getIRI())) {
                return literal.equalsIgnoreCase("true") || literal.equalsIgnoreCase("false");
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.ANY_URI.getIRI())) {
                URI.create(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.TIME.getIRI())) {
                new XSDTime(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.DATE_TIME.getIRI())) {
                new XSDDateTime(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.DATE.getIRI())) {
                new XSDDate(literal);
                return true;
            }
            if (datatype.getIRI().equals((Object)XSDVocabulary.DURATION.getIRI())) {
                new XSDDuration(literal);
                return true;
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

