/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.literal;

import java.util.Date;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.literal.XSDTimeUtil;
import org.swrlapi.literal.XSDType;

public class XSDDate
extends XSDType<XSDDate> {
    private final @NonNull Date date;

    public XSDDate(@NonNull String content) {
        super(content, XSDVocabulary.DATE.getIRI());
        this.date = XSDTimeUtil.xsdDateString2UtilDate(content);
    }

    public XSDDate(@NonNull Date date) {
        super(XSDTimeUtil.utilDate2XSDDateString(date), XSDVocabulary.DATE.getIRI());
        this.date = new Date(date.getTime());
    }

    @Override
    protected void validate() {
        if (this.getContent() == null) {
            throw new IllegalArgumentException("null content for xsd:Date");
        }
        if (!XSDTimeUtil.isValidXSDDateString(this.getContent())) {
            throw new IllegalArgumentException("invalid xsd:Date '" + this.getContent() + "'");
        }
    }

    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XSDDate xsdDate = (XSDDate)o;
        return Objects.equals(this.date, xsdDate.date);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        return this.date != null ? this.date.hashCode() : 0;
    }

    @Override
    @SideEffectFree
    @Deterministic
    public int compareTo(@NonNull XSDDate o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this == o) {
            return 0;
        }
        return XSDTimeUtil.compareDates(this.date, o.date);
    }
}

