/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.literal;

import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.literal.XSDTimeUtil;
import org.swrlapi.literal.XSDType;

public class XSDDateTime
extends XSDType<XSDDateTime> {
    private final @NonNull Date datetime;

    public XSDDateTime(@NonNull String content) {
        super(content, XSDVocabulary.DATE_TIME.getIRI());
        this.datetime = XSDTimeUtil.xsdDateTimeString2UtilDate(content);
    }

    public XSDDateTime(@NonNull Date datetime) {
        super(XSDTimeUtil.utilDate2XSDDateTimeString(datetime), XSDVocabulary.DATE_TIME.getIRI());
        this.datetime = new Date(datetime.getTime());
    }

    @Override
    protected void validate() {
        if (this.getContent() == null) {
            throw new IllegalArgumentException("null content for xsd:DateTime");
        }
        if (!XSDTimeUtil.isValidXSDDateTimeString(this.getContent())) {
            throw new IllegalArgumentException("invalid xsd:DateTime " + this.getContent());
        }
    }

    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XSDDateTime)) {
            return false;
        }
        XSDDateTime otherDateTime = (XSDDateTime)o;
        return this.datetime != null && otherDateTime.datetime != null && this.datetime.equals(otherDateTime.datetime);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int code = 136;
        return code += this.datetime.hashCode();
    }

    @Override
    @SideEffectFree
    @Deterministic
    public int compareTo(@NonNull XSDDateTime o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this == o) {
            return 0;
        }
        return XSDTimeUtil.compareDateTimes(this.datetime, o.datetime);
    }
}

