/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.literal;

import org.apache.axis.types.Duration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.literal.XSDTimeUtil;
import org.swrlapi.literal.XSDType;

public class XSDDuration
extends XSDType<XSDDuration> {
    private final @NonNull Duration duration;

    public XSDDuration(@NonNull String content) {
        super(content, XSDVocabulary.DURATION.getIRI());
        this.duration = XSDTimeUtil.xsdDurationString2AxisDuration(content);
    }

    @Override
    protected void validate() {
        if (this.getContent() == null) {
            throw new IllegalArgumentException("null content for XSD:duration literal");
        }
        if (!XSDTimeUtil.isValidXSDDurationString(this.getContent())) {
            throw new IllegalArgumentException("invalid xsd:Duration: " + this.getContent());
        }
    }

    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XSDDuration)) {
            return false;
        }
        XSDDuration otherDuration = (XSDDuration)o;
        return this.duration != null && otherDuration.duration != null && this.duration.equals((Object)otherDuration.duration);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int code = 34;
        return code += this.duration.hashCode();
    }

    @Override
    @SideEffectFree
    @Deterministic
    public int compareTo(@NonNull XSDDuration o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this == o) {
            return 0;
        }
        return XSDTimeUtil.compareAxisDurations(this.duration, o.duration);
    }
}

