/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.literal;

import java.util.Date;
import org.apache.axis.types.Time;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.literal.XSDTimeUtil;
import org.swrlapi.literal.XSDType;

public class XSDTime
extends XSDType<XSDTime> {
    private final @NonNull Time time;

    public XSDTime(@NonNull String content) {
        super(content, XSDVocabulary.TIME.getIRI());
        this.time = XSDTimeUtil.xsdTimeString2AxisTime(content);
    }

    public XSDTime(@NonNull Date date) {
        super(XSDTimeUtil.utilDate2XSDTimeString(date), XSDVocabulary.TIME.getIRI());
        this.time = XSDTimeUtil.utilDate2XSDTime(date);
    }

    @Override
    protected void validate() {
        if (this.getContent() == null) {
            throw new IllegalArgumentException("null content for xsd:Time");
        }
        if (!XSDTimeUtil.isValidXSDTimeString(this.getContent())) {
            throw new IllegalArgumentException("invalid xsd:Time '" + this.getContent() + "'");
        }
    }

    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XSDTime)) {
            return false;
        }
        XSDTime otherTime = (XSDTime)o;
        return this.time != null && otherTime.time != null && this.time.equals((Object)otherTime.time);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int code = 156;
        return code += this.time.hashCode();
    }

    @Override
    @SideEffectFree
    @Deterministic
    public int compareTo(@NonNull XSDTime o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this == o) {
            return 0;
        }
        return XSDTimeUtil.compareAxisTimes(this.time, o.time);
    }
}

