/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.literal;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.axis.types.Duration;
import org.apache.axis.types.Time;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;

public class XSDTimeUtil {
    private static final @NonNull String xsdDateTimeFormatString = "yyyy-MM-dd'T'hh:mm:ss";
    private static final @NonNull String xsdDateFormatString = "yyyy-MM-dd";
    private static final @NonNull String jdbcDateTimeFormatString = "y-M-d h:m:s.S";
    private static final @NonNull String jdbcDateFormatString = "y-M-d";
    private static final @NonNull DateFormat xsdDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private static final @NonNull DateFormat xsdDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final @NonNull DateFormat jdbcDateTimeFormat = new SimpleDateFormat("y-M-d h:m:s.S");
    private static final @NonNull DateFormat jdbcDateFormat = new SimpleDateFormat("y-M-d");

    public static Duration addAxisDurations(@NonNull Duration duration1, @NonNull Duration duration2) {
        Duration result = new Duration();
        result.setYears(XSDTimeUtil.getYearsFromAxisDuration(duration1) + XSDTimeUtil.getYearsFromAxisDuration(duration2));
        result.setMonths(XSDTimeUtil.getMonthsFromAxisDuration(duration1) + XSDTimeUtil.getMonthsFromAxisDuration(duration2));
        result.setDays(XSDTimeUtil.getDaysFromAxisDuration(duration1) + XSDTimeUtil.getDaysFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getHoursFromAxisDuration(duration1) + XSDTimeUtil.getHoursFromAxisDuration(duration2));
        result.setMinutes(XSDTimeUtil.getMinutesFromAxisDuration(duration1) + XSDTimeUtil.getMinutesFromAxisDuration(duration2));
        result.setSeconds(XSDTimeUtil.getSecondsFromAxisDuration(duration1) + XSDTimeUtil.getSecondsFromAxisDuration(duration2));
        return result;
    }

    public static int compareAxisDurations(@NonNull Duration duration1, @NonNull Duration duration2) {
        int diff = XSDTimeUtil.getYearsFromAxisDuration(duration1) - XSDTimeUtil.getYearsFromAxisDuration(duration2);
        if (diff != 0) {
            return diff;
        }
        diff = XSDTimeUtil.getMonthsFromAxisDuration(duration1) - XSDTimeUtil.getMonthsFromAxisDuration(duration2);
        if (diff != 0) {
            return diff;
        }
        diff = XSDTimeUtil.getDaysFromAxisDuration(duration1) - XSDTimeUtil.getDaysFromAxisDuration(duration2);
        if (diff != 0) {
            return diff;
        }
        diff = XSDTimeUtil.getHoursFromAxisDuration(duration1) - XSDTimeUtil.getHoursFromAxisDuration(duration2);
        if (diff != 0) {
            return diff;
        }
        diff = XSDTimeUtil.getMinutesFromAxisDuration(duration1) - XSDTimeUtil.getMinutesFromAxisDuration(duration2);
        if (diff != 0) {
            return diff;
        }
        diff = (int)XSDTimeUtil.getSecondsFromAxisDuration(duration1) - (int)XSDTimeUtil.getSecondsFromAxisDuration(duration2);
        return diff;
    }

    public static int compareDateTimes(@NonNull Date date1, @NonNull Date date2) {
        GregorianCalendar calendar1 = new GregorianCalendar();
        GregorianCalendar calendar2 = new GregorianCalendar();
        calendar1.setTime(date1);
        calendar2.setTime(date2);
        int diff = calendar1.get(1) - calendar2.get(1);
        if (diff != 0) {
            return diff;
        }
        diff = calendar1.get(2) - calendar2.get(2);
        if (diff != 0) {
            return diff;
        }
        diff = calendar1.get(5) - calendar2.get(5);
        if (diff != 0) {
            return diff;
        }
        diff = calendar1.get(10) - calendar2.get(10);
        if (diff != 0) {
            return diff;
        }
        diff = calendar1.get(12) - calendar2.get(12);
        if (diff != 0) {
            return diff;
        }
        diff = calendar1.get(13) - calendar2.get(13);
        return diff;
    }

    public static int compareDates(@NonNull Date date1, @NonNull Date date2) {
        GregorianCalendar calendar1 = new GregorianCalendar();
        GregorianCalendar calendar2 = new GregorianCalendar();
        calendar1.setTime(date1);
        calendar2.setTime(date2);
        int diff = calendar1.get(1) - calendar2.get(1);
        if (diff != 0) {
            return diff;
        }
        diff = calendar1.get(2) - calendar2.get(2);
        if (diff != 0) {
            return diff;
        }
        diff = calendar1.get(5) - calendar2.get(5);
        return diff;
    }

    public static int compareAxisTimes(@NonNull Time time1, @NonNull Time time2) {
        Calendar calendar1 = time1.getAsCalendar();
        Calendar calendar2 = time2.getAsCalendar();
        int diff = calendar1.get(10) - calendar2.get(10);
        if (diff != 0) {
            return diff;
        }
        diff = calendar1.get(12) - calendar2.get(12);
        if (diff != 0) {
            return diff;
        }
        diff = calendar1.get(13) - calendar2.get(13);
        if (diff != 0) {
            return diff;
        }
        return diff;
    }

    public static @NonNull Duration subtractAxisDurations(@NonNull Duration duration1, @NonNull Duration duration2) {
        Duration result = new Duration();
        result.setYears(XSDTimeUtil.getYearsFromAxisDuration(duration1) - XSDTimeUtil.getYearsFromAxisDuration(duration2));
        result.setMonths(XSDTimeUtil.getMonthsFromAxisDuration(duration1) - XSDTimeUtil.getMonthsFromAxisDuration(duration2));
        result.setDays(XSDTimeUtil.getDaysFromAxisDuration(duration1) - XSDTimeUtil.getDaysFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getHoursFromAxisDuration(duration1) - XSDTimeUtil.getHoursFromAxisDuration(duration2));
        result.setMinutes(XSDTimeUtil.getMinutesFromAxisDuration(duration1) - XSDTimeUtil.getMinutesFromAxisDuration(duration2));
        result.setSeconds(XSDTimeUtil.getSecondsFromAxisDuration(duration1) - XSDTimeUtil.getSecondsFromAxisDuration(duration2));
        return result;
    }

    public static @NonNull Duration multiplyAxisDurations(@NonNull Duration duration1, @NonNull Duration duration2) {
        Duration result = new Duration();
        result.setYears(XSDTimeUtil.getYearsFromAxisDuration(duration1) * XSDTimeUtil.getYearsFromAxisDuration(duration2));
        result.setMonths(XSDTimeUtil.getMonthsFromAxisDuration(duration1) * XSDTimeUtil.getMonthsFromAxisDuration(duration2));
        result.setDays(XSDTimeUtil.getDaysFromAxisDuration(duration1) * XSDTimeUtil.getDaysFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getHoursFromAxisDuration(duration1) * XSDTimeUtil.getHoursFromAxisDuration(duration2));
        result.setMinutes(XSDTimeUtil.getMinutesFromAxisDuration(duration1) * XSDTimeUtil.getMinutesFromAxisDuration(duration2));
        result.setSeconds(XSDTimeUtil.getSecondsFromAxisDuration(duration1) * XSDTimeUtil.getSecondsFromAxisDuration(duration2));
        return result;
    }

    public static @NonNull Duration divideAxisDurations(Duration duration1, Duration duration2) {
        Duration result = new Duration();
        result.setYears(XSDTimeUtil.getYearsFromAxisDuration(duration1) / XSDTimeUtil.getYearsFromAxisDuration(duration2));
        result.setMonths(XSDTimeUtil.getMonthsFromAxisDuration(duration1) / XSDTimeUtil.getMonthsFromAxisDuration(duration2));
        result.setDays(XSDTimeUtil.getDaysFromAxisDuration(duration1) / XSDTimeUtil.getDaysFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getHoursFromAxisDuration(duration1) / XSDTimeUtil.getHoursFromAxisDuration(duration2));
        result.setMinutes(XSDTimeUtil.getMinutesFromAxisDuration(duration1) / XSDTimeUtil.getMinutesFromAxisDuration(duration2));
        result.setSeconds(XSDTimeUtil.getSecondsFromAxisDuration(duration1) / XSDTimeUtil.getSecondsFromAxisDuration(duration2));
        return result;
    }

    public static @NonNull Duration addDayTimeDurations(@NonNull Duration duration1, @NonNull Duration duration2) {
        Duration result = new Duration();
        result.setDays(XSDTimeUtil.getDaysFromAxisDuration(duration1) + XSDTimeUtil.getDaysFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getHoursFromAxisDuration(duration1) + XSDTimeUtil.getHoursFromAxisDuration(duration2));
        result.setMinutes(XSDTimeUtil.getMinutesFromAxisDuration(duration1) + XSDTimeUtil.getMinutesFromAxisDuration(duration2));
        result.setSeconds(XSDTimeUtil.getSecondsFromAxisDuration(duration1) + XSDTimeUtil.getSecondsFromAxisDuration(duration2));
        return result;
    }

    public static @NonNull Duration subtractDayTimeDurations(@NonNull Duration duration1, @NonNull Duration duration2) {
        Duration result = new Duration();
        result.setDays(XSDTimeUtil.getDaysFromAxisDuration(duration1) - XSDTimeUtil.getDaysFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getHoursFromAxisDuration(duration1) - XSDTimeUtil.getHoursFromAxisDuration(duration2));
        result.setMinutes(XSDTimeUtil.getMinutesFromAxisDuration(duration1) - XSDTimeUtil.getMinutesFromAxisDuration(duration2));
        result.setSeconds(XSDTimeUtil.getSecondsFromAxisDuration(duration1) - XSDTimeUtil.getSecondsFromAxisDuration(duration2));
        return result;
    }

    public static @NonNull Duration multiplyDayTimeDurations(@NonNull Duration duration1, @NonNull Duration duration2) {
        Duration result = new Duration();
        result.setDays(XSDTimeUtil.getDaysFromAxisDuration(duration1) * XSDTimeUtil.getDaysFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getHoursFromAxisDuration(duration1) * XSDTimeUtil.getHoursFromAxisDuration(duration2));
        result.setMinutes(XSDTimeUtil.getMinutesFromAxisDuration(duration1) * XSDTimeUtil.getMinutesFromAxisDuration(duration2));
        result.setSeconds(XSDTimeUtil.getSecondsFromAxisDuration(duration1) * XSDTimeUtil.getSecondsFromAxisDuration(duration2));
        return result;
    }

    public static @NonNull Duration divideDayTimeDurations(Duration duration1, Duration duration2) {
        Duration result = new Duration();
        result.setDays(XSDTimeUtil.getDaysFromAxisDuration(duration1) / XSDTimeUtil.getDaysFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getHoursFromAxisDuration(duration1) / XSDTimeUtil.getHoursFromAxisDuration(duration2));
        result.setMinutes(XSDTimeUtil.getMinutesFromAxisDuration(duration1) / XSDTimeUtil.getMinutesFromAxisDuration(duration2));
        result.setSeconds(XSDTimeUtil.getSecondsFromAxisDuration(duration1) / XSDTimeUtil.getSecondsFromAxisDuration(duration2));
        return result;
    }

    public static @NonNull Duration addYearMonthDurations(@NonNull Duration duration1, @NonNull Duration duration2) {
        Duration result = new Duration();
        result.setDays(XSDTimeUtil.getYearsFromAxisDuration(duration1) + XSDTimeUtil.getYearsFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getMonthsFromAxisDuration(duration1) + XSDTimeUtil.getMonthsFromAxisDuration(duration2));
        return result;
    }

    public static Duration subtractYearMonthDurations(Duration duration1, Duration duration2) {
        Duration result = new Duration();
        result.setDays(XSDTimeUtil.getYearsFromAxisDuration(duration1) - XSDTimeUtil.getYearsFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getMonthsFromAxisDuration(duration1) - XSDTimeUtil.getMonthsFromAxisDuration(duration2));
        return result;
    }

    public static Duration multiplyYearMonthDurations(Duration duration1, Duration duration2) {
        Duration result = new Duration();
        result.setDays(XSDTimeUtil.getYearsFromAxisDuration(duration1) * XSDTimeUtil.getYearsFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getMonthsFromAxisDuration(duration1) * XSDTimeUtil.getMonthsFromAxisDuration(duration2));
        return result;
    }

    public static Duration divideYearMonthDurations(Duration duration1, Duration duration2) {
        Duration result = new Duration();
        result.setDays(XSDTimeUtil.getYearsFromAxisDuration(duration1) / XSDTimeUtil.getYearsFromAxisDuration(duration2));
        result.setHours(XSDTimeUtil.getMonthsFromAxisDuration(duration1) / XSDTimeUtil.getMonthsFromAxisDuration(duration2));
        return result;
    }

    public static Duration subtractDates(Date date1, Date date2) {
        GregorianCalendar calendar1 = new GregorianCalendar();
        GregorianCalendar calendar2 = new GregorianCalendar();
        calendar1.setTime(date1);
        calendar2.setTime(date2);
        int years = calendar1.get(1) - calendar2.get(1);
        int months = calendar1.get(2) - calendar2.get(2);
        int days = calendar1.get(5) - calendar2.get(5);
        int hours = calendar1.get(10) - calendar2.get(10);
        int minutes = calendar1.get(12) - calendar2.get(12);
        double seconds = calendar1.get(13) - calendar2.get(13);
        return new Duration(false, years, months, days, hours, minutes, seconds);
    }

    public static Duration subtractTimes(Time time1, Time time2) {
        Calendar calendar1 = time1.getAsCalendar();
        Calendar calendar2 = time2.getAsCalendar();
        Duration result = new Duration();
        int hours = calendar1.get(10) - calendar2.get(10);
        int minutes = calendar1.get(12) - calendar2.get(12);
        double seconds = calendar1.get(13) - calendar2.get(13);
        result.setHours(hours);
        result.setMinutes(minutes);
        result.setSeconds(seconds);
        return result;
    }

    public static Date addYearMonthDurationToUtilDateTime(Date date, Duration duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar result = new GregorianCalendar();
        calendar.setTime(date);
        result.set(calendar.get(1) + XSDTimeUtil.getYearsFromAxisDuration(duration), calendar.get(2) + XSDTimeUtil.getMonthsFromAxisDuration(duration), calendar.get(5), calendar.get(10), calendar.get(12), calendar.get(13));
        return result.getTime();
    }

    public static Date addYearMonthDurationToUtilDate(Date date, Duration duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar resultCalendar = new GregorianCalendar();
        calendar.setTime(date);
        resultCalendar.set(calendar.get(1) + XSDTimeUtil.getYearsFromAxisDuration(duration), calendar.get(2) + XSDTimeUtil.getMonthsFromAxisDuration(duration), calendar.get(5));
        return resultCalendar.getTime();
    }

    public static Date subtractYearMonthDurationFromUtilDateTime(Date date, Duration duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar result = new GregorianCalendar();
        calendar.setTime(date);
        result.set(calendar.get(1) - XSDTimeUtil.getYearsFromAxisDuration(duration), calendar.get(2) - XSDTimeUtil.getMonthsFromAxisDuration(duration), calendar.get(5), calendar.get(10), calendar.get(12), calendar.get(13));
        return result.getTime();
    }

    public static @NonNull Date subtractYearMonthDurationFromUtilDate(@NonNull Date date, @NonNull Duration duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar resultCalendar = new GregorianCalendar();
        calendar.setTime(date);
        resultCalendar.set(calendar.get(1) - XSDTimeUtil.getYearsFromAxisDuration(duration), calendar.get(2) - XSDTimeUtil.getMonthsFromAxisDuration(duration), calendar.get(5));
        return resultCalendar.getTime();
    }

    public static @NonNull Date addDayTimeDurationToUtilDate(@NonNull Date date, @NonNull Duration duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar resultCalendar = new GregorianCalendar();
        calendar.setTime(date);
        resultCalendar.set(calendar.get(1), calendar.get(2), calendar.get(5) + XSDTimeUtil.getDaysFromAxisDuration(duration), calendar.get(10) + XSDTimeUtil.getHoursFromAxisDuration(duration), calendar.get(12) + XSDTimeUtil.getMinutesFromAxisDuration(duration), (int)((double)calendar.get(13) + XSDTimeUtil.getSecondsFromAxisDuration(duration)));
        return resultCalendar.getTime();
    }

    public static @NonNull Date subtractDayTimeDurationFromUtilDate(@NonNull Date date, @NonNull Duration duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar resultCalendar = new GregorianCalendar();
        calendar.setTime(date);
        resultCalendar.set(calendar.get(1), calendar.get(2), calendar.get(5) - XSDTimeUtil.getDaysFromAxisDuration(duration), calendar.get(10) - XSDTimeUtil.getHoursFromAxisDuration(duration), calendar.get(12) - XSDTimeUtil.getMinutesFromAxisDuration(duration), (int)((double)calendar.get(13) - XSDTimeUtil.getSecondsFromAxisDuration(duration)));
        return resultCalendar.getTime();
    }

    public static @NonNull Time addDayTimeDurationToTime(@NonNull Time time, @NonNull Duration duration) {
        Calendar calendar = time.getAsCalendar();
        GregorianCalendar resultCalendar = new GregorianCalendar();
        resultCalendar.set(0, calendar.get(5) + XSDTimeUtil.getDaysFromAxisDuration(duration), calendar.get(10) + XSDTimeUtil.getHoursFromAxisDuration(duration), calendar.get(12) + XSDTimeUtil.getMinutesFromAxisDuration(duration), (int)((double)calendar.get(13) + XSDTimeUtil.getSecondsFromAxisDuration(duration)));
        return new Time((Calendar)resultCalendar);
    }

    public static Time subtractDayTimeDurationFromTime(@NonNull Time time, @NonNull Duration duration) {
        Calendar calendar = time.getAsCalendar();
        GregorianCalendar resultCalendar = new GregorianCalendar();
        resultCalendar.set(0, calendar.get(5) - XSDTimeUtil.getDaysFromAxisDuration(duration), calendar.get(10) - XSDTimeUtil.getHoursFromAxisDuration(duration), calendar.get(12) - XSDTimeUtil.getMinutesFromAxisDuration(duration), (int)((double)calendar.get(13) - XSDTimeUtil.getSecondsFromAxisDuration(duration)));
        return new Time((Calendar)resultCalendar);
    }

    public static @NonNull Duration subtractUtilDatesYieldingYearMonthDuration(@NonNull Date date1, @NonNull Date date2) {
        GregorianCalendar calendar1 = new GregorianCalendar();
        GregorianCalendar calendar2 = new GregorianCalendar();
        calendar1.setTime(date1);
        calendar2.setTime(date2);
        int years = calendar1.get(1) - calendar2.get(1);
        int months = calendar1.get(2) - calendar2.get(2);
        return new Duration(false, years, months, 0, 0, 0, 0.0);
    }

    public static @NonNull Duration subtractUtilDatesYieldingDayTimeDuration(@NonNull Date date1, @NonNull Date date2) {
        GregorianCalendar calendar1 = new GregorianCalendar();
        GregorianCalendar calendar2 = new GregorianCalendar();
        calendar1.setTime(date1);
        calendar2.setTime(date2);
        int days = calendar1.get(5) - calendar2.get(5);
        int hours = calendar1.get(10) - calendar2.get(10);
        int minutes = calendar1.get(12) - calendar2.get(12);
        double seconds = calendar1.get(13) - calendar2.get(13);
        return new Duration(false, 0, 0, days, hours, minutes, seconds);
    }

    public static @NonNull String utilDate2XSDDateTimeString(@NonNull Date date) {
        return xsdDateTimeFormat.format(date);
    }

    public static @NonNull String utilDate2XSDDateString(@NonNull Date date) {
        return xsdDateFormat.format(date);
    }

    public static @NonNull String utilDate2XSDTimeString(@NonNull Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        Time time = new Time((Calendar)calendar);
        return time.toString();
    }

    public static @NonNull Time utilDate2XSDTime(@NonNull Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return new Time((Calendar)calendar);
    }

    public static @NonNull Date xsdDateTime2UtilDate(@NonNull XSDDateTime dateTime) {
        return XSDTimeUtil.xsdDateTimeString2UtilDate(dateTime.getContent());
    }

    public static @NonNull Date xsdDateTimeString2UtilDate(@NonNull String content) {
        try {
            return xsdDateTimeFormat.parse(content);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid xsd:DateTime " + content);
        }
    }

    public static @NonNull Date xsdDate2UtilDate(@NonNull XSDDate date) {
        return XSDTimeUtil.xsdDateString2UtilDate(date.getContent());
    }

    public static @NonNull Date xsdDateString2UtilDate(@NonNull String content) {
        try {
            return xsdDateFormat.parse(content);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid xsd:Date " + content);
        }
    }

    public static @NonNull Date xsdTimeString2UtilDate(@NonNull String content) {
        Time time = new Time(content);
        return time.getAsCalendar().getTime();
    }

    public static @NonNull Time xsdTimeString2AxisTime(@NonNull String content) {
        return new Time(content);
    }

    public static @NonNull Duration xsdDuration2AxisDuration(@NonNull XSDDuration duration) {
        return new Duration(duration.getContent());
    }

    public static @NonNull Duration xsdDurationString2AxisDuration(@NonNull String content) {
        return new Duration(content);
    }

    public static @NonNull String date2JDBCDateTimeString(@NonNull Date date) {
        return jdbcDateTimeFormat.format(date);
    }

    public static @NonNull String date2JDBCDateString(Date date) {
        return jdbcDateFormat.format(date);
    }

    public static @NonNull Date jdbcDateTimeString2UtilDate(@NonNull String content) {
        try {
            return jdbcDateTimeFormat.parse(content);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid JDBC datetime " + content);
        }
    }

    public static @NonNull Date jdbcDateString2UtilDate(@NonNull String content) {
        try {
            return jdbcDateFormat.parse(content);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid JDBC date " + content);
        }
    }

    public static boolean isValidXSDDateTimeString(@NonNull String content) {
        try {
            xsdDateTimeFormat.parse(content);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidXSDDateString(@NonNull String content) {
        try {
            xsdDateFormat.parse(content);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidXSDTimeString(@NonNull String content) {
        try {
            new Time(content);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidXSDDurationString(@NonNull String content) {
        try {
            new Duration(content);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidJDBCDateTimeString(@NonNull String content) {
        try {
            jdbcDateTimeFormat.parse(content);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static int addAxisDurationYears(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getYearsFromAxisDuration(duration1) + XSDTimeUtil.getYearsFromAxisDuration(duration2);
    }

    public static int addAxisDurationMonths(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getMonthsFromAxisDuration(duration1) + XSDTimeUtil.getMonthsFromAxisDuration(duration2);
    }

    public static int addAxisDurationDays(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getDaysFromAxisDuration(duration1) + XSDTimeUtil.getDaysFromAxisDuration(duration2);
    }

    public static int addAxisDurationHours(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getHoursFromAxisDuration(duration1) + XSDTimeUtil.getHoursFromAxisDuration(duration2);
    }

    public static int addAxisDurationMinutes(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getMinutesFromAxisDuration(duration1) + XSDTimeUtil.getMinutesFromAxisDuration(duration2);
    }

    public static double addAxisDurationSeconds(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getSecondsFromAxisDuration(duration1) + XSDTimeUtil.getSecondsFromAxisDuration(duration2);
    }

    public static int subtractAxisDurationYears(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getYearsFromAxisDuration(duration1) - XSDTimeUtil.getYearsFromAxisDuration(duration2);
    }

    public static int subtractAxisDurationMonths(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getMonthsFromAxisDuration(duration1) - XSDTimeUtil.getMonthsFromAxisDuration(duration2);
    }

    public static int subtractAxisDurationDays(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getDaysFromAxisDuration(duration1) - XSDTimeUtil.getDaysFromAxisDuration(duration2);
    }

    public static int subtractAxisDurationHours(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getHoursFromAxisDuration(duration1) - XSDTimeUtil.getHoursFromAxisDuration(duration2);
    }

    public static int subtractAxisDurationMinutes(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getMinutesFromAxisDuration(duration1) - XSDTimeUtil.getMinutesFromAxisDuration(duration2);
    }

    public static double subtractAxisDurationSeconds(@NonNull Duration duration1, @NonNull Duration duration2) {
        return XSDTimeUtil.getSecondsFromAxisDuration(duration1) - XSDTimeUtil.getSecondsFromAxisDuration(duration2);
    }

    private static int getYearsFromAxisDuration(@NonNull Duration duration) {
        if (duration.isNegative()) {
            return -duration.getYears();
        }
        return duration.getYears();
    }

    private static int getMonthsFromAxisDuration(@NonNull Duration duration) {
        if (duration.isNegative()) {
            return -duration.getMonths();
        }
        return duration.getMonths();
    }

    private static int getDaysFromAxisDuration(@NonNull Duration duration) {
        if (duration.isNegative()) {
            return -duration.getDays();
        }
        return duration.getDays();
    }

    private static int getHoursFromAxisDuration(@NonNull Duration duration) {
        if (duration.isNegative()) {
            return -duration.getHours();
        }
        return duration.getHours();
    }

    private static int getMinutesFromAxisDuration(@NonNull Duration duration) {
        if (duration.isNegative()) {
            return -duration.getMinutes();
        }
        return duration.getMinutes();
    }

    private static double getSecondsFromAxisDuration(@NonNull Duration duration) {
        if (duration.isNegative()) {
            return -duration.getSeconds();
        }
        return duration.getSeconds();
    }
}

