/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.owl2rl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.owl2rl.OWL2RLEngine;
import org.swrlapi.owl2rl.OWL2RLNames;
import org.swrlapi.owl2rl.OWL2RLPersistenceLayer;

public abstract class AbstractOWL2RLEngine
implements OWL2RLEngine {
    private final @NonNull Set<OWL2RLNames.OWL2RLRule> rules;
    private final @NonNull List<OWL2RLNames.OWL2RLRuleTable> ruleTables;
    private final @NonNull OWL2RLPersistenceLayer persistenceLayer;
    private final @NonNull Map<OWL2RLNames.OWL2RLRuleTable, @NonNull List<OWL2RLNames.OWL2RLRule>> table2RulesMap;
    private final @NonNull Set<@NonNull Set<OWL2RLNames.OWL2RLRule>> groupedRuleSets;
    private final @NonNull Set<OWL2RLNames.OWL2RLRule> unsupportedRules;
    private final @NonNull Set<OWL2RLNames.OWL2RLRule> permanentlyOnRules;
    private final @NonNull Set<OWL2RLNames.OWL2RLRule> switchableRules;
    private @NonNull Set<OWL2RLNames.OWL2RLRule> enabledRules;
    private boolean ruleSelectionChanged;

    protected AbstractOWL2RLEngine(@NonNull OWL2RLPersistenceLayer persistenceLayer, @NonNull Set<OWL2RLNames.OWL2RLRule> unsupportedRules, @NonNull Set<OWL2RLNames.OWL2RLRule> permanentlyOnRules, @NonNull Set<@NonNull Set<OWL2RLNames.OWL2RLRule>> groupedRuleSets) {
        this.persistenceLayer = persistenceLayer;
        this.rules = EnumSet.allOf(OWL2RLNames.OWL2RLRule.class);
        this.ruleTables = new ArrayList<OWL2RLNames.OWL2RLRuleTable>(Arrays.asList(OWL2RLNames.OWL2RLRuleTable.values()));
        this.table2RulesMap = new HashMap<OWL2RLNames.OWL2RLRuleTable, List<OWL2RLNames.OWL2RLRule>>();
        this.table2RulesMap.put(OWL2RLNames.OWL2RLRuleTable.RuleTable4, new ArrayList<OWL2RLNames.OWL2RLRule>(Arrays.asList(Table4Rules)));
        this.table2RulesMap.put(OWL2RLNames.OWL2RLRuleTable.RuleTable5, new ArrayList<OWL2RLNames.OWL2RLRule>(Arrays.asList(Table5Rules)));
        this.table2RulesMap.put(OWL2RLNames.OWL2RLRuleTable.RuleTable6, new ArrayList<OWL2RLNames.OWL2RLRule>(Arrays.asList(Table6Rules)));
        this.table2RulesMap.put(OWL2RLNames.OWL2RLRuleTable.RuleTable7, new ArrayList<OWL2RLNames.OWL2RLRule>(Arrays.asList(Table7Rules)));
        this.table2RulesMap.put(OWL2RLNames.OWL2RLRuleTable.RuleTable8, new ArrayList<OWL2RLNames.OWL2RLRule>(Arrays.asList(Table8Rules)));
        this.table2RulesMap.put(OWL2RLNames.OWL2RLRuleTable.RuleTable9, new ArrayList<OWL2RLNames.OWL2RLRule>(Arrays.asList(Table9Rules)));
        this.unsupportedRules = unsupportedRules;
        this.permanentlyOnRules = permanentlyOnRules;
        this.groupedRuleSets = groupedRuleSets;
        this.switchableRules = new HashSet<OWL2RLNames.OWL2RLRule>(this.rules);
        this.switchableRules.removeAll(this.permanentlyOnRules);
        this.switchableRules.removeAll(this.unsupportedRules);
        this.enabledRules = new HashSet<OWL2RLNames.OWL2RLRule>(this.switchableRules);
        this.enabledRules.addAll(this.permanentlyOnRules);
        this.enabledRules.retainAll(persistenceLayer.getEnabledRules());
        this.ruleSelectionChanged = false;
    }

    @Override
    public void resetRuleSelectionChanged() {
        this.ruleSelectionChanged = false;
    }

    @Override
    public void setRuleSelectionChanged() {
        this.ruleSelectionChanged = true;
    }

    @Override
    public boolean hasRuleSelectionChanged() {
        return this.ruleSelectionChanged;
    }

    @Override
    public @NonNull List<OWL2RLNames.OWL2RLRuleTable> getRuleTables() {
        return this.ruleTables;
    }

    @Override
    public int getNumberOfRules() {
        return this.rules.size();
    }

    @Override
    public int getNumberOfTables() {
        return this.ruleTables.size();
    }

    @Override
    public @NonNull List<OWL2RLNames.OWL2RLRule> getRules() {
        return new ArrayList<OWL2RLNames.OWL2RLRule>(this.rules);
    }

    @Override
    public @NonNull List<OWL2RLNames.OWL2RLRule> getRules(OWL2RLNames.OWL2RLRuleTable table) {
        return this.table2RulesMap.get((Object)table);
    }

    @Override
    public @NonNull Set<OWL2RLNames.OWL2RLRule> getEnabledRules() {
        return this.enabledRules;
    }

    @Override
    public @NonNull Set<OWL2RLNames.OWL2RLRule> getUnsupportedRules() {
        return this.unsupportedRules;
    }

    @Override
    public @NonNull Set<OWL2RLNames.OWL2RLRule> getPermanentlyOnRules() {
        return this.permanentlyOnRules;
    }

    @Override
    public @NonNull Set<OWL2RLNames.OWL2RLRule> getSwitchableRules() {
        return this.switchableRules;
    }

    @Override
    public void enableAll() {
        this.enabledRules = this.switchableRules;
        this.setRuleSelectionChanged();
        this.getOWL2RLPersistenceLayer().setEnabledRules(this.enabledRules);
    }

    @Override
    public void disableAll() {
        this.enabledRules.clear();
        this.setRuleSelectionChanged();
        this.getOWL2RLPersistenceLayer().disableAll();
    }

    @Override
    public void enableTables(OWL2RLNames.OWL2RLRuleTable ... enabledTables) {
        for (OWL2RLNames.OWL2RLRuleTable table : enabledTables) {
            this.enabledRules.addAll(this.table2RulesMap.get((Object)table).stream().collect(Collectors.toList()));
        }
        this.setRuleSelectionChanged();
        this.getOWL2RLPersistenceLayer().setEnabledRules(this.enabledRules);
    }

    @Override
    public void disableTables(OWL2RLNames.OWL2RLRuleTable ... disabledTables) {
        HashSet<OWL2RLNames.OWL2RLRule> disabledRules = new HashSet<OWL2RLNames.OWL2RLRule>();
        for (OWL2RLNames.OWL2RLRuleTable table : disabledTables) {
            disabledRules.addAll(this.table2RulesMap.get((Object)table).stream().collect(Collectors.toList()));
        }
        this.enabledRules.removeAll(disabledRules);
        this.setRuleSelectionChanged();
        this.getOWL2RLPersistenceLayer().setDisabledRules(disabledRules);
    }

    @Override
    public void enableRules(OWL2RLNames.OWL2RLRule ... rulesToEnable) {
        for (OWL2RLNames.OWL2RLRule rule : rulesToEnable) {
            this.enableRule(rule);
        }
        this.setRuleSelectionChanged();
        this.getOWL2RLPersistenceLayer().setEnabledRules(this.enabledRules);
    }

    @Override
    public @NonNull OWL2RLPersistenceLayer getOWL2RLPersistenceLayer() {
        return this.persistenceLayer;
    }

    private void enableRule(OWL2RLNames.OWL2RLRule rule) {
        this.enabledRules.addAll(this.getGroup(rule).stream().collect(Collectors.toList()));
        this.setRuleSelectionChanged();
        this.getOWL2RLPersistenceLayer().setEnabledRules(this.enabledRules);
    }

    @Override
    public void disableRules(OWL2RLNames.OWL2RLRule ... rulesToDisable) {
        for (OWL2RLNames.OWL2RLRule rule : rulesToDisable) {
            this.disableRule(rule);
        }
    }

    private void disableRule(OWL2RLNames.OWL2RLRule rule) {
        for (OWL2RLNames.OWL2RLRule groupedRule : this.getGroup(rule)) {
            this.enabledRules.remove((Object)groupedRule);
            this.setRuleSelectionChanged();
            this.getOWL2RLPersistenceLayer().setDisabledRule(rule);
        }
    }

    @Override
    public boolean isRuleEnabled(OWL2RLNames.OWL2RLRule rule) {
        return this.enabledRules.contains((Object)rule);
    }

    @Override
    public boolean hasEnabledRules(OWL2RLNames.OWL2RLRuleTable table) {
        for (OWL2RLNames.OWL2RLRule rule : this.getRules(table)) {
            if (!this.isRuleEnabled(rule)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSwitchableRules(OWL2RLNames.OWL2RLRuleTable table) {
        for (OWL2RLNames.OWL2RLRule rule : this.getRules(table)) {
            if (!this.isRuleSwitchable(rule)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OWL2RLEngine.OWL2RLRuleStatus getRuleStatus(OWL2RLNames.OWL2RLRule rule) {
        if (this.unsupportedRules.contains((Object)rule)) {
            return OWL2RLEngine.OWL2RLRuleStatus.Unsupported;
        }
        if (this.permanentlyOnRules.contains((Object)rule)) {
            return OWL2RLEngine.OWL2RLRuleStatus.PermanentlyOn;
        }
        return OWL2RLEngine.OWL2RLRuleStatus.Switchable;
    }

    private @NonNull Set<OWL2RLNames.OWL2RLRule> getGroup(OWL2RLNames.OWL2RLRule rule) {
        HashSet<OWL2RLNames.OWL2RLRule> result = new HashSet<OWL2RLNames.OWL2RLRule>();
        result.add(rule);
        this.groupedRuleSets.stream().filter(group -> group.contains((Object)rule)).forEach(result::addAll);
        return result;
    }

    private boolean isRuleSwitchable(OWL2RLNames.OWL2RLRule rule) {
        return this.switchableRules.contains((Object)rule);
    }
}

