/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.swrlapi.core.SWRLAPIOWLOntology;
import org.swrlapi.parser.SWRLIncompleteRuleException;
import org.swrlapi.parser.SWRLParseException;
import org.swrlapi.parser.SWRLParserSupport;
import org.swrlapi.parser.SWRLToken;
import org.swrlapi.parser.SWRLTokenizer;

public class SWRLParser {
    public static final char CONJUNCTION_CHAR = '^';
    public static final String IMP_COMBINATION = "->";
    public static final char RING_CHAR = '\u02da';
    private static final String SAME_AS_PREDICATE = "sameAs";
    private static final String DIFFERENT_FROM_PREDICATE = "differentFrom";
    private final @NonNull SWRLParserSupport swrlParserSupport;

    public SWRLParser(@NonNull SWRLAPIOWLOntology swrlapiOWLOntology) {
        this.swrlParserSupport = new SWRLParserSupport(swrlapiOWLOntology);
    }

    public Optional<@NonNull SWRLRule> parseSWRLRule(@NonNull String ruleText, boolean interactiveParseOnly, @NonNull String ruleName, @NonNull String comment) throws SWRLParseException {
        SWRLTokenizer tokenizer = new SWRLTokenizer(ruleText.trim(), interactiveParseOnly);
        Optional head = !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLHeadAtomList()) : Optional.empty();
        Optional body = !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLBodyAtomList()) : Optional.empty();
        boolean atLeastOneAtom = false;
        boolean justProcessedAtom = false;
        boolean isInHead = false;
        if (!tokenizer.isInteractiveParseOnly() && !tokenizer.hasMoreTokens()) {
            throw new SWRLParseException("Empty!");
        }
        do {
            String message;
            SWRLToken currentToken;
            if ((currentToken = tokenizer.getToken(message = justProcessedAtom ? (isInHead ? "Expecting ^" : "Expecting ->, ^ or \u02da") : (isInHead ? "Expecting atom" : "Expecting atom,-> or \u02da"))).isImp()) {
                if (isInHead) {
                    throw new SWRLParseException("Second occurrence of ^");
                }
                isInHead = true;
            } else if (currentToken.isConjunction()) {
                if (!justProcessedAtom) {
                    throw new SWRLParseException("^ may occur only after an atom");
                }
            } else {
                if (currentToken.isAnd()) {
                    throw new SWRLParseException("AND may be used only in a class or property expression");
                }
                if (currentToken.isOr()) {
                    throw new SWRLParseException("OR may be used only in a class or property expression ");
                }
                if (currentToken.isNot()) {
                    throw new SWRLParseException("NOT may be used only in a class or property expression");
                }
                if (currentToken.isRing()) {
                    if (isInHead) {
                        throw new SWRLParseException(". may only occur in query body");
                    }
                } else if (!currentToken.isLParen()) {
                    Optional<? extends SWRLAtom> atom;
                    String shortName;
                    if (currentToken.isShortName()) {
                        shortName = currentToken.getValue();
                        atom = this.parseSWRLAtom(shortName, tokenizer, isInHead);
                        atLeastOneAtom = true;
                        if (!tokenizer.isInteractiveParseOnly()) {
                            if (isInHead) {
                                ((Set)head.get()).add(atom.get());
                            } else {
                                ((Set)body.get()).add(atom.get());
                            }
                        }
                    } else if (currentToken.isIRI()) {
                        shortName = this.swrlParserSupport.getShortNameFromIRI(currentToken.getValue(), tokenizer.isInteractiveParseOnly());
                        atom = this.parseSWRLAtom(shortName, tokenizer, isInHead);
                        atLeastOneAtom = true;
                        if (!tokenizer.isInteractiveParseOnly()) {
                            if (isInHead) {
                                ((Set)head.get()).add(atom.get());
                            } else {
                                ((Set)body.get()).add(atom.get());
                            }
                        }
                    } else {
                        throw new SWRLParseException("Unexpected token '" + currentToken.getValue() + "'");
                    }
                }
            }
            justProcessedAtom = true;
        } while (tokenizer.hasMoreTokens());
        if (!tokenizer.isInteractiveParseOnly()) {
            if (!atLeastOneAtom) {
                throw new SWRLParseException("Incomplete - no antecedent or consequent");
            }
            return Optional.of(this.swrlParserSupport.createSWRLRule(ruleName, (Set)head.get(), (Set)body.get(), comment, true));
        }
        return Optional.empty();
    }

    public boolean isSWRLRuleCorrectButPossiblyIncomplete(@NonNull String ruleText) {
        try {
            this.parseSWRLRule(ruleText, true, "", "");
            return true;
        }
        catch (SWRLIncompleteRuleException e) {
            return true;
        }
        catch (SWRLParseException e) {
            return false;
        }
    }

    public boolean isSWRLRuleCorrectAndComplete(@NonNull String ruleText) {
        try {
            this.parseSWRLRule(ruleText, false, "", "");
            return true;
        }
        catch (SWRLParseException e) {
            return false;
        }
    }

    public static int findSplittingPoint(@NonNull String ruleText) {
        int i;
        for (i = ruleText.length() - 1; i >= 0 && !SWRLTokenizer.isOrdinaryChar(ruleText.charAt(i)) && ruleText.charAt(i) != '\"' && ruleText.charAt(i) != ' '; --i) {
        }
        return i + 1;
    }

    private Optional<? extends @NonNull SWRLAtom> parseSWRLAtom(@NonNull String shortName, @NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        if (shortName.equalsIgnoreCase(SAME_AS_PREDICATE)) {
            tokenizer.checkAndSkipLParen("Expecting parentheses-enclosed arguments for same individual atom");
            return this.parseSWRLSameAsAtomArguments(tokenizer, isInHead);
        }
        if (shortName.equalsIgnoreCase(DIFFERENT_FROM_PREDICATE)) {
            tokenizer.checkAndSkipLParen("Expecting parentheses-enclosed arguments for different individuals atom");
            return this.parseSWRLDifferentFromAtomArguments(tokenizer, isInHead);
        }
        if (this.swrlParserSupport.isSWRLBuiltIn(shortName)) {
            tokenizer.checkAndSkipLParen("Expecting parentheses-enclosed arguments for built-in atom");
            return this.parseSWRLBuiltinAtomArguments(shortName, tokenizer, isInHead);
        }
        if (this.swrlParserSupport.isOWLClass(shortName)) {
            tokenizer.checkAndSkipLParen("Expecting parentheses-enclosed arguments for class atom");
            return this.parseSWRLClassAtomArguments(shortName, tokenizer, isInHead);
        }
        if (this.swrlParserSupport.isOWLObjectProperty(shortName)) {
            tokenizer.checkAndSkipLParen("Expecting parentheses-enclosed arguments for object property atom");
            return this.parseSWRLObjectPropertyAtomArguments(shortName, tokenizer, isInHead);
        }
        if (this.swrlParserSupport.isOWLDataProperty(shortName)) {
            tokenizer.checkAndSkipLParen("Expecting parentheses-enclosed arguments for data property atom");
            return this.parseSWRLDataPropertyAtomArguments(shortName, tokenizer, isInHead);
        }
        if (this.swrlParserSupport.isOWLDatatype(shortName)) {
            tokenizer.checkAndSkipLParen("Expecting parentheses-enclosed arguments for data range atom");
            return this.parseSWRLDataRangeAtomArguments(shortName, tokenizer, isInHead);
        }
        throw this.generateEndOfRuleException("Invalid SWRL atom predicate '" + shortName + "'", tokenizer);
    }

    private Optional<SWRLClassAtom> parseSWRLClassAtomArguments(@NonNull String classShortName, @NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        Optional<? extends @NonNull SWRLIArgument> iArgument = this.parseSWRLIArgument(tokenizer, isInHead);
        tokenizer.checkAndSkipRParen("Expecting closing parenthesis after argument for class atom " + classShortName);
        return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLClassAtom(classShortName, iArgument.get())) : Optional.empty();
    }

    private Optional<@NonNull SWRLObjectPropertyAtom> parseSWRLObjectPropertyAtomArguments(@NonNull String propertyShortName, @NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        Optional<? extends @NonNull SWRLIArgument> iArgument1 = this.parseSWRLIArgument(tokenizer, isInHead);
        tokenizer.checkAndSkipComma("Expecting comma-separated second argument for object property atom " + propertyShortName);
        Optional<? extends @NonNull SWRLIArgument> iArgument2 = this.parseSWRLIArgument(tokenizer, isInHead);
        tokenizer.checkAndSkipRParen("Expecting closing parenthesis after second argument of object property atom " + propertyShortName);
        return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLObjectPropertyAtom(propertyShortName, iArgument1.get(), iArgument2.get())) : Optional.empty();
    }

    private Optional<@NonNull SWRLDataPropertyAtom> parseSWRLDataPropertyAtomArguments(@NonNull String propertyShortName, @NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        Optional<? extends @NonNull SWRLIArgument> iArgument = this.parseSWRLIArgument(tokenizer, isInHead);
        tokenizer.checkAndSkipComma("Expecting comma-separated second parameter for data property atom " + propertyShortName);
        Optional<? extends @NonNull SWRLDArgument> dArgument = this.parseSWRLDArgument(tokenizer, isInHead, false);
        tokenizer.checkAndSkipRParen("Expecting closing parenthesis after second argument of data property atom " + propertyShortName);
        return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLDataPropertyAtom(propertyShortName, iArgument.get(), dArgument.get())) : Optional.empty();
    }

    private Optional<@NonNull SWRLBuiltInAtom> parseSWRLBuiltinAtomArguments(@NonNull String builtInPrefixedName, @NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        Optional<@NonNull List<@NonNull SWRLDArgument>> dArgumentList = this.parseSWRLDArgumentList(tokenizer, isInHead);
        return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLBuiltInAtom(builtInPrefixedName, dArgumentList.get())) : Optional.empty();
    }

    private Optional<@NonNull SWRLDataRangeAtom> parseSWRLDataRangeAtomArguments(@NonNull String datatypePrefixedName, @NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        Optional<? extends @NonNull SWRLDArgument> dArgument = this.parseSWRLDArgument(tokenizer, isInHead, false);
        tokenizer.checkAndSkipRParen("Expecting closing parenthesis after argument for data range atom " + datatypePrefixedName);
        return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLDataRangeAtom(datatypePrefixedName, dArgument.get())) : Optional.empty();
    }

    private Optional<@NonNull SWRLSameIndividualAtom> parseSWRLSameAsAtomArguments(@NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        Optional<? extends @NonNull SWRLIArgument> iArgument1 = this.parseSWRLIArgument(tokenizer, isInHead);
        tokenizer.checkAndSkipComma("Expecting comma-separated second argument for same individual atom");
        Optional<? extends @NonNull SWRLIArgument> iArgument2 = this.parseSWRLIArgument(tokenizer, isInHead);
        tokenizer.checkAndSkipRParen("Expecting closing parenthesis after second argument to same individual atom");
        return tokenizer.isInteractiveParseOnly() ? Optional.empty() : Optional.of(this.swrlParserSupport.createSWRLSameIndividualAtom(iArgument1.get(), iArgument2.get()));
    }

    private Optional<@NonNull SWRLDifferentIndividualsAtom> parseSWRLDifferentFromAtomArguments(@NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        Optional<? extends @NonNull SWRLIArgument> iArgument1 = this.parseSWRLIArgument(tokenizer, isInHead);
        tokenizer.checkAndSkipComma("Expecting comma-separated second argument for different individuals atom");
        Optional<? extends @NonNull SWRLIArgument> iArgument2 = this.parseSWRLIArgument(tokenizer, isInHead);
        tokenizer.checkAndSkipRParen("Expecting closing parenthesis after second argument to different individuals atom");
        return tokenizer.isInteractiveParseOnly() ? Optional.empty() : Optional.of(this.swrlParserSupport.createSWRLDifferentIndividualsAtom(iArgument1.get(), iArgument2.get()));
    }

    private Optional<@NonNull SWRLVariable> parseSWRLVariable(@NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        SWRLToken token = tokenizer.getToken(SWRLToken.SWRLTokenType.SHORTNAME, "Expecting variable name after ?");
        String variableName = token.getValue();
        this.swrlParserSupport.checkThatSWRLVariableNameIsValid(variableName);
        if (tokenizer.hasMoreTokens()) {
            if (!isInHead) {
                tokenizer.addVariable(variableName);
            } else if (!tokenizer.hasVariable(variableName)) {
                throw new SWRLParseException("Variable ?" + variableName + " used in consequent is not present in antecedent");
            }
        }
        return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLVariable(variableName)) : Optional.empty();
    }

    private Optional<? extends @NonNull SWRLIArgument> parseSWRLIArgument(@NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        SWRLToken token = tokenizer.getToken("Expecting variable or OWL individual name");
        if (token.isQuestion()) {
            return this.parseSWRLVariable(tokenizer, isInHead);
        }
        if (token.isShortName()) {
            String identifier = token.getValue();
            if (this.swrlParserSupport.isOWLNamedIndividual(identifier)) {
                return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLIndividualArgument(identifier)) : Optional.empty();
            }
            throw this.generateEndOfRuleException("Invalid OWL individual name '" + token.getValue() + "'", tokenizer);
        }
        throw new SWRLParseException("Expecting variable or OWL individual name, got '" + token.getValue() + "'");
    }

    private Optional<? extends @NonNull SWRLDArgument> parseSWRLDArgument(@NonNull SWRLTokenizer tokenizer, boolean isInHead, boolean isInBuiltIn) throws SWRLParseException {
        String message = isInBuiltIn ? "Expecting variable, literal or OWL entity name for built-in atom argument" : "Expecting variable or literal for datatype atom argument";
        SWRLToken token = tokenizer.getToken(message);
        if (token.isQuestion()) {
            return this.parseSWRLVariable(tokenizer, isInHead);
        }
        if (token.isShortName()) {
            String shortName = token.getValue();
            return this.parseShortNameSWRLDArgument(tokenizer, isInBuiltIn, shortName);
        }
        if (token.isString()) {
            String literalValue = token.getValue();
            return this.parseLiteralSWRLDArgument(tokenizer, literalValue);
        }
        if (token.isInteger()) {
            return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createXSDIntegerSWRLLiteralArgument(token.getValue())) : Optional.empty();
        }
        if (token.isDecimal()) {
            return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createXSDDecimalSWRLLiteralArgument(token.getValue())) : Optional.empty();
        }
        throw new SWRLParseException("Expecting variable, literal or OWL entity name, got '" + token.getValue() + "'");
    }

    private Optional<@NonNull SWRLDArgument> parseLiteralSWRLDArgument(@NonNull SWRLTokenizer tokenizer, @NonNull String literalValue) throws SWRLParseException {
        if (tokenizer.peekToken("String may be qualified with datatype").isConjunction()) {
            tokenizer.skipToken();
            throw this.generateEndOfRuleException("Partial datatype qualifier - add '^' to complete", tokenizer);
        }
        if (tokenizer.peekToken("String may be qualified with datatype").isTypeQualifier()) {
            tokenizer.skipToken();
            SWRLToken datatypeToken = tokenizer.getToken(SWRLToken.SWRLTokenType.SHORTNAME, "Expecting datatype after ^^");
            String datatype = datatypeToken.getValue();
            if (datatype.length() == 0) {
                throw this.generateEndOfRuleException("Empty datatype qualifier - must supply a datatype after ^^", tokenizer);
            }
            if (!this.swrlParserSupport.isOWLDatatype(datatype)) {
                throw this.generateEndOfRuleException("invalid datatype name '" + datatype + "'", tokenizer);
            }
            return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createSWRLLiteralArgument(literalValue, datatype)) : Optional.empty();
        }
        return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createXSDStringSWRLLiteralArgument(literalValue)) : Optional.empty();
    }

    private Optional<@NonNull SWRLDArgument> parseShortNameSWRLDArgument(@NonNull SWRLTokenizer tokenizer, boolean isInBuiltIn, @NonNull String shortName) throws SWRLParseException {
        if (shortName.equalsIgnoreCase("true") || shortName.equalsIgnoreCase("false")) {
            return !tokenizer.isInteractiveParseOnly() ? Optional.of(this.swrlParserSupport.createXSDBooleanSWRLLiteralArgument(shortName)) : Optional.empty();
        }
        if (isInBuiltIn) {
            if (this.swrlParserSupport.isOWLNamedIndividual(shortName)) {
                return tokenizer.isInteractiveParseOnly() ? Optional.empty() : Optional.of(this.swrlParserSupport.createSWRLNamedIndividualBuiltInArgument(shortName));
            }
            if (this.swrlParserSupport.isOWLClass(shortName)) {
                return tokenizer.isInteractiveParseOnly() ? Optional.empty() : Optional.of(this.swrlParserSupport.createSWRLClassBuiltInArgument(shortName));
            }
            if (this.swrlParserSupport.isOWLObjectProperty(shortName)) {
                return tokenizer.isInteractiveParseOnly() ? Optional.empty() : Optional.of(this.swrlParserSupport.createSWRLObjectPropertyBuiltInArgument(shortName));
            }
            if (this.swrlParserSupport.isOWLDataProperty(shortName)) {
                return tokenizer.isInteractiveParseOnly() ? Optional.empty() : Optional.of(this.swrlParserSupport.createSWRLDataPropertyBuiltInArgument(shortName));
            }
            if (this.swrlParserSupport.isOWLAnnotationProperty(shortName)) {
                return tokenizer.isInteractiveParseOnly() ? Optional.empty() : Optional.of(this.swrlParserSupport.createSWRLAnnotationPropertyBuiltInArgument(shortName));
            }
            if (this.swrlParserSupport.isOWLDatatype(shortName)) {
                return tokenizer.isInteractiveParseOnly() ? Optional.empty() : Optional.of(this.swrlParserSupport.createSWRLDatatypeBuiltInArgument(shortName));
            }
            throw this.generateEndOfRuleException("Expecting boolean or OWL entity name, got '" + shortName + "'", tokenizer);
        }
        throw this.generateEndOfRuleException("Expecting boolean, got '" + shortName + "'", tokenizer);
    }

    private Optional<@NonNull List<@NonNull SWRLDArgument>> parseSWRLDArgumentList(@NonNull SWRLTokenizer tokenizer, boolean isInHead) throws SWRLParseException {
        Optional<@NonNull List<@NonNull SWRLDArgument>> dArguments = !tokenizer.isInteractiveParseOnly() ? Optional.of(new ArrayList()) : Optional.empty();
        Optional<? extends @NonNull SWRLDArgument> dArgument = this.parseSWRLDArgument(tokenizer, isInHead, true);
        if (!tokenizer.isInteractiveParseOnly()) {
            ((List)dArguments.get()).add(dArgument.get());
        }
        SWRLToken token = tokenizer.getToken("Expecting additional comma-separated built-in arguments or closing parenthesis");
        while (token.isComma()) {
            dArgument = this.parseSWRLDArgument(tokenizer, isInHead, true);
            if (!tokenizer.isInteractiveParseOnly()) {
                dArguments.get().add(dArgument.get());
            }
            if ((token = tokenizer.getToken("Expecting ',' or ')'")).isComma() || token.isRParen()) continue;
            throw new SWRLParseException("Expecting ',' or ')', got '" + token.getValue() + "'");
        }
        return dArguments;
    }

    private @NonNull SWRLParseException generateEndOfRuleException(@NonNull String message, @NonNull SWRLTokenizer tokenizer) {
        if (tokenizer.hasMoreTokens() || !tokenizer.isInteractiveParseOnly()) {
            return new SWRLParseException(message);
        }
        return new SWRLIncompleteRuleException(message);
    }
}

