/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLAPIOWLOntology;
import org.swrlapi.factory.OWLLiteralFactory;
import org.swrlapi.factory.SWRLAPIOWLDataFactory;
import org.swrlapi.factory.SWRLBuiltInArgumentFactory;
import org.swrlapi.parser.SWRLIncompleteRuleException;
import org.swrlapi.parser.SWRLParseException;

class SWRLParserSupport {
    private static final Logger log = LoggerFactory.getLogger(SWRLParserSupport.class);
    private final @NonNull SWRLAPIOWLOntology swrlapiOWLOntology;

    public SWRLParserSupport(@NonNull SWRLAPIOWLOntology swrlapiOWLOntology) {
        this.swrlapiOWLOntology = swrlapiOWLOntology;
    }

    public boolean isOWLEntity(@NonNull String shortName) {
        return this.isOWLClass(shortName) || this.isOWLNamedIndividual(shortName) || this.isOWLObjectProperty(shortName) || this.isOWLDataProperty(shortName) || this.isOWLAnnotationProperty(shortName) || this.isOWLDatatype(shortName);
    }

    public boolean isOWLClass(@NonNull String shortName) {
        IRI classIRI = this.prefixedName2IRI(shortName);
        return this.getOWLOntology().containsClassInSignature(classIRI, Imports.INCLUDED) || classIRI.equals((Object)OWLRDFVocabulary.OWL_THING.getIRI()) || classIRI.equals((Object)OWLRDFVocabulary.OWL_NOTHING.getIRI());
    }

    public boolean isOWLNamedIndividual(@NonNull String shortName) {
        IRI individualIRI = this.prefixedName2IRI(shortName);
        return this.getOWLOntology().containsIndividualInSignature(individualIRI, Imports.INCLUDED);
    }

    public boolean isOWLObjectProperty(@NonNull String shortName) {
        IRI propertyIRI = this.prefixedName2IRI(shortName);
        return this.getOWLOntology().containsObjectPropertyInSignature(propertyIRI, Imports.INCLUDED);
    }

    public boolean isOWLDataProperty(@NonNull String shortName) {
        IRI propertyIRI = this.prefixedName2IRI(shortName);
        return this.getOWLOntology().containsDataPropertyInSignature(propertyIRI, Imports.INCLUDED);
    }

    public boolean isOWLAnnotationProperty(@NonNull String shortName) {
        IRI propertyIRI = this.prefixedName2IRI(shortName);
        return this.getOWLOntology().containsAnnotationPropertyInSignature(propertyIRI, Imports.INCLUDED);
    }

    public boolean isOWLDatatype(@NonNull String shortName) {
        if (shortName.equals("rdf:PlainLiteral") || shortName.equals("rdfs:Literal") || shortName.equals("rdf:XMLLiteral")) {
            return true;
        }
        try {
            XSDVocabulary.parseShortName((String)shortName);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isSWRLBuiltIn(@NonNull String prefixedName) {
        return this.getSWRLAPIOWLOntology().isSWRLBuiltIn(prefixedName);
    }

    public Optional<@NonNull IRI> swrlBuiltInPrefixedName2IRI(@NonNull String prefixedName) {
        return this.getSWRLAPIOWLOntology().swrlBuiltInPrefixedName2IRI(prefixedName);
    }

    public void checkThatSWRLVariableNameIsValid(@NonNull String variableName) throws SWRLParseException {
        if (!this.isValidSWRLVariableName(variableName)) {
            throw new SWRLParseException("Invalid SWRL variable name " + variableName);
        }
        if (this.isOWLEntity(variableName)) {
            throw new SWRLParseException("Invalid SWRL variable name " + variableName + " - cannot use name of existing OWL class, individual, property, or datatype");
        }
    }

    public @NonNull SWRLVariable createSWRLVariable(@NonNull String variableName) throws SWRLParseException {
        if (this.isOWLEntity(variableName)) {
            throw new SWRLParseException(variableName + " cannot be used as a SWRL variable name because it refers to an existing OWL entity");
        }
        Optional<IRI> iri = this.getIRIResolver().variableName2IRI(variableName);
        if (iri.isPresent()) {
            return this.getOWLDataFactory().getSWRLVariable(iri.get());
        }
        throw new SWRLParseException("error creating SWRL variable " + variableName);
    }

    public @NonNull SWRLLiteralArgument createXSDStringSWRLLiteralArgument(@NonNull String lexicalValue) {
        OWLLiteral owlLiteral = this.getOWLLiteralFactory().getOWLLiteral(lexicalValue);
        return this.getOWLDataFactory().getSWRLLiteralArgument(owlLiteral);
    }

    public @NonNull SWRLLiteralArgument createXSDBooleanSWRLLiteralArgument(@NonNull String lexicalValue) throws SWRLParseException {
        try {
            Boolean value = Boolean.parseBoolean(lexicalValue);
            OWLLiteral owlLiteral = this.getOWLLiteralFactory().getOWLLiteral(value);
            return this.getOWLDataFactory().getSWRLLiteralArgument(owlLiteral);
        }
        catch (NumberFormatException e) {
            throw new SWRLParseException(lexicalValue + " is not a valid xsd:boolean");
        }
    }

    public @NonNull SWRLLiteralArgument createXSDIntegerSWRLLiteralArgument(@NonNull String lexicalValue) throws SWRLParseException {
        try {
            BigInteger value = new BigInteger(lexicalValue);
            OWLLiteral owlLiteral = this.getOWLLiteralFactory().getOWLLiteral(value);
            return this.getOWLDataFactory().getSWRLLiteralArgument(owlLiteral);
        }
        catch (NumberFormatException e) {
            throw new SWRLParseException(lexicalValue + " is not a valid xsd:int");
        }
    }

    public @NonNull SWRLLiteralArgument createXSDDecimalSWRLLiteralArgument(@NonNull String lexicalValue) throws SWRLParseException {
        try {
            BigDecimal value = new BigDecimal(lexicalValue);
            OWLLiteral owlLiteral = this.getOWLLiteralFactory().getOWLLiteral(value);
            return this.getOWLDataFactory().getSWRLLiteralArgument(owlLiteral);
        }
        catch (NumberFormatException e) {
            throw new SWRLParseException(lexicalValue + " is not a valid xsd:int");
        }
    }

    public @NonNull SWRLLiteralArgument createSWRLLiteralArgument(@NonNull String lexicalValue, @NonNull String datatypeShortName) throws SWRLParseException {
        OWLDatatype owlDatatype = this.createOWLDatatype(datatypeShortName);
        try {
            OWLLiteral literal = this.getOWLLiteralFactory().getOWLLiteral(lexicalValue, owlDatatype);
            return this.getOWLDataFactory().getSWRLLiteralArgument(literal);
        }
        catch (RuntimeException e) {
            throw new SWRLParseException(e.getMessage() == null ? "" : e.getMessage());
        }
    }

    public @NonNull SWRLRule createSWRLRule(@NonNull String ruleName, @NonNull Set<@NonNull SWRLAtom> head, @NonNull Set<@NonNull SWRLAtom> body, @NonNull String comment, boolean isEnabled) {
        Set<@NonNull OWLAnnotation> annotations = this.swrlapiOWLOntology.generateRuleAnnotations(ruleName, comment, isEnabled);
        return this.getOWLDataFactory().getSWRLRule(body, head, annotations);
    }

    public @NonNull Set<@NonNull SWRLAtom> createSWRLBodyAtomList() {
        return new LinkedHashSet<SWRLAtom>();
    }

    public @NonNull Set<@NonNull SWRLAtom> createSWRLHeadAtomList() {
        return new LinkedHashSet<SWRLAtom>();
    }

    public @NonNull SWRLClassAtom createSWRLClassAtom(@NonNull String classShortName, @NonNull SWRLIArgument iArgument) throws SWRLParseException {
        OWLClass cls = this.createOWLClass(classShortName);
        return this.getOWLDataFactory().getSWRLClassAtom((OWLClassExpression)cls, iArgument);
    }

    public @NonNull SWRLObjectPropertyAtom createSWRLObjectPropertyAtom(@NonNull String objectPropertyShortName, @NonNull SWRLIArgument iArgument1, @NonNull SWRLIArgument iArgument2) throws SWRLParseException {
        OWLObjectProperty objectProperty = this.createOWLObjectProperty(objectPropertyShortName);
        return this.getOWLDataFactory().getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)objectProperty, iArgument1, iArgument2);
    }

    public @NonNull SWRLDataPropertyAtom createSWRLDataPropertyAtom(@NonNull String dataPropertyShortName, @NonNull SWRLIArgument iArgument, @NonNull SWRLDArgument dArgument) throws SWRLParseException {
        OWLDataProperty dataProperty = this.createOWLDataProperty(dataPropertyShortName);
        return this.getOWLDataFactory().getSWRLDataPropertyAtom((OWLDataPropertyExpression)dataProperty, iArgument, dArgument);
    }

    public @NonNull SWRLDataRangeAtom createSWRLDataRangeAtom(@NonNull String datatypeShortName, @NonNull SWRLDArgument dArgument) throws SWRLParseException {
        OWLDatatype dataRange = this.createOWLDatatype(datatypeShortName);
        return this.getOWLDataFactory().getSWRLDataRangeAtom((OWLDataRange)dataRange, dArgument);
    }

    public @NonNull SWRLBuiltInAtom createSWRLBuiltInAtom(@NonNull String builtInPrefixedName, @NonNull List<@NonNull SWRLDArgument> arguments) throws SWRLParseException {
        IRI builtInIRI = this.createSWRLBuiltInIRI(builtInPrefixedName);
        return this.getOWLDataFactory().getSWRLBuiltInAtom(builtInIRI, arguments);
    }

    public @NonNull SWRLSameIndividualAtom createSWRLSameIndividualAtom(@NonNull SWRLIArgument iArgument1, @NonNull SWRLIArgument iArgument2) {
        return this.getOWLDataFactory().getSWRLSameIndividualAtom(iArgument1, iArgument2);
    }

    public @NonNull SWRLDifferentIndividualsAtom createSWRLDifferentIndividualsAtom(@NonNull SWRLIArgument iArgument1, @NonNull SWRLIArgument iArgument2) {
        return this.getOWLDataFactory().getSWRLDifferentIndividualsAtom(iArgument1, iArgument2);
    }

    public @NonNull SWRLIndividualArgument createSWRLIndividualArgument(@NonNull String individualShortName) throws SWRLParseException {
        OWLNamedIndividual individual = this.createOWLNamedIndividual(individualShortName);
        return this.getOWLDataFactory().getSWRLIndividualArgument((OWLIndividual)individual);
    }

    public @NonNull SWRLClassBuiltInArgument createSWRLClassBuiltInArgument(@NonNull String classShortName) throws SWRLParseException {
        OWLClass cls = this.createOWLClass(classShortName);
        return this.getSWRLBuiltInArgumentFactory().getClassBuiltInArgument(cls);
    }

    public @NonNull SWRLNamedIndividualBuiltInArgument createSWRLNamedIndividualBuiltInArgument(@NonNull String individualShortName) throws SWRLParseException {
        OWLNamedIndividual individual = this.createOWLNamedIndividual(individualShortName);
        return this.getSWRLBuiltInArgumentFactory().getNamedIndividualBuiltInArgument(individual);
    }

    public @NonNull SWRLObjectPropertyBuiltInArgument createSWRLObjectPropertyBuiltInArgument(@NonNull String propertyShortName) throws SWRLParseException {
        OWLObjectProperty property = this.createOWLObjectProperty(propertyShortName);
        return this.getSWRLBuiltInArgumentFactory().getObjectPropertyBuiltInArgument(property);
    }

    public @NonNull SWRLDataPropertyBuiltInArgument createSWRLDataPropertyBuiltInArgument(@NonNull String propertyShortName) throws SWRLParseException {
        OWLDataProperty property = this.createOWLDataProperty(propertyShortName);
        return this.getSWRLBuiltInArgumentFactory().getDataPropertyBuiltInArgument(property);
    }

    public @NonNull SWRLAnnotationPropertyBuiltInArgument createSWRLAnnotationPropertyBuiltInArgument(@NonNull String propertyShortName) throws SWRLParseException {
        OWLAnnotationProperty property = this.createOWLAnnotationProperty(propertyShortName);
        return this.getSWRLBuiltInArgumentFactory().getAnnotationPropertyBuiltInArgument(property);
    }

    public @NonNull SWRLDatatypeBuiltInArgument createSWRLDatatypeBuiltInArgument(@NonNull String datatypeShortName) throws SWRLParseException {
        OWLDatatype datatype = this.createOWLDatatype(datatypeShortName);
        return this.getSWRLBuiltInArgumentFactory().getDatatypeBuiltInArgument(datatype);
    }

    public @NonNull String getShortNameFromIRI(@NonNull String iriString, boolean interactiveParseOnly) throws SWRLParseException {
        try {
            IRI iri = this.prefixedName2IRI(iriString);
            return this.iri2ShortForm(iri);
        }
        catch (RuntimeException e) {
            if (interactiveParseOnly) {
                throw new SWRLIncompleteRuleException("IRI " + iriString + " does not refer to a valid OWL entity");
            }
            throw new SWRLParseException("IRI " + iriString + " does not refer to a valid OWL entity");
        }
    }

    private @NonNull OWLClass createOWLClass(@NonNull String classShortName) throws SWRLParseException {
        if (this.isOWLClass(classShortName)) {
            IRI classIRI = this.prefixedName2IRI(classShortName);
            return this.getOWLDataFactory().getOWLClass(classIRI);
        }
        throw new SWRLParseException(classShortName + " is not an OWL class");
    }

    private @NonNull OWLNamedIndividual createOWLNamedIndividual(@NonNull String individualShortName) throws SWRLParseException {
        if (this.isOWLNamedIndividual(individualShortName)) {
            IRI individualIRI = this.prefixedName2IRI(individualShortName);
            return this.getOWLDataFactory().getOWLNamedIndividual(individualIRI);
        }
        throw new SWRLParseException(individualShortName + " is not an OWL named individual");
    }

    private @NonNull OWLObjectProperty createOWLObjectProperty(@NonNull String objectPropertyShortName) throws SWRLParseException {
        if (this.isOWLObjectProperty(objectPropertyShortName)) {
            IRI propertyIRI = this.prefixedName2IRI(objectPropertyShortName);
            return this.getOWLDataFactory().getOWLObjectProperty(propertyIRI);
        }
        throw new SWRLParseException(objectPropertyShortName + " is not an OWL object property");
    }

    private @NonNull OWLDataProperty createOWLDataProperty(@NonNull String dataPropertyShortName) throws SWRLParseException {
        if (this.isOWLDataProperty(dataPropertyShortName)) {
            IRI propertyIRI = this.prefixedName2IRI(dataPropertyShortName);
            return this.getOWLDataFactory().getOWLDataProperty(propertyIRI);
        }
        throw new SWRLParseException(dataPropertyShortName + " is not an OWL data property");
    }

    private @NonNull OWLAnnotationProperty createOWLAnnotationProperty(@NonNull String annotationPropertyShortName) throws SWRLParseException {
        if (this.isOWLAnnotationProperty(annotationPropertyShortName)) {
            IRI propertyIRI = this.prefixedName2IRI(annotationPropertyShortName);
            return this.getOWLDataFactory().getOWLAnnotationProperty(propertyIRI);
        }
        throw new SWRLParseException(annotationPropertyShortName + " is not an OWL annotation property");
    }

    private @NonNull OWLDatatype createOWLDatatype(@NonNull String datatypeShortName) throws SWRLParseException {
        if (this.isOWLDatatype(datatypeShortName)) {
            IRI datatypeIRI = this.prefixedName2IRI(datatypeShortName);
            return this.getOWLDataFactory().getOWLDatatype(datatypeIRI);
        }
        throw new SWRLParseException(datatypeShortName + " is not a valid datatype");
    }

    private @NonNull IRI createSWRLBuiltInIRI(@NonNull String builtInPrefixedName) throws SWRLParseException {
        Optional<@NonNull IRI> iri = this.getSWRLAPIOWLOntology().swrlBuiltInPrefixedName2IRI(builtInPrefixedName);
        if (iri.isPresent()) {
            return iri.get();
        }
        throw new SWRLParseException(builtInPrefixedName + " is not a SWRL built-in");
    }

    private @NonNull SWRLAPIOWLOntology getSWRLAPIOWLOntology() {
        return this.swrlapiOWLOntology;
    }

    private @NonNull OWLOntology getOWLOntology() {
        return this.getSWRLAPIOWLOntology().getOWLOntology();
    }

    private @NonNull SWRLAPIOWLDataFactory getSWRLAPIOWLDataFactory() {
        return this.getSWRLAPIOWLOntology().getSWRLAPIOWLDataFactory();
    }

    private @NonNull SWRLBuiltInArgumentFactory getSWRLBuiltInArgumentFactory() {
        return this.getSWRLAPIOWLDataFactory().getSWRLBuiltInArgumentFactory();
    }

    private @NonNull OWLDataFactory getOWLDataFactory() {
        return this.getSWRLAPIOWLOntology().getSWRLAPIOWLDataFactory();
    }

    private @NonNull OWLLiteralFactory getOWLLiteralFactory() {
        return this.getSWRLAPIOWLOntology().getSWRLAPIOWLDataFactory().getOWLLiteralFactory();
    }

    private @NonNull String iri2ShortForm(IRI iri) {
        Optional<@NonNull String> shortForm = this.getIRIResolver().iri2ShortForm(iri);
        if (shortForm.isPresent()) {
            return shortForm.get();
        }
        throw new IllegalArgumentException("could not get short form for IRI " + iri);
    }

    private @NonNull IRI prefixedName2IRI(String prefixedName) {
        Optional<@NonNull IRI> iri = this.getIRIResolver().prefixedName2IRI(prefixedName);
        if (iri.isPresent()) {
            return iri.get();
        }
        throw new IllegalArgumentException("could not loadExternalSWRLBuiltInLibraries IRI for prefixed name " + prefixedName);
    }

    private boolean isValidSWRLVariableName(@NonNull String candidateSWRLVariableName) {
        if (candidateSWRLVariableName.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(candidateSWRLVariableName.charAt(0))) {
            return false;
        }
        for (int i = 1; i < candidateSWRLVariableName.length(); ++i) {
            char c = candidateSWRLVariableName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == ':' || c == '-') continue;
            return false;
        }
        return true;
    }

    private @NonNull IRIResolver getIRIResolver() {
        return this.swrlapiOWLOntology.getIRIResolver();
    }
}

