/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.parser;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.SideEffectFree;

class SWRLToken {
    private final @NonNull SWRLTokenType tokenType;
    private final @NonNull String value;

    public SWRLToken(@NonNull SWRLTokenType tokenType, @NonNull String value) {
        this.tokenType = tokenType;
        this.value = value;
    }

    public @NonNull SWRLTokenType getTokenType() {
        return this.tokenType;
    }

    public @NonNull String getValue() {
        return this.value;
    }

    public boolean isImp() {
        return this.tokenType == SWRLTokenType.IMP;
    }

    public boolean isRing() {
        return this.tokenType == SWRLTokenType.RING;
    }

    public boolean isConjunction() {
        return this.tokenType == SWRLTokenType.CONJUNCTION;
    }

    public boolean isString() {
        return this.tokenType == SWRLTokenType.STRING;
    }

    public boolean isShortName() {
        return this.tokenType == SWRLTokenType.SHORTNAME;
    }

    public boolean isIRI() {
        return this.tokenType == SWRLTokenType.IRI;
    }

    public boolean isInteger() {
        return this.tokenType == SWRLTokenType.INTEGER;
    }

    public boolean isDecimal() {
        return this.tokenType == SWRLTokenType.DECIMAL;
    }

    public boolean isTypeQualifier() {
        return this.tokenType == SWRLTokenType.TYPE_QUAL;
    }

    public boolean isLParen() {
        return this.tokenType == SWRLTokenType.LPAREN;
    }

    public boolean isRParen() {
        return this.tokenType == SWRLTokenType.RPAREN;
    }

    public boolean isComma() {
        return this.tokenType == SWRLTokenType.COMMA;
    }

    public boolean isQuestion() {
        return this.tokenType == SWRLTokenType.QUESTION;
    }

    public boolean isAnd() {
        return this.tokenType == SWRLTokenType.AND;
    }

    public boolean isOr() {
        return this.tokenType == SWRLTokenType.OR;
    }

    public boolean isNot() {
        return this.tokenType == SWRLTokenType.NOT;
    }

    public boolean isEndOfInput() {
        return this.tokenType == SWRLTokenType.END_OF_INPUT;
    }

    @SideEffectFree
    public @NonNull String toString() {
        return "[" + this.tokenType.getName() + " with value '" + this.value + "']";
    }

    public static enum SWRLTokenType {
        SHORTNAME("short name"),
        IRI("IRI"),
        STRING("quoted string"),
        DECIMAL("decimal"),
        INTEGER("integer"),
        TYPE_QUAL("^^"),
        CONJUNCTION("^"),
        IMP("->"),
        RING("."),
        LPAREN("("),
        RPAREN(")"),
        COMMA(","),
        QUESTION("?"),
        AND("AND"),
        OR("OR"),
        NOT("NOT"),
        END_OF_INPUT("end");

        private final @NonNull String name;

        private SWRLTokenType(String name) {
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }
    }
}

