/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.parser.SWRLIncompleteRuleException;
import org.swrlapi.parser.SWRLParseException;
import org.swrlapi.parser.SWRLToken;

class SWRLTokenizer {
    private static final @NonNull char[] wordChars = new char[]{':', '_', '-', '/', '#'};
    private static final @NonNull char[] ordinaryChars = new char[]{'.', '^', '<', '>', '(', ')', '?'};
    private final @NonNull MyStreamTokenizer tokenizer;
    private final @NonNull Set<@NonNull String> swrlVariables;
    private final @NonNull List<@NonNull SWRLToken> tokens;
    private final boolean interactiveParseOnly;
    private int tokenPosition;

    public SWRLTokenizer(@NonNull String input, boolean interactiveParseOnly) throws SWRLParseException {
        this.tokenizer = new MyStreamTokenizer(new StringReader(input));
        this.swrlVariables = new HashSet<String>();
        this.interactiveParseOnly = interactiveParseOnly;
        for (char wordChar : wordChars) {
            this.tokenizer.wordChars(wordChar, wordChar);
        }
        this.tokenizer.wordChars(48, 57);
        for (char ordinaryChar : ordinaryChars) {
            this.tokenizer.ordinaryChar(ordinaryChar);
        }
        this.tokens = this.generateTokens();
        this.tokenPosition = 0;
    }

    public void reset() {
        this.tokenPosition = 0;
    }

    public @NonNull SWRLToken getToken(SWRLToken.SWRLTokenType expectedTokenType, @NonNull String unexpectedTokenMessage) throws SWRLParseException {
        if (this.hasMoreTokens()) {
            SWRLToken token = this.getToken();
            if (token.getTokenType() == expectedTokenType) {
                return token;
            }
            throw new SWRLParseException(unexpectedTokenMessage);
        }
        throw this.generateEndOfRuleException(unexpectedTokenMessage);
    }

    public @NonNull SWRLToken getToken(@NonNull String noTokenMessage) throws SWRLParseException {
        if (this.hasMoreTokens()) {
            return this.getToken();
        }
        throw this.generateEndOfRuleException(noTokenMessage);
    }

    public boolean hasMoreTokens() {
        return this.tokenPosition < this.tokens.size();
    }

    public @NonNull SWRLToken peekToken(@NonNull String message) throws SWRLParseException {
        if (this.tokenPosition < this.tokens.size()) {
            return this.tokens.get(this.tokenPosition);
        }
        throw this.generateEndOfRuleException(message);
    }

    public void skipToken() throws SWRLParseException {
        if (this.tokenPosition < this.tokens.size()) {
            ++this.tokenPosition;
        } else {
            throw this.generateEndOfRuleException("End of rule reached unexpectedly!");
        }
    }

    public boolean isInteractiveParseOnly() {
        return this.interactiveParseOnly;
    }

    public boolean hasVariable(@NonNull String variableName) {
        return this.swrlVariables.contains(variableName);
    }

    public void addVariable(@NonNull String variableName) {
        this.swrlVariables.add(variableName);
    }

    public void checkAndSkipLParen(@NonNull String unexpectedTokenMessage) throws SWRLParseException {
        this.checkAndSkipToken(SWRLToken.SWRLTokenType.LPAREN, unexpectedTokenMessage);
    }

    public void checkAndSkipRParen(@NonNull String unexpectedTokenMessage) throws SWRLParseException {
        this.checkAndSkipToken(SWRLToken.SWRLTokenType.RPAREN, unexpectedTokenMessage);
    }

    public void checkAndSkipComma(@NonNull String unexpectedTokenMessage) throws SWRLParseException {
        this.checkAndSkipToken(SWRLToken.SWRLTokenType.COMMA, unexpectedTokenMessage);
    }

    public static boolean isOrdinaryChar(char c) {
        for (char ordinaryChar : ordinaryChars) {
            if (ordinaryChar != c) continue;
            return true;
        }
        return false;
    }

    private @NonNull SWRLToken getToken() throws SWRLParseException {
        if (this.tokenPosition < this.tokens.size()) {
            return this.tokens.get(this.tokenPosition++);
        }
        throw this.generateEndOfRuleException("Incomplete rule!");
    }

    private void checkAndSkipToken(SWRLToken.SWRLTokenType tokenType, @NonNull String unexpectedTokenMessage) throws SWRLParseException {
        if (this.hasMoreTokens()) {
            SWRLToken token = this.getToken();
            if (token.getTokenType() != tokenType) {
                throw new SWRLParseException(unexpectedTokenMessage + ", got '" + token.getValue() + "'");
            }
        } else {
            throw this.generateEndOfRuleException(unexpectedTokenMessage);
        }
    }

    private @UnderInitialization @NonNull List<@NonNull SWRLToken> generateTokens() throws SWRLParseException {
        ArrayList<@NonNull SWRLToken> tokens = new ArrayList<SWRLToken>();
        SWRLToken token = this.generateToken();
        while (token.getTokenType() != SWRLToken.SWRLTokenType.END_OF_INPUT) {
            tokens.add(token);
            token = this.generateToken();
        }
        return tokens;
    }

    private @NonNull SWRLToken generateToken() throws SWRLParseException {
        try {
            return this.convertToken2SWRLToken(this.tokenizer.nextToken());
        }
        catch (IOException e) {
            throw new SWRLParseException("Error tokenizing " + (e.getMessage() != null ? e.getMessage() : ""));
        }
    }

    private @NonNull SWRLToken convertToken2SWRLToken(int tokenType) throws SWRLParseException, IOException {
        switch (tokenType) {
            case -1: {
                return new SWRLToken(SWRLToken.SWRLTokenType.END_OF_INPUT, "");
            }
            case 10: {
                return new SWRLToken(SWRLToken.SWRLTokenType.END_OF_INPUT, "");
            }
            case -2: {
                throw new SWRLParseException("internal error - not expecting a StreamTokenizer.TT_NUMBER");
            }
            case -3: {
                String value = this.tokenizer.getValue();
                if (value.equalsIgnoreCase("not")) {
                    return new SWRLToken(SWRLToken.SWRLTokenType.NOT, "not");
                }
                if (value.equalsIgnoreCase("and")) {
                    return new SWRLToken(SWRLToken.SWRLTokenType.AND, "and");
                }
                if (value.equalsIgnoreCase("or")) {
                    return new SWRLToken(SWRLToken.SWRLTokenType.OR, "or");
                }
                boolean negativeNumeric = false;
                if (value.equals("-")) {
                    int nextTokenType = this.tokenizer.nextToken();
                    if (nextTokenType == 62) {
                        return new SWRLToken(SWRLToken.SWRLTokenType.IMP, "->");
                    }
                    if (nextTokenType == -1) {
                        throw this.generateEndOfRuleException("Expecting '>' or integer or decimal after '-'");
                    }
                    if (nextTokenType != -3) {
                        throw new SWRLParseException("Expecting '>' or integer or decimal after '-'");
                    }
                    negativeNumeric = true;
                }
                if (this.isInteger(value)) {
                    if (this.tokenizer.nextToken() == 46) {
                        int trailingTokenType = this.tokenizer.nextToken();
                        String trailingValue = this.tokenizer.getValue();
                        if (trailingTokenType == -3 && this.isInteger(trailingValue)) {
                            String decimalValue = value + "." + trailingValue;
                            decimalValue = negativeNumeric ? "-" + decimalValue : decimalValue;
                            return new SWRLToken(SWRLToken.SWRLTokenType.DECIMAL, decimalValue);
                        }
                        if (trailingTokenType == -1) {
                            throw this.generateEndOfRuleException("Expecting decimal fraction part after '.'");
                        }
                        throw new SWRLParseException("Expecting decimal fraction part after '.'");
                    }
                    this.tokenizer.pushBack();
                    String integerValue = negativeNumeric ? "-" + value : value;
                    return new SWRLToken(SWRLToken.SWRLTokenType.INTEGER, integerValue);
                }
                if (negativeNumeric) {
                    throw new SWRLParseException("Expecting integer or decimal");
                }
                return new SWRLToken(SWRLToken.SWRLTokenType.SHORTNAME, value);
            }
            case 34: {
                return new SWRLToken(SWRLToken.SWRLTokenType.STRING, this.tokenizer.getValue());
            }
            case 44: {
                return new SWRLToken(SWRLToken.SWRLTokenType.COMMA, ",");
            }
            case 63: {
                return new SWRLToken(SWRLToken.SWRLTokenType.QUESTION, "?");
            }
            case 40: {
                return new SWRLToken(SWRLToken.SWRLTokenType.LPAREN, "(");
            }
            case 41: {
                return new SWRLToken(SWRLToken.SWRLTokenType.RPAREN, ")");
            }
            case 46: {
                return new SWRLToken(SWRLToken.SWRLTokenType.RING, ".");
            }
            case 94: {
                int nextTokenType = this.tokenizer.nextToken();
                if (nextTokenType == 94) {
                    return new SWRLToken(SWRLToken.SWRLTokenType.TYPE_QUAL, "^^");
                }
                this.tokenizer.pushBack();
                return new SWRLToken(SWRLToken.SWRLTokenType.CONJUNCTION, "^");
            }
            case 60: {
                int nextTokenType = this.tokenizer.nextToken();
                if (nextTokenType == -3) {
                    String iri = this.tokenizer.getValue();
                    nextTokenType = this.tokenizer.nextToken();
                    if (nextTokenType == 62) {
                        return new SWRLToken(SWRLToken.SWRLTokenType.IRI, iri);
                    }
                    if (nextTokenType == -1) {
                        throw this.generateEndOfRuleException("Expecting '>' after IRI");
                    }
                    throw new SWRLParseException("Expecting IRI after '<'");
                }
                if (nextTokenType == -1) {
                    throw this.generateEndOfRuleException("Expecting IRI after '<'");
                }
                throw new SWRLParseException("Expecting IRI after '<'");
            }
        }
        throw new SWRLParseException("Unexpected character '" + String.valueOf(Character.toChars(tokenType)) + "'");
    }

    private @NonNull SWRLParseException generateEndOfRuleException(@NonNull String message) {
        if (!this.isInteractiveParseOnly()) {
            return new SWRLParseException(message);
        }
        return new SWRLIncompleteRuleException(message);
    }

    private boolean isInteger(@NonNull String s) {
        try {
            new BigInteger(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private class MyStreamTokenizer
    extends StreamTokenizer {
        public MyStreamTokenizer(Reader r) {
            super(r);
        }

        @Override
        public void parseNumbers() {
        }

        @NonNull String getValue() {
            if (this.sval != null) {
                return this.sval;
            }
            return "";
        }
    }
}

