/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.sqwrl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidAggregateFunctionNameException;

public class SQWRLNames {
    public static final String SQWRLBuiltInLibraryName = "SQWRLBuiltIns";
    public static final String SQWRL_PREFIX = "sqwrl:";
    public static final String SQWRL_NAMESPACE = "http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#";
    public static final String Select = "sqwrl:select";
    public static final String SelectDistinct = "sqwrl:selectDistinct";
    public static final String Count = "sqwrl:count";
    public static final String CountDistinct = "sqwrl:countDistinct";
    public static final String Avg = "sqwrl:avg";
    public static final String Min = "sqwrl:min";
    public static final String Max = "sqwrl:max";
    public static final String Sum = "sqwrl:sum";
    public static final String Median = "sqwrl:median";
    public static final String OrderBy = "sqwrl:orderBy";
    public static final String OrderByDescending = "sqwrl:orderByDescending";
    public static final String ColumnNames = "sqwrl:columnNames";
    public static final String CountAggregateFunction = "count";
    public static final String CountDistinctAggregateFunction = "countDistinct";
    public static final String Limit = "sqwrl:limit";
    public static final String MinAggregateFunction = "min";
    public static final String MaxAggregateFunction = "max";
    public static final String SumAggregateFunction = "sum";
    public static final String AvgAggregateFunction = "avg";
    public static final String MedianAggregateFunction = "median";
    public static final String MakeSet = "sqwrl:makeSet";
    public static final String MakeBag = "sqwrl:makeBag";
    public static final String GroupBy = "sqwrl:groupBy";
    public static final String Size = "sqwrl:size";
    public static final String IsEmpty = "sqwrl:isEmpty";
    public static final String NotIsEmpty = "sqwrl:notIsEmpty";
    public static final String Element = "sqwrl:element";
    public static final String NotElement = "sqwrl:notElement";
    public static final String LastN = "sqwrl:lastN";
    public static final String NotLastN = "sqwrl:notLastN";
    public static final String FirstN = "sqwrl:firstN";
    public static final String NotFirstN = "sqwrl:notFirstN";
    public static final String Nth = "sqwrl:nth";
    public static final String NotNth = "sqwrl:notNth";
    public static final String NthLast = "sqwrl:nthLast";
    public static final String NotNthLast = "sqwrl:notNthLast";
    public static final String NthSlice = "sqwrl:nthSlice";
    public static final String NotNthSlice = "sqwrl:notNthSlice";
    public static final String NthLastSlice = "sqwrl:nthLastSlice";
    public static final String NotNthLastSlice = "sqwrl:notNthLastSlice";
    public static final String Intersection = "sqwrl:intersection";
    public static final String Union = "sqwrl:union";
    public static final String Difference = "sqwrl:difference";
    public static final String Append = "sqwrl:append";
    public static final String Intersects = "sqwrl:intersects";
    public static final String NotIntersects = "sqwrl:notIntersects";
    public static final String Equal = "sqwrl:equal";
    public static final String NotEqual = "sqwrl:notEqual";
    public static final String Contains = "sqwrl:contains";
    public static final String NotContains = "sqwrl:notContains";
    public static final String GreatestN = "sqwrl:greatestN";
    public static final String NotGreatestN = "sqwrl:notGreatestN";
    public static final String LeastN = "sqwrl:leastN";
    public static final String NotLeastN = "sqwrl:notLeastN";
    public static final String NthGreatest = "sqwrl:nthGreatest";
    public static final String NotNthGreatest = "sqwrl:notNthGreatest";
    public static final String NthGreatestSlice = "sqwrl:nthGreatestSlice";
    public static final String NotNthGreatestSlice = "sqwrl:notNthGreatestSlice";
    private static final String[] headSelectionBuiltInNamesArray = new String[]{"sqwrl:select", "sqwrl:selectDistinct", "sqwrl:orderBy", "sqwrl:orderByDescending", "sqwrl:columnNames"};
    private static final String[] headAggregationBuiltInNamesArray = new String[]{"sqwrl:count", "sqwrl:countDistinct", "sqwrl:avg", "sqwrl:median", "sqwrl:min", "sqwrl:max", "sqwrl:sum"};
    private static final String[] headSlicingBuiltInNamesArray = new String[]{"sqwrl:limit", "sqwrl:nth", "sqwrl:nthGreatest", "sqwrl:nthLast", "sqwrl:nthSlice", "sqwrl:nthLastSlice", "sqwrl:nthGreatestSlice", "sqwrl:notNthGreatestSlice", "sqwrl:notNthLastSlice", "sqwrl:notNthSlice", "sqwrl:notNth", "sqwrl:notNthLast", "sqwrl:notNthGreatest", "sqwrl:notFirstN", "sqwrl:notLastN", "sqwrl:notGreatestN", "sqwrl:notLeastN", "sqwrl:lastN", "sqwrl:firstN", "sqwrl:leastN", "sqwrl:greatestN"};
    private static final String[] collectionMakeBuiltInNamesArray = new String[]{"sqwrl:makeSet", "sqwrl:makeBag"};
    private static final String[] collectionGroupByBuiltInNamesArray = new String[]{"sqwrl:groupBy"};
    private static final String[] singleCollectionOperationWithoutCollectionCreateBuiltInNamesArray = new String[]{"sqwrl:size", "sqwrl:isEmpty", "sqwrl:notIsEmpty", "sqwrl:element", "sqwrl:notElement", "sqwrl:min", "sqwrl:max", "sqwrl:sum", "sqwrl:avg", "sqwrl:median", "sqwrl:nth", "sqwrl:nthGreatest", "sqwrl:nthLast"};
    private static final String[] singleCollectionOperationWithCollectionCreateBuiltInNamesArray = new String[]{"sqwrl:nthSlice", "sqwrl:nthLastSlice", "sqwrl:nthGreatestSlice", "sqwrl:notNthGreatestSlice", "sqwrl:notNthLastSlice", "sqwrl:notNthSlice", "sqwrl:notNth", "sqwrl:notNthLast", "sqwrl:notNthGreatest", "sqwrl:notFirstN", "sqwrl:notLastN", "sqwrl:notGreatestN", "sqwrl:notLeastN", "sqwrl:lastN", "sqwrl:firstN", "sqwrl:leastN", "sqwrl:greatestN"};
    private static final String[] multiCollectionOperationWithoutCollectionCreateBuiltInNamesArray = new String[]{"sqwrl:intersects", "sqwrl:notIntersects", "sqwrl:equal", "sqwrl:notEqual", "sqwrl:contains", "sqwrl:notContains"};
    private static final String[] multiCollectionOperationWithCollectionCreateBuiltInNamesArray = new String[]{"sqwrl:intersection", "sqwrl:union", "sqwrl:difference", "sqwrl:append"};
    public static final String[] aggregateFunctionNames = new String[]{"min", "max", "sum", "avg", "median", "count", "countDistinct"};
    private static final @NonNull Set<@NonNull String> sqwrlBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> headBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> headSelectionBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> headAggregationBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> headSlicingBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> collectionMakeBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> collectionGroupByBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> collectionCreateOperationBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> collectionOperationBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> singleCollectionOperationWithCollectionCreateBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> singleCollectionOperationWithoutCollectionCreateBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> multiCollectionOperationWithCollectionCreateBuiltInNames = new HashSet<String>();
    private static final @NonNull Set<@NonNull String> multiCollectionOperationWithoutCollectionCreateBuiltInNames = new HashSet<String>();

    public static @NonNull Set<@NonNull String> getSQWRLBuiltInNames() {
        return sqwrlBuiltInNames;
    }

    public static @NonNull Set<@NonNull String> getHeadBuiltInNames() {
        return headBuiltInNames;
    }

    public static @NonNull Set<@NonNull String> getHeadSlicingBuiltInNames() {
        return headSlicingBuiltInNames;
    }

    public static @NonNull Set<@NonNull String> getHeadSelectionBuiltInNames() {
        return headSelectionBuiltInNames;
    }

    public static @NonNull Set<@NonNull String> getCollectionMakeBuiltInNames() {
        return collectionMakeBuiltInNames;
    }

    public static @NonNull Set<@NonNull String> getCollectionGroupByBuiltInNames() {
        return collectionGroupByBuiltInNames;
    }

    public static @NonNull Set<@NonNull String> getCollectionCreateBuiltInNames() {
        return collectionCreateOperationBuiltInNames;
    }

    public static @NonNull Set<@NonNull String> getCollectionOperationBuiltInNames() {
        return collectionOperationBuiltInNames;
    }

    public static boolean isSQWRLBuiltIn(@NonNull String builtInName) {
        return sqwrlBuiltInNames.contains(builtInName);
    }

    public static boolean isSQWRLHeadBuiltIn(@NonNull String builtInName) {
        return headBuiltInNames.contains(builtInName);
    }

    public static boolean isSQWRLHeadSelectionBuiltIn(@NonNull String builtInName) {
        return headSelectionBuiltInNames.contains(builtInName);
    }

    public static boolean isSQWRLHeadAggregationBuiltIn(@NonNull String builtInName) {
        return headAggregationBuiltInNames.contains(builtInName);
    }

    public static boolean isSQWRLHeadSlicingBuiltIn(@NonNull String builtInName) {
        return headSlicingBuiltInNames.contains(builtInName);
    }

    public static boolean isSQWRLCollectionMakeBuiltIn(@NonNull String builtInName) {
        return collectionMakeBuiltInNames.contains(builtInName);
    }

    public static boolean isSQWRLCollectionGroupByBuiltIn(@NonNull String builtInName) {
        return collectionGroupByBuiltInNames.contains(builtInName);
    }

    public static boolean isSQWRLCollectionCreateOperationBuiltIn(@NonNull String builtInName) {
        return collectionCreateOperationBuiltInNames.contains(builtInName);
    }

    public static boolean isSQWRLCollectionOperationBuiltIn(@NonNull String builtInName) {
        return collectionOperationBuiltInNames.contains(builtInName);
    }

    public static void checkAggregateFunctionName(@NonNull String aggregateFunctionName) throws SQWRLInvalidAggregateFunctionNameException {
        boolean found = false;
        for (String candidateAggregateFunctionName : aggregateFunctionNames) {
            if (!candidateAggregateFunctionName.equalsIgnoreCase(aggregateFunctionName)) continue;
            found = true;
        }
        if (!found) {
            throw new SQWRLInvalidAggregateFunctionNameException("invalid aggregate function " + aggregateFunctionName);
        }
    }

    static {
        Collections.addAll(headSelectionBuiltInNames, headSelectionBuiltInNamesArray);
        Collections.addAll(headAggregationBuiltInNames, headAggregationBuiltInNamesArray);
        Collections.addAll(headSlicingBuiltInNames, headSlicingBuiltInNamesArray);
        headBuiltInNames.addAll(headSelectionBuiltInNames);
        headBuiltInNames.addAll(headAggregationBuiltInNames);
        headBuiltInNames.addAll(headSlicingBuiltInNames);
        sqwrlBuiltInNames.addAll(headBuiltInNames);
        Collections.addAll(collectionMakeBuiltInNames, collectionMakeBuiltInNamesArray);
        collectionCreateOperationBuiltInNames.addAll(collectionMakeBuiltInNames);
        sqwrlBuiltInNames.addAll(collectionMakeBuiltInNames);
        Collections.addAll(collectionGroupByBuiltInNames, collectionGroupByBuiltInNamesArray);
        sqwrlBuiltInNames.addAll(collectionGroupByBuiltInNames);
        Collections.addAll(singleCollectionOperationWithCollectionCreateBuiltInNames, singleCollectionOperationWithCollectionCreateBuiltInNamesArray);
        collectionCreateOperationBuiltInNames.addAll(singleCollectionOperationWithCollectionCreateBuiltInNames);
        collectionOperationBuiltInNames.addAll(singleCollectionOperationWithCollectionCreateBuiltInNames);
        sqwrlBuiltInNames.addAll(singleCollectionOperationWithCollectionCreateBuiltInNames);
        Collections.addAll(singleCollectionOperationWithoutCollectionCreateBuiltInNames, singleCollectionOperationWithoutCollectionCreateBuiltInNamesArray);
        collectionOperationBuiltInNames.addAll(singleCollectionOperationWithoutCollectionCreateBuiltInNames);
        sqwrlBuiltInNames.addAll(singleCollectionOperationWithoutCollectionCreateBuiltInNames);
        Collections.addAll(multiCollectionOperationWithCollectionCreateBuiltInNames, multiCollectionOperationWithCollectionCreateBuiltInNamesArray);
        collectionCreateOperationBuiltInNames.addAll(multiCollectionOperationWithCollectionCreateBuiltInNames);
        collectionOperationBuiltInNames.addAll(multiCollectionOperationWithCollectionCreateBuiltInNames);
        sqwrlBuiltInNames.addAll(multiCollectionOperationWithCollectionCreateBuiltInNames);
        Collections.addAll(multiCollectionOperationWithoutCollectionCreateBuiltInNames, multiCollectionOperationWithoutCollectionCreateBuiltInNamesArray);
        collectionOperationBuiltInNames.addAll(multiCollectionOperationWithoutCollectionCreateBuiltInNames);
        sqwrlBuiltInNames.addAll(multiCollectionOperationWithoutCollectionCreateBuiltInNames);
    }
}

