/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.swrlapi.ui.dialog.SWRLRuleEngineDialogManager;
import org.swrlapi.ui.model.FileBackedOntologyModel;

public class CloseAction
implements ActionListener {
    public static final String CLOSE_TITLE = "Close";
    private static final String MESSAGE = "Do you really want to close the ontology?";
    private static final String ERROR_TITLE = "Error";
    private final @NonNull Component parent;
    private final @NonNull FileBackedOntologyModel ontologyModel;
    private final @NonNull SWRLRuleEngineDialogManager dialogManager;

    public CloseAction(@NonNull Component parent, @NonNull FileBackedOntologyModel ontologyModel, @NonNull SWRLRuleEngineDialogManager dialogManager) {
        this.parent = parent;
        this.ontologyModel = ontologyModel;
        this.dialogManager = dialogManager;
    }

    @Override
    public void actionPerformed(@NonNull ActionEvent e) {
        this.confirmClose();
    }

    private void confirmClose() {
        if (!this.ontologyModel.hasOntologyChanged() || this.dialogManager.showConfirmDialog(this.parent, MESSAGE, CLOSE_TITLE)) {
            this.close();
        }
    }

    private void close() {
        try {
            this.ontologyModel.close();
        }
        catch (OWLOntologyCreationException e) {
            this.dialogManager.showErrorMessageDialog(this.parent, e.getMessage() != null ? e.getMessage() : "", ERROR_TITLE);
        }
    }
}

