/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.swrlapi.ui.dialog.SWRLRuleEngineDialogManager;
import org.swrlapi.ui.model.FileBackedOntologyModel;

public class OpenAction
implements ActionListener {
    public static final String OPEN_TITLE = "Open";
    private static final String FILE_DESCRIPTION = "OWL Ontology";
    private static final String FILE_EXTENSION = "owl";
    private static final String ERROR_TITLE = "Error";
    private final @NonNull Component parent;
    private final @NonNull SWRLRuleEngineDialogManager dialogManager;
    private final @NonNull FileBackedOntologyModel ontologyModel;

    public OpenAction(@NonNull Component parent, @NonNull FileBackedOntologyModel ontologyModel, @NonNull SWRLRuleEngineDialogManager dialogManager) {
        this.parent = parent;
        this.dialogManager = dialogManager;
        this.ontologyModel = ontologyModel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.open();
    }

    public void open() {
        JFileChooser fileChooser = this.dialogManager.createFileChooser(OPEN_TITLE, FILE_DESCRIPTION, FILE_EXTENSION);
        if (fileChooser.showOpenDialog(this.parent) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                this.ontologyModel.open(file);
            }
            catch (OWLOntologyCreationException e) {
                this.dialogManager.showErrorMessageDialog(this.parent, e.getMessage() != null ? e.getMessage() : "", ERROR_TITLE);
            }
        }
    }
}

