/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.ui.dialog.SWRLRuleEngineDialogManager;
import org.swrlapi.ui.model.FileBackedOntologyModel;

public class QuitAction
implements ActionListener {
    public static final String QUIT_TITLE = "Quit";
    private static final String MESSAGE = "Do you really want to quit?";
    private final @NonNull Component parent;
    private final @NonNull FileBackedOntologyModel ontologyModel;
    private final @NonNull SWRLRuleEngineDialogManager dialogManager;

    public QuitAction(@NonNull Component parent, @NonNull FileBackedOntologyModel ontologyModel, @NonNull SWRLRuleEngineDialogManager dialogManager) {
        this.parent = parent;
        this.ontologyModel = ontologyModel;
        this.dialogManager = dialogManager;
    }

    @Override
    public void actionPerformed(@NonNull ActionEvent e) {
        this.confirmQuit();
    }

    private void confirmQuit() {
        if (!this.ontologyModel.hasOntologyChanged() || this.dialogManager.showConfirmDialog(this.parent, QUIT_TITLE, MESSAGE)) {
            this.quit();
        }
    }

    private void quit() {
    }
}

