/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

class SWRLRuleEditorAutoCompleteState {
    private final @NonNull String prefix;
    private final @NonNull List<@NonNull String> expansions;
    private final int textPosition;
    private int expansionIndex;

    public SWRLRuleEditorAutoCompleteState(int textPosition, @NonNull String prefix, @NonNull List<@NonNull String> expansions) {
        this.textPosition = textPosition;
        this.prefix = prefix;
        this.expansions = new ArrayList<String>(expansions);
        this.expansionIndex = 0;
    }

    public int getTextPosition() {
        return this.textPosition;
    }

    public @NonNull String getPrefix() {
        return this.prefix;
    }

    public @NonNull String getCurrentExpansion() {
        if (!this.expansions.isEmpty()) {
            return this.expansions.get(this.expansionIndex);
        }
        return "";
    }

    public @NonNull String getNextExpansion() {
        if (!this.expansions.isEmpty()) {
            ++this.expansionIndex;
            if (this.expansionIndex == this.expansions.size()) {
                this.expansionIndex = 0;
            }
            return this.expansions.get(this.expansionIndex);
        }
        return "";
    }
}

