/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.parser.SWRLIncompleteRuleException;
import org.swrlapi.parser.SWRLParseException;
import org.swrlapi.parser.SWRLParser;
import org.swrlapi.ui.dialog.SWRLRuleEditorAutoCompleteState;
import org.swrlapi.ui.dialog.SWRLRuleEditorInitialDialogState;
import org.swrlapi.ui.dialog.SWRLRuleEngineDialogManager;
import org.swrlapi.ui.model.SWRLAutoCompleter;
import org.swrlapi.ui.model.SWRLRuleEngineModel;
import org.swrlapi.ui.model.SWRLRulesAndSQWRLQueriesTableModel;
import org.swrlapi.ui.view.SWRLAPIView;

public class SWRLRuleEditorDialog
extends JDialog
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SWRLRuleEditorDialog.class);
    private static final String TITLE = "Edit";
    private static final String RULE_NAME_TITLE = "Name";
    private static final String COMMENT_LABEL_TITLE = "Comment";
    private static final String STATUS_LABEL_TITLE = "Status";
    private static final String OK_BUTTON_TITLE = "Ok";
    private static final String CANCEL_BUTTON_TITLE = "Cancel";
    private static final String STATUS_OK = "Ok";
    private static final String STATUS_NO_RULE_TEXT = "Use Tab key to cycle through auto-completions; use Escape key to remove auto-complete expansion";
    private static final String INVALID_RULE_TITLE = "Invalid";
    private static final String MISSING_RULE = "Nothing to save!";
    private static final String MISSING_RULE_NAME_TITLE = "Empty Name";
    private static final String MISSING_RULE_NAME = "A name must be supplied!";
    private static final String QUIT_CONFIRM_TITLE = "Unsaved Changes";
    private static final String QUIT_CONFIRM_MESSAGE = "Are you sure you want discard your changes?";
    private static final String DUPLICATE_RULE_TEXT = "Name already in use - please pick another name.";
    private static final String DUPLICATE_RULE_TITLE = "Duplicate Name";
    private static final String INTERNAL_ERROR_TITLE = "Internal Error";
    private static final int BUTTON_PREFERRED_WIDTH = 100;
    private static final int BUTTON_PREFERRED_HEIGHT = 30;
    private static final int RULE_EDIT_AREA_COLUMNS = 20;
    private static final int RULE_EDIT_AREA_ROWS = 60;
    private final @NonNull SWRLRuleEngineModel swrlRuleEngineModel;
    private final @NonNull SWRLRuleEngineDialogManager dialogManager;
    private final @NonNull SWRLRuleEditorInitialDialogState initialDialogState = new SWRLRuleEditorInitialDialogState();
    private final @NonNull JTextField ruleNameTextField;
    private final @NonNull JTextField commentTextField;
    private final @NonNull JTextField statusTextField;
    private final @NonNull JTextArea ruleTextTextArea;
    private final @NonNull JButton saveButton;
    private final @NonNull JButton cancelButton;
    private final @NonNull Border loweredBevelBorder;
    private final @NonNull Border yellowBorder;
    private @NonNull Optional<@NonNull SWRLRuleEditorAutoCompleteState> autoCompleteState = Optional.empty();
    private boolean editMode = false;

    public SWRLRuleEditorDialog(@NonNull SWRLRuleEngineModel swrlRuleEngineModel, @NonNull SWRLRuleEngineDialogManager dialogManager) {
        this.swrlRuleEngineModel = swrlRuleEngineModel;
        this.dialogManager = dialogManager;
        this.loweredBevelBorder = BorderFactory.createLoweredBevelBorder();
        this.yellowBorder = BorderFactory.createLineBorder(Color.YELLOW);
        this.ruleTextTextArea = new JTextArea("", 20, 60);
        this.saveButton = new JButton("Ok");
        this.cancelButton = new JButton(CANCEL_BUTTON_TITLE);
        this.ruleNameTextField = new JTextField("");
        this.commentTextField = new JTextField("");
        this.statusTextField = new JTextField("");
    }

    @Override
    public void initialize() {
        Container contentPane = this.getContentPane();
        this.setTitle(TITLE);
        this.setModal(true);
        this.initializeComponents();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseWindowListener(contentPane));
        this.ruleTextTextArea.addKeyListener(new SWRLRuleEditorKeyAdapter());
        this.cancelButton.addActionListener(new CancelSWRLRuleEditActionListener(contentPane));
        this.saveButton.addActionListener(new SaveSWRLRuleActionListener(contentPane));
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setInitialDialogState();
            this.disableAutoCompleteModeIfNecessary();
            this.updateStatus();
        }
        super.setVisible(b);
    }

    public void setCreateMode() {
        this.cancelEditMode();
        Optional<String> autogeneratedRuleName = this.swrlRuleEngineModel.getNextRuleName();
        if (autogeneratedRuleName.isPresent()) {
            this.ruleNameTextField.setText(autogeneratedRuleName.get());
            this.ruleNameTextField.selectAll();
        }
        this.statusTextField.setText("");
    }

    public void setEditMode(@NonNull String ruleName, @NonNull String ruleText, @NonNull String comment) {
        this.cancelEditMode();
        this.ruleNameTextField.setText(ruleName);
        this.ruleTextTextArea.setText(ruleText);
        this.commentTextField.setText(comment);
        this.statusTextField.setText("");
        this.editMode = true;
    }

    @Override
    public void update() {
        this.updateStatus();
    }

    private void updateStatus() {
        String ruleText = this.getRuleText();
        if (ruleText.isEmpty()) {
            this.setInformationalStatusText(STATUS_NO_RULE_TEXT);
            this.disableSave();
        } else {
            try {
                this.createSWRLParser().parseSWRLRule(ruleText, true, this.getRuleName(), this.getComment());
                this.ruleTextTextArea.requestFocus();
                this.setInformationalStatusText("Ok");
                this.enableSave();
            }
            catch (SWRLIncompleteRuleException e) {
                this.setIncompleteStatusText(e.getMessage() == null ? "" : e.getMessage());
                this.disableSave();
            }
            catch (SWRLParseException e) {
                this.setErrorStatusText(e.getMessage() == null ? "" : e.getMessage());
                this.disableSave();
            }
            catch (RuntimeException e) {
                this.setInformationalStatusText(e.getMessage() == null ? "" : e.getMessage());
                this.disableSave();
            }
        }
    }

    private void cancelEditMode() {
        this.ruleNameTextField.setText("");
        this.ruleNameTextField.setEnabled(true);
        this.ruleTextTextArea.setText("");
        this.ruleTextTextArea.setEnabled(true);
        this.ruleTextTextArea.setText("");
        this.commentTextField.setText("");
        this.statusTextField.setText("");
        this.editMode = false;
    }

    private void initializeComponents() {
        JLabel ruleNameLabel = new JLabel(RULE_NAME_TITLE);
        JLabel commentLabel = new JLabel(COMMENT_LABEL_TITLE);
        JLabel statusLabel = new JLabel(STATUS_LABEL_TITLE);
        JPanel upperPanel = new JPanel(new GridLayout(6, 2));
        JPanel rulePanel = new JPanel(new GridLayout(1, 1));
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JPanel surroundPanel = new JPanel(new BorderLayout());
        Container contentPane = this.getContentPane();
        this.ruleNameTextField.setBorder(this.loweredBevelBorder);
        this.ruleTextTextArea.setLineWrap(true);
        this.ruleTextTextArea.setWrapStyleWord(true);
        this.ruleTextTextArea.setBorder(this.loweredBevelBorder);
        this.ruleTextTextArea.setPreferredSize(new Dimension(300, 300));
        this.commentTextField.setDisabledTextColor(Color.BLACK);
        this.commentTextField.setBorder(this.loweredBevelBorder);
        this.statusTextField.setDisabledTextColor(Color.BLACK);
        this.statusTextField.setEnabled(false);
        this.statusTextField.setBorder(this.loweredBevelBorder);
        this.cancelButton.setPreferredSize(new Dimension(100, 30));
        this.saveButton.setPreferredSize(new Dimension(100, 30));
        contentPane.setLayout(new BorderLayout());
        upperPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        upperPanel.add(ruleNameLabel);
        upperPanel.add(this.ruleNameTextField);
        upperPanel.add(commentLabel);
        upperPanel.add(this.commentTextField);
        upperPanel.add(statusLabel);
        upperPanel.add(this.statusTextField);
        rulePanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        rulePanel.add(this.ruleTextTextArea);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.saveButton);
        surroundPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        contentPane.add((Component)surroundPanel, "Center");
        surroundPanel.add((Component)upperPanel, "North");
        surroundPanel.add((Component)rulePanel, "Center");
        surroundPanel.add((Component)buttonPanel, "South");
        this.pack();
    }

    private void autoComplete() {
        if (!this.isInAutoCompleteMode()) {
            List<String> expansions;
            int textPosition;
            int i;
            String ruleText = this.getRuleText();
            String prefix = ruleText.substring(i = SWRLParser.findSplittingPoint(ruleText.substring(0, textPosition = this.ruleTextTextArea.getCaretPosition())), textPosition);
            if (!prefix.equals("") && (expansions = this.getExpansions(prefix)).size() > 1) {
                SWRLRuleEditorAutoCompleteState state = new SWRLRuleEditorAutoCompleteState(textPosition, prefix, expansions);
                this.insertExpansion(textPosition, prefix, state.getNextExpansion());
                this.enableAutoCompleteMode(state);
            }
        } else {
            int textPosition = this.autoCompleteState.get().getTextPosition();
            String prefix = this.autoCompleteState.get().getPrefix();
            String currentExpansion = this.autoCompleteState.get().getCurrentExpansion();
            String nextExpansion = this.autoCompleteState.get().getNextExpansion();
            this.replaceExpansion(textPosition, prefix, currentExpansion, nextExpansion);
        }
    }

    private boolean isInAutoCompleteMode() {
        return this.autoCompleteState.isPresent();
    }

    private void enableAutoCompleteMode(@NonNull SWRLRuleEditorAutoCompleteState autoCompleteState) {
        this.autoCompleteState = Optional.of(autoCompleteState);
    }

    private void disableAutoCompleteModeIfNecessary() {
        if (this.autoCompleteState.isPresent()) {
            this.disableAutoCompleteMode();
        }
    }

    private void disableAutoCompleteMode() {
        this.autoCompleteState = Optional.empty();
    }

    private void cancelAutoCompleteIfNecessary() {
        if (this.isInAutoCompleteMode()) {
            int textPosition = this.autoCompleteState.get().getTextPosition();
            String prefix = this.autoCompleteState.get().getPrefix();
            String currentExpansion = this.autoCompleteState.get().getCurrentExpansion();
            this.replaceExpansion(textPosition, prefix, currentExpansion, "");
            this.disableAutoCompleteMode();
        }
    }

    private void insertExpansion(int textPosition, @NonNull String prefix, @NonNull String expansion) {
        String expansionTail = expansion.substring(prefix.length());
        try {
            Document document = this.ruleTextTextArea.getDocument();
            if (document != null) {
                document.insertString(textPosition, expansionTail, SimpleAttributeSet.EMPTY);
            } else {
                this.disableAutoCompleteMode();
            }
        }
        catch (BadLocationException e) {
            this.disableAutoCompleteMode();
        }
    }

    private void replaceExpansion(int textPosition, @NonNull String prefix, @NonNull String currentExpansion, @NonNull String nextExpansion) {
        String currentExpansionTail = currentExpansion.isEmpty() ? "" : currentExpansion.substring(prefix.length());
        String nextExpansionTail = nextExpansion.isEmpty() ? "" : nextExpansion.substring(prefix.length());
        try {
            if (!currentExpansionTail.isEmpty()) {
                this.ruleTextTextArea.getDocument().remove(textPosition, currentExpansionTail.length());
            }
            if (!nextExpansionTail.isEmpty()) {
                this.ruleTextTextArea.getDocument().insertString(textPosition, nextExpansionTail, SimpleAttributeSet.EMPTY);
            }
        }
        catch (BadLocationException e) {
            this.disableAutoCompleteMode();
        }
    }

    private @NonNull List<@NonNull String> getExpansions(@NonNull String prefix) {
        ArrayList<@NonNull String> expansions = new ArrayList<String>();
        expansions.add("");
        expansions.addAll(this.createSWRLAutoCompleter().getCompletions(prefix));
        return expansions;
    }

    private @NonNull SWRLAutoCompleter createSWRLAutoCompleter() {
        return this.swrlRuleEngineModel.createSWRLAutoCompleter();
    }

    private void disableSave() {
        this.saveButton.setEnabled(false);
    }

    private void enableSave() {
        this.saveButton.setEnabled(true);
    }

    private void setInformationalStatusText(@NonNull String status) {
        this.statusTextField.setBorder(this.loweredBevelBorder);
        this.statusTextField.setDisabledTextColor(Color.BLACK);
        this.statusTextField.setText(status);
    }

    private void setIncompleteStatusText(@NonNull String status) {
        this.statusTextField.setBorder(this.yellowBorder);
        this.statusTextField.setDisabledTextColor(Color.BLACK);
        this.statusTextField.setText(status);
    }

    private void setErrorStatusText(@NonNull String status) {
        this.statusTextField.setDisabledTextColor(Color.RED);
        this.statusTextField.setText(status);
    }

    private @NonNull String getRuleName() {
        return this.ruleNameTextField.getText().trim();
    }

    private @NonNull String getComment() {
        return this.commentTextField.getText().trim();
    }

    private @NonNull String getRuleText() {
        return this.ruleTextTextArea.getText().replaceAll(Character.toString('\u02da'), ".");
    }

    private @NonNull SWRLRuleEngine getSWRLRuleEngine() {
        return this.swrlRuleEngineModel.getSWRLRuleEngine();
    }

    private @NonNull SWRLRuleEngineModel getSWRLRuleEngineModel() {
        return this.swrlRuleEngineModel;
    }

    private @NonNull SWRLRuleEditorInitialDialogState getInitialDialogState() {
        return this.initialDialogState;
    }

    private @NonNull SWRLParser createSWRLParser() {
        return this.swrlRuleEngineModel.createSWRLParser();
    }

    private @NonNull SWRLRulesAndSQWRLQueriesTableModel getSWRLRulesTableModel() {
        return this.swrlRuleEngineModel.getSWRLRulesTableModel();
    }

    private @NonNull SWRLRuleEngineDialogManager getDialogManager() {
        return this.dialogManager;
    }

    private void setInitialDialogState() {
        this.initialDialogState.setState(this.getRuleName(), this.getComment(), this.getRuleText());
    }

    private boolean hasDialogStateChanged() {
        return this.initialDialogState.hasStateChanged(this.getRuleName(), this.getComment(), this.getRuleText());
    }

    private void closeIfOk(@NonNull Component parent) {
        boolean okToQuit;
        boolean bl = okToQuit = !this.hasDialogStateChanged() || this.getDialogManager().showConfirmDialog(parent, QUIT_CONFIRM_MESSAGE, QUIT_CONFIRM_TITLE);
        if (okToQuit) {
            this.cancelEditMode();
            this.setVisible(false);
        }
    }

    private class SaveSWRLRuleActionListener
    implements ActionListener {
        private final @NonNull Component parent;

        public SaveSWRLRuleActionListener(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent e) {
            boolean errorOccurred;
            String ruleName = SWRLRuleEditorDialog.this.getRuleName();
            String ruleText = SWRLRuleEditorDialog.this.getRuleText();
            String comment = SWRLRuleEditorDialog.this.getComment();
            if (ruleName.trim().length() == 0) {
                SWRLRuleEditorDialog.this.getDialogManager().showErrorMessageDialog(this.parent, SWRLRuleEditorDialog.MISSING_RULE_NAME, SWRLRuleEditorDialog.MISSING_RULE_NAME_TITLE);
                errorOccurred = true;
            } else if (ruleText.trim().length() == 0) {
                SWRLRuleEditorDialog.this.getDialogManager().showErrorMessageDialog(this.parent, SWRLRuleEditorDialog.MISSING_RULE, SWRLRuleEditorDialog.MISSING_RULE);
                errorOccurred = true;
            } else if (SWRLRuleEditorDialog.this.getSWRLRulesTableModel().hasSWRLRule(ruleName) && !SWRLRuleEditorDialog.this.editMode) {
                SWRLRuleEditorDialog.this.getDialogManager().showErrorMessageDialog(this.parent, SWRLRuleEditorDialog.DUPLICATE_RULE_TEXT, SWRLRuleEditorDialog.DUPLICATE_RULE_TITLE);
                errorOccurred = true;
            } else {
                try {
                    if (SWRLRuleEditorDialog.this.editMode) {
                        SWRLRuleEditorDialog.this.getSWRLRuleEngineModel().getSWRLRuleEngine().replaceSWRLRule(SWRLRuleEditorDialog.this.getInitialDialogState().getRuleName(), ruleName, ruleText, comment, true);
                        SWRLRuleEditorDialog.this.getSWRLRulesTableModel().updateView();
                        errorOccurred = false;
                    } else if (SWRLRuleEditorDialog.this.getSWRLRulesTableModel().hasSWRLRule(ruleName)) {
                        SWRLRuleEditorDialog.this.getDialogManager().showErrorMessageDialog(this.parent, SWRLRuleEditorDialog.DUPLICATE_RULE_TEXT, SWRLRuleEditorDialog.DUPLICATE_RULE_TITLE);
                        errorOccurred = true;
                    } else {
                        SWRLRuleEditorDialog.this.getSWRLRuleEngine().createSWRLRule(ruleName, ruleText, comment, true);
                        SWRLRuleEditorDialog.this.getSWRLRulesTableModel().updateView();
                        errorOccurred = false;
                    }
                }
                catch (SWRLBuiltInException | SWRLParseException pe) {
                    SWRLRuleEditorDialog.this.getDialogManager().showErrorMessageDialog(this.parent, pe.getMessage() != null ? pe.getMessage() : "", SWRLRuleEditorDialog.INVALID_RULE_TITLE);
                    errorOccurred = true;
                }
                catch (RuntimeException pe) {
                    SWRLRuleEditorDialog.this.getDialogManager().showErrorMessageDialog(this.parent, pe.getMessage() != null ? pe.getMessage() : "", SWRLRuleEditorDialog.INTERNAL_ERROR_TITLE);
                    errorOccurred = true;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pe.printStackTrace(pw);
                    log.warn(sw.toString());
                }
            }
            if (!errorOccurred) {
                SWRLRuleEditorDialog.this.setVisible(false);
                SWRLRuleEditorDialog.this.cancelEditMode();
            } else {
                SWRLRuleEditorDialog.this.updateStatus();
            }
        }
    }

    private class CancelSWRLRuleEditActionListener
    implements ActionListener {
        private final @NonNull Component parent;

        public CancelSWRLRuleEditActionListener(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent e) {
            SWRLRuleEditorDialog.this.closeIfOk(this.parent);
        }
    }

    class CloseWindowListener
    extends WindowAdapter {
        private final @NonNull Component parent;

        public CloseWindowListener(Component parent) {
            this.parent = parent;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SWRLRuleEditorDialog.this.closeIfOk(this.parent);
        }
    }

    private class SWRLRuleEditorKeyAdapter
    extends KeyAdapter {
        private SWRLRuleEditorKeyAdapter() {
        }

        @Override
        public void keyPressed(@NonNull KeyEvent event) {
            int code = event.getKeyCode();
            if (code == 9 || code == 32 && event.isControlDown()) {
                SWRLRuleEditorDialog.this.autoComplete();
                event.consume();
            } else if (code == 27) {
                SWRLRuleEditorDialog.this.cancelAutoCompleteIfNecessary();
                event.consume();
            } else if (code == 127) {
                SWRLRuleEditorDialog.this.cancelAutoCompleteIfNecessary();
            } else {
                SWRLRuleEditorDialog.this.disableAutoCompleteModeIfNecessary();
                super.keyPressed(event);
            }
        }

        @Override
        public void keyReleased(@NonNull KeyEvent event) {
            SWRLRuleEditorDialog.this.updateStatus();
        }
    }
}

