/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.menu;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.ui.action.CloseAction;
import org.swrlapi.ui.action.OpenAction;
import org.swrlapi.ui.action.QuitAction;
import org.swrlapi.ui.action.SaveAction;
import org.swrlapi.ui.action.SaveAsAction;
import org.swrlapi.ui.dialog.SWRLRuleEngineDialogManager;
import org.swrlapi.ui.model.FileBackedSWRLRuleEngineModel;

public class SWRLRuleEngineMenuManager {
    private static final String FILE_MENU_TITLE = "File";

    public static void createSWRLRuleEngineMenus(@NonNull JFrame applicationFrame, @NonNull FileBackedSWRLRuleEngineModel ruleEngineModel, @NonNull SWRLRuleEngineDialogManager dialogManager) {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(FILE_MENU_TITLE);
        JMenuItem openItem = new JMenuItem("Open");
        JMenuItem saveItem = new JMenuItem("Save");
        JMenuItem saveAsItem = new JMenuItem("Save As");
        JMenuItem closeItem = new JMenuItem("Close");
        JMenuItem quitItem = new JMenuItem("Quit");
        openItem.addActionListener(new OpenAction(applicationFrame, ruleEngineModel, dialogManager));
        saveItem.addActionListener(new SaveAction(applicationFrame, ruleEngineModel, dialogManager));
        saveAsItem.addActionListener(new SaveAsAction(applicationFrame, ruleEngineModel, dialogManager));
        closeItem.addActionListener(new CloseAction(applicationFrame, ruleEngineModel, dialogManager));
        quitItem.addActionListener(new QuitAction(applicationFrame, ruleEngineModel, dialogManager));
        menu.add(openItem);
        menu.add(saveItem);
        menu.add(saveAsItem);
        menu.add(closeItem);
        menu.add(quitItem);
        menuBar.add(menu);
        applicationFrame.setJMenuBar(menuBar);
        menu.addMenuListener(new SWRLRuleEngineMenuListener(ruleEngineModel, saveItem));
    }

    private static class SWRLRuleEngineMenuListener
    implements MenuListener {
        private final @NonNull FileBackedSWRLRuleEngineModel ruleEngineModel;
        private final @NonNull JMenuItem saveItem;

        public SWRLRuleEngineMenuListener(@NonNull FileBackedSWRLRuleEngineModel ruleEngineModel, @NonNull JMenuItem saveItem) {
            this.ruleEngineModel = ruleEngineModel;
            this.saveItem = saveItem;
        }

        @Override
        public void menuSelected(@NonNull MenuEvent e) {
            this.saveItem.setEnabled(this.ruleEngineModel.hasBackingFile());
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

