/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.model;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.swrlapi.core.SWRLAPIRule;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.core.SWRLRuleRenderer;
import org.swrlapi.ui.model.SWRLAPIModel;
import org.swrlapi.ui.view.SWRLAPIView;

public class SWRLRulesAndSQWRLQueriesTableModel
extends AbstractTableModel
implements SWRLAPIModel {
    private static final long serialVersionUID = 1L;
    private static final String RULE_NAME_COLUMN_TITLE = "Name";
    private static final String RULE_TEXT_COLUMN_TITLE = "Rule";
    private static final String QUERY_TEXT_COLUMN_TITLE = "Query";
    private static final String RULE_AND_QUERY_TEXT_COLUMN_TITLE = "Body";
    private static final String RULE_COMMENT_COLUMN_TITLE = "Comment";
    private @NonNull SWRLRuleEngine swrlRuleEngine;
    private @NonNull SWRLRuleRenderer swrlRuleRenderer;
    private final @NonNull SortedMap<@NonNull String, @NonNull SWRLRuleModel> swrlRuleModels;
    private @NonNull Optional<@NonNull SWRLAPIView> view = Optional.empty();
    private ContentMode contentMode;
    private boolean isModified;

    public SWRLRulesAndSQWRLQueriesTableModel(@NonNull SWRLRuleEngine swrlRuleEngine) {
        this.swrlRuleEngine = swrlRuleEngine;
        this.swrlRuleRenderer = this.swrlRuleEngine.createSWRLRuleRenderer();
        this.swrlRuleModels = new TreeMap<String, SWRLRuleModel>();
        this.isModified = false;
        this.contentMode = ContentMode.RuleContentOnly;
    }

    public void setView(@NonNull SWRLAPIView view) {
        this.view = Optional.of(view);
        this.updateRuleModels();
    }

    public void updateModel(@NonNull SWRLRuleEngine swrlRuleEngine) {
        this.swrlRuleEngine = swrlRuleEngine;
        this.swrlRuleRenderer = this.swrlRuleEngine.createSWRLRuleRenderer();
        this.swrlRuleModels.clear();
        this.isModified = false;
        this.updateView();
    }

    public void setContentMode(ContentMode contentMode) {
        this.contentMode = contentMode;
        this.updateView();
    }

    public @NonNull Set<@NonNull SWRLRuleModel> getSWRLRuleModels() {
        return new HashSet<SWRLRuleModel>(this.swrlRuleModels.values());
    }

    public @NonNull Set<@NonNull SWRLRuleModel> getSWRLRuleModels(boolean isActiveFlag) {
        HashSet<@NonNull SWRLRuleModel> swrlRuleModels = new HashSet<SWRLRuleModel>();
        for (SWRLRuleModel swrlRuleModel : this.swrlRuleModels.values()) {
            if (swrlRuleModel.isActive() != isActiveFlag) continue;
            swrlRuleModels.add(swrlRuleModel);
        }
        return swrlRuleModels;
    }

    public boolean hasSWRLRules() {
        return !this.swrlRuleModels.isEmpty();
    }

    public @NonNull String getSWRLRuleNameByIndex(int ruleIndex) {
        Optional<@NonNull SWRLRuleModel> swrlRuleModel = this.getSWRLRuleModelByIndex(ruleIndex);
        if (swrlRuleModel.isPresent()) {
            return swrlRuleModel.get().getRuleName();
        }
        return "<INVALID_INDEX>";
    }

    public @NonNull String getSWRLRuleTextByIndex(int ruleIndex) {
        Optional<@NonNull SWRLRuleModel> swrlRuleModel = this.getSWRLRuleModelByIndex(ruleIndex);
        if (swrlRuleModel.isPresent()) {
            return swrlRuleModel.get().getRuleText();
        }
        return "<INVALID_INDEX>";
    }

    public @NonNull String getSWRLRuleCommentByIndex(int ruleIndex) {
        Optional<@NonNull SWRLRuleModel> swrlRuleModel = this.getSWRLRuleModelByIndex(ruleIndex);
        if (swrlRuleModel.isPresent()) {
            return swrlRuleModel.get().getComment();
        }
        return "<INVALID_INDEX>";
    }

    public boolean hasSWRLRule(@NonNull String ruleName) {
        return this.swrlRuleModels.containsKey(ruleName);
    }

    public boolean hasBeenModified() {
        return this.isModified;
    }

    public void clearModifiedStatus() {
        this.isModified = false;
    }

    public int getNumberOfColumns() {
        return this.contentMode == ContentMode.QueryContentOnly ? 3 : 4;
    }

    public boolean hasRuleActiveColumn() {
        return this.contentMode != ContentMode.QueryContentOnly;
    }

    public int getRuleActiveColumnNumber() {
        return this.contentMode == ContentMode.QueryContentOnly ? -1 : 0;
    }

    public int getRuleNameColumnNumber() {
        return this.contentMode == ContentMode.QueryContentOnly ? 0 : 1;
    }

    public int getRuleTextColumnNumber() {
        return this.contentMode == ContentMode.QueryContentOnly ? 1 : 2;
    }

    public int getRuleCommentColumnNumber() {
        return this.contentMode == ContentMode.QueryContentOnly ? 2 : 3;
    }

    @Override
    public int getRowCount() {
        return this.swrlRuleModels.size();
    }

    @Override
    public int getColumnCount() {
        return this.getNumberOfColumns();
    }

    @Override
    public @NonNull String getColumnName(int column) {
        if (column == this.getRuleNameColumnNumber()) {
            return RULE_NAME_COLUMN_TITLE;
        }
        if (column == this.getRuleTextColumnNumber()) {
            switch (this.contentMode) {
                case RuleContentOnly: {
                    return RULE_TEXT_COLUMN_TITLE;
                }
                case QueryContentOnly: {
                    return QUERY_TEXT_COLUMN_TITLE;
                }
                case RuleAndQueryContent: {
                    return RULE_AND_QUERY_TEXT_COLUMN_TITLE;
                }
            }
            return "<INVALID>";
        }
        if (column == this.getRuleCommentColumnNumber()) {
            return RULE_COMMENT_COLUMN_TITLE;
        }
        if (column == this.getRuleActiveColumnNumber()) {
            return "";
        }
        return "";
    }

    @Override
    public @NonNull Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return "<OUT OF BOUNDS>";
        }
        SWRLRuleModel swrlRuleModel = (SWRLRuleModel)this.swrlRuleModels.values().toArray()[row];
        if (column == this.getRuleTextColumnNumber()) {
            return swrlRuleModel.getRuleText();
        }
        if (column == this.getRuleNameColumnNumber()) {
            return swrlRuleModel.getRuleName();
        }
        if (column == this.getRuleCommentColumnNumber()) {
            return swrlRuleModel.getComment();
        }
        if (column == this.getRuleActiveColumnNumber()) {
            return swrlRuleModel.isActive() && !swrlRuleModel.isSQWRLQuery();
        }
        return ">INVALID COLUMN>";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.hasRuleActiveColumn() && columnIndex == this.getRuleActiveColumnNumber()) {
            SWRLRuleModel swrlRuleModel = (SWRLRuleModel)this.swrlRuleModels.values().toArray()[rowIndex];
            return !swrlRuleModel.isSQWRLQuery();
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.getRuleActiveColumnNumber()) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == this.getRuleActiveColumnNumber()) {
            ((SWRLRuleModel)this.swrlRuleModels.values().toArray()[rowIndex]).setActive((Boolean)aValue);
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex);
        }
    }

    @Override
    public void updateView() {
        if (this.view.isPresent()) {
            this.updateRuleModels();
            this.view.get().update();
        }
    }

    private @NonNull SWRLRuleRenderer getSWRLRuleRenderer() {
        return this.swrlRuleRenderer;
    }

    private @NonNull Optional<@NonNull SWRLRuleModel> getSWRLRuleModelByIndex(int ruleIndex) {
        if (ruleIndex >= 0 && ruleIndex < this.swrlRuleModels.values().size()) {
            return Optional.of((SWRLRuleModel)this.swrlRuleModels.values().toArray()[ruleIndex]);
        }
        return Optional.empty();
    }

    private void updateRuleModels() {
        this.swrlRuleModels.clear();
        for (SWRLAPIRule swrlapiRule : this.swrlRuleEngine.getSWRLRules()) {
            String ruleName = swrlapiRule.getRuleName();
            SWRLRuleModel swrlRuleModel = new SWRLRuleModel(swrlapiRule);
            this.swrlRuleModels.put(ruleName, swrlRuleModel);
        }
    }

    public String toString() {
        return "SWRLRulesAndSQWRLQueriesTableModel{swrlRuleEngine=" + this.swrlRuleEngine + ", swrlRuleModels=" + this.swrlRuleModels + ", view=" + this.view + ", contentMode=" + (Object)((Object)this.contentMode) + ", isModified=" + this.isModified + '}';
    }

    private class SWRLRuleModel {
        private final @NonNull SWRLAPIRule rule;

        public SWRLRuleModel(SWRLAPIRule rule) {
            this.rule = rule;
        }

        public void setActive(boolean active) {
            this.rule.setActive(active);
        }

        public boolean isActive() {
            return this.rule.isActive();
        }

        public boolean isSQWRLQuery() {
            return this.rule.isSQWRLQuery();
        }

        public @NonNull String getRuleText() {
            return SWRLRulesAndSQWRLQueriesTableModel.this.getSWRLRuleRenderer().renderSWRLRule(this.rule);
        }

        public @NonNull String getRuleName() {
            return this.rule.getRuleName();
        }

        public @NonNull String getComment() {
            return this.rule.getComment();
        }

        @SideEffectFree
        public @NonNull String toString() {
            return "(ruleName: " + this.getRuleName() + ", ruleText: " + this.getRuleText() + ", comment: " + this.getComment() + ", active: " + this.isActive() + ")";
        }
    }

    public static enum ContentMode {
        RuleContentOnly,
        QueryContentOnly,
        RuleAndQueryContent;

    }
}

