/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.parser.SWRLParseException;
import org.swrlapi.ui.action.DisableAllRulesAction;
import org.swrlapi.ui.action.EnableAllRulesAction;
import org.swrlapi.ui.dialog.SWRLRuleEngineDialogManager;
import org.swrlapi.ui.model.SWRLRuleEngineModel;
import org.swrlapi.ui.model.SWRLRulesAndSQWRLQueriesTableModel;
import org.swrlapi.ui.view.SWRLAPIView;

public class SWRLRulesTableView
extends JPanel
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SWRLRulesTableView.class);
    private static final String NEW_BUTTON_TITLE = "New";
    private static final String EDIT_BUTTON_TITLE = "Edit";
    private static final String DELETE_BUTTON_TITLE = "Delete";
    private static final String CLONE_BUTTON_TITLE = "Clone";
    private static final int ACTIVE_COLUMN_PREFERRED_WIDTH = 30;
    private static final int ACTIVE_COLUMN_MAX_WIDTH = 50;
    private static final int RULE_NAME_COLUMN_PREFERRED_WIDTH = 150;
    private static final int RULE_NAME_COLUMN_MAX_WIDTH = 200;
    private static final int RULE_TEXT_COLUMN_PREFERRED_WIDTH = 500;
    private static final int RULE_TEXT_COLUMN_MAX_WIDTH = 1400;
    private static final int COMMENT_COLUMN_PREFERRED_WIDTH = 200;
    private static final int COMMENT_COLUMN_MAX_WIDTH = 300;
    private final @NonNull SWRLRuleEngineModel swrlRuleEngineModel;
    private final @NonNull SWRLRulesAndSQWRLQueriesTableModel tableModel;
    private final @NonNull SWRLRuleEngineDialogManager dialogManager;
    private final @NonNull JTable swrlRulesTable;
    private final @NonNull JButton newButton;
    private final @NonNull JButton cloneButton;
    private final @NonNull JButton editButton;
    private final @NonNull JButton deleteButton;

    public SWRLRulesTableView(@NonNull SWRLRuleEngineModel swrlRuleEngineModel, @NonNull SWRLRuleEngineDialogManager dialogManager) {
        this.swrlRuleEngineModel = swrlRuleEngineModel;
        this.dialogManager = dialogManager;
        this.tableModel = swrlRuleEngineModel.getSWRLRulesTableModel();
        this.swrlRulesTable = new JTable(this.tableModel);
        this.swrlRulesTable.setSelectionMode(0);
        this.deleteButton = new JButton(DELETE_BUTTON_TITLE);
        this.editButton = new JButton(EDIT_BUTTON_TITLE);
        this.cloneButton = new JButton(CLONE_BUTTON_TITLE);
        this.newButton = new JButton(NEW_BUTTON_TITLE);
    }

    @Override
    public void initialize() {
        this.swrlRuleEngineModel.getSWRLRulesTableModel().setView(this);
        this.addTableListeners();
        this.setPreferredColumnWidths();
        this.createComponents(this.dialogManager);
        this.createPopupMenu();
    }

    @Override
    public void update() {
        this.getSWRLRulesTableModel().fireTableDataChanged();
        this.validate();
    }

    public Optional<@NonNull String> getSelectedSWRLRuleName() {
        int selectedRow = this.swrlRulesTable.getSelectedRow();
        if (selectedRow != -1) {
            return Optional.of(this.getSWRLRulesTableModel().getSWRLRuleNameByIndex(selectedRow));
        }
        return Optional.empty();
    }

    private Optional<@NonNull String> getSelectedSWRLRuleText() {
        int selectedRow = this.swrlRulesTable.getSelectedRow();
        if (selectedRow != -1) {
            String ruleText = this.getSWRLRulesTableModel().getSWRLRuleTextByIndex(selectedRow);
            return Optional.of(ruleText.replaceAll(Character.toString('\u02da'), " . "));
        }
        return Optional.empty();
    }

    private Optional<@NonNull String> getSelectedSWRLRuleComment() {
        int selectedRow = this.swrlRulesTable.getSelectedRow();
        if (selectedRow != -1) {
            return Optional.of(this.getSWRLRulesTableModel().getSWRLRuleCommentByIndex(selectedRow));
        }
        return Optional.empty();
    }

    private void setPreferredColumnWidths() {
        TableColumnModel columnModel = this.swrlRulesTable.getColumnModel();
        if (this.tableModel.hasRuleActiveColumn()) {
            columnModel.getColumn(this.tableModel.getRuleActiveColumnNumber()).setPreferredWidth(30);
            columnModel.getColumn(this.tableModel.getRuleActiveColumnNumber()).setMaxWidth(50);
        }
        columnModel.getColumn(this.tableModel.getRuleNameColumnNumber()).setPreferredWidth(150);
        columnModel.getColumn(this.tableModel.getRuleNameColumnNumber()).setMaxWidth(200);
        columnModel.getColumn(this.tableModel.getRuleTextColumnNumber()).setPreferredWidth(500);
        columnModel.getColumn(this.tableModel.getRuleTextColumnNumber()).setMaxWidth(1400);
        columnModel.getColumn(this.tableModel.getRuleCommentColumnNumber()).setPreferredWidth(200);
        columnModel.getColumn(this.tableModel.getRuleCommentColumnNumber()).setMaxWidth(300);
    }

    private void addTableListeners() {
        this.swrlRulesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NonNull MouseEvent e) {
                if (e.getClickCount() == 2 && e.getSource() == SWRLRulesTableView.this.swrlRulesTable) {
                    SWRLRulesTableView.this.editSelectedSWRLRule();
                }
            }
        });
        this.swrlRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SWRLRulesTableView.this.hasSelectedRule()) {
                    SWRLRulesTableView.this.enableEditAndCloneAndDelete();
                } else {
                    SWRLRulesTableView.this.disableEditAndCloneAndDelete();
                }
            }
        });
    }

    private void editSelectedSWRLRule() {
        if (this.swrlRulesTable.getSelectedRow() != -1) {
            String ruleName = this.getSelectedSWRLRuleName().get();
            String ruleText = this.getSelectedSWRLRuleText().get();
            String ruleComment = this.getSelectedSWRLRuleComment().get();
            this.dialogManager.getSWRLRuleEditorDialog(this, ruleName, ruleText, ruleComment).setVisible(true);
        }
    }

    private void cloneSelectedSWRLRule() {
        Optional<String> ruleName;
        if (this.swrlRulesTable.getSelectedRow() != -1 && (ruleName = this.getSWRLRuleEngineModel().getNextRuleName()).isPresent()) {
            String ruleText = this.getSelectedSWRLRuleText().get();
            String ruleComment = this.getSelectedSWRLRuleComment().get();
            try {
                this.getSWRLRuleEngineModel().getSWRLRuleEngine().createSWRLRule(ruleName.get(), ruleText, ruleComment, true);
                this.getSWRLRuleEngineModel().updateView();
            }
            catch (SWRLBuiltInException | SWRLParseException e) {
                log.warn("Error cloning rule " + ruleName + ": " + e.getMessage());
            }
        }
    }

    private void createComponents(SWRLRuleEngineDialogManager dialogManager) {
        JScrollPane scrollPane = new JScrollPane(this.swrlRulesTable);
        JViewport viewport = scrollPane.getViewport();
        this.setLayout(new BorderLayout());
        JPanel headingPanel = new JPanel(new BorderLayout());
        this.add((Component)headingPanel, "South");
        viewport.setBackground(this.swrlRulesTable.getBackground());
        JPanel buttonPanel = new JPanel(new GridLayout(1, 4));
        headingPanel.add((Component)buttonPanel, "East");
        this.newButton.addActionListener(new NewSWRLRuleActionListener(this, dialogManager));
        buttonPanel.add(this.newButton);
        this.editButton.addActionListener(new EditSWRLRuleActionListener(this, dialogManager));
        buttonPanel.add(this.editButton);
        this.cloneButton.addActionListener(new CloneSWRLRuleActionListener(this, dialogManager));
        buttonPanel.add(this.cloneButton);
        this.deleteButton.addActionListener(new DeleteSWRLRuleActionListener(this, dialogManager));
        buttonPanel.add(this.deleteButton);
        this.disableEditAndCloneAndDelete();
        this.add((Component)scrollPane, "Center");
        this.validate();
    }

    private void enableEditAndCloneAndDelete() {
        this.editButton.setEnabled(true);
        this.cloneButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
    }

    private void disableEditAndCloneAndDelete() {
        this.editButton.setEnabled(false);
        this.cloneButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    private boolean hasSelectedRule() {
        return this.swrlRulesTable.getSelectedRow() != -1;
    }

    private @NonNull SWRLRulesAndSQWRLQueriesTableModel getSWRLRulesTableModel() {
        return this.swrlRuleEngineModel.getSWRLRulesTableModel();
    }

    private @NonNull SWRLRuleEngineModel getSWRLRuleEngineModel() {
        return this.swrlRuleEngineModel;
    }

    private void createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new EnableAllRulesAction());
        popup.add(new DisableAllRulesAction());
        this.addMouseListener(new PopupListener(popup));
    }

    private class PopupListener
    extends MouseAdapter {
        private final @NonNull JPopupMenu popup;

        public PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(@NonNull MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(@NonNull MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(@NonNull MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class DeleteSWRLRuleActionListener
    extends ActionListenerBase {
        public DeleteSWRLRuleActionListener(@NonNull Component parent, SWRLRuleEngineDialogManager dialogManager) {
            super(parent, dialogManager);
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent e) {
            this.deleteSelectedSWRLRule();
        }

        private void deleteSelectedSWRLRule() {
            Optional<@NonNull String> selectedRuleName = SWRLRulesTableView.this.getSelectedSWRLRuleName();
            if (selectedRuleName.isPresent() && SWRLRulesTableView.this.getSWRLRulesTableModel().hasSWRLRule(selectedRuleName.get()) && this.dialogManager.showConfirmDialog(this.parent, "Do you really want to delete the rule?", "Delete Rule")) {
                SWRLRulesTableView.this.getSWRLRuleEngineModel().getSWRLRuleEngine().deleteSWRLRule(selectedRuleName.get());
                SWRLRulesTableView.this.getSWRLRuleEngineModel().updateView();
            }
        }
    }

    private class CloneSWRLRuleActionListener
    extends ActionListenerBase {
        public CloneSWRLRuleActionListener(@NonNull Component parent, SWRLRuleEngineDialogManager dialogManager) {
            super(parent, dialogManager);
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent e) {
            SWRLRulesTableView.this.cloneSelectedSWRLRule();
        }
    }

    private class EditSWRLRuleActionListener
    extends ActionListenerBase {
        public EditSWRLRuleActionListener(@NonNull Component parent, SWRLRuleEngineDialogManager dialogManager) {
            super(parent, dialogManager);
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent e) {
            SWRLRulesTableView.this.editSelectedSWRLRule();
        }
    }

    private class NewSWRLRuleActionListener
    extends ActionListenerBase {
        public NewSWRLRuleActionListener(@NonNull Component parent, SWRLRuleEngineDialogManager dialogManager) {
            super(parent, dialogManager);
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent e) {
            this.dialogManager.getSWRLRuleEditorDialog(this.parent).setVisible(true);
        }
    }

    private abstract class ActionListenerBase
    implements ActionListener {
        protected final @NonNull SWRLRuleEngineDialogManager dialogManager;
        protected final @NonNull Component parent;

        protected ActionListenerBase(@NonNull Component parent, SWRLRuleEngineDialogManager dialogManager) {
            this.parent = parent;
            this.dialogManager = dialogManager;
        }
    }
}

