/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.owl2rl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.ui.model.OWL2RLModel;
import org.swrlapi.ui.view.SWRLAPIView;
import org.swrlapi.ui.view.owl2rl.OWL2RLTablesControlView;

public class OWL2RLControlView
extends JPanel
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private static final int VIEW_PREFERRED_WIDTH = 900;
    private static final int VIEW_PREFERRED_HEIGHT = 300;
    private static final int CONSOLE_ROWS = 10;
    private static final int CONSOLE_COLUMNS = 80;
    private final @NonNull OWL2RLTablesControlView owl2RLTablesControlView;

    public OWL2RLControlView(@NonNull OWL2RLModel owl2RLModel) {
        this.owl2RLTablesControlView = new OWL2RLTablesControlView(owl2RLModel);
    }

    @Override
    public void initialize() {
        this.owl2RLTablesControlView.initialize();
        JTextArea console = this.createConsole();
        JScrollPane scrollPane = new JScrollPane(console);
        this.setLayout(new BorderLayout());
        scrollPane.setPreferredSize(new Dimension(900, 300));
        this.add("Center", scrollPane);
        console.append("The SWRLAPI supports an OWL profile called OWL 2 RL and uses an OWL 2 RL-based reasoner to perform reasoning.\n\n");
        console.append("OWL 2 RL reasoning is performed primarily via a set of implication rules. These rules are described\n");
        console.append("in the following W3C document: http://www.w3.org/TR/owl2-profiles/#OWL_2_RL.\n");
        console.append("This document divides these rules into a set of numbered tables and each rule is given a unique name.\n\n");
        console.append("The toggle buttons below allow all rules in particular tables to be enabled and disabled.\n\n");
        console.append("The table-specific subtabs list individual rule names, indicate their support status, and allow suported rules to be\n");
        console.append("enabled or disabled. A check next to each rule indicates whether that rule is enabled or disabled. Greyed-out\n");
        console.append("rules are either permanently enabled or currently unsupported and cannot be toggled.\n\n");
        this.add("South", this.owl2RLTablesControlView);
    }

    @Override
    public void update() {
        this.owl2RLTablesControlView.update();
    }

    private @NonNull JTextArea createConsole() {
        JTextArea textArea = new JTextArea(10, 80);
        textArea.setLineWrap(true);
        textArea.setBackground(Color.WHITE);
        textArea.setEditable(false);
        return textArea;
    }
}

