/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.owl2rl;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.owl2rl.OWL2RLNames;
import org.swrlapi.ui.model.OWL2RLModel;
import org.swrlapi.ui.view.SWRLAPIView;

public class OWL2RLRuleActivationButton
extends JCheckBox
implements ActionListener,
SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private static final int TOOLTIP_PREFERRED_WIDTH = 160;
    private static final int TOOLTIP_PREFERRED_HEIGHT = 30;
    private final @NonNull OWL2RLModel owl2RLModel;
    private final OWL2RLNames.OWL2RLRule rule;

    public OWL2RLRuleActivationButton(@NonNull OWL2RLModel owl2RLModel, OWL2RLNames.OWL2RLRule rule) {
        super(rule.toString());
        this.owl2RLModel = owl2RLModel;
        this.rule = rule;
    }

    @Override
    public void initialize() {
        this.setPreferredSize(new Dimension(160, 30));
        this.setToolTipText("Click to enable or disable OWL 2 RL rule " + this.rule.toString() + ".");
        this.addActionListener(this);
        this.update();
    }

    @Override
    public void update() {
        switch (this.getOWL2RLModel().getOWL2RLEngine().getRuleStatus(this.rule)) {
            case Unsupported: {
                this.setSelected(false);
                this.setEnabled(false);
                break;
            }
            case PermanentlyOn: {
                this.setSelected(true);
                this.setEnabled(false);
                break;
            }
            case Switchable: {
                this.setSelected(this.getOWL2RLModel().getOWL2RLEngine().isRuleEnabled(this.rule));
                this.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isSelected()) {
            this.getOWL2RLModel().getOWL2RLEngine().enableRules(this.rule);
        } else {
            this.getOWL2RLModel().getOWL2RLEngine().disableRules(this.rule);
        }
        this.getOWL2RLModel().updateView();
    }

    private @NonNull OWL2RLModel getOWL2RLModel() {
        return this.owl2RLModel;
    }
}

