/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.owl2rl;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.owl2rl.OWL2RLNames;
import org.swrlapi.ui.model.OWL2RLModel;
import org.swrlapi.ui.view.SWRLAPIView;

public class OWL2RLRuleTableActivationButton
extends JCheckBox
implements ActionListener,
SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private static final int TOOLTIP_PREFERRED_WIDTH = 160;
    private static final int TOOLTIP_PREFERRED_HEIGHT = 30;
    private final @NonNull OWL2RLModel owl2RLModel;
    private final OWL2RLNames.OWL2RLRuleTable ruleTable;

    public OWL2RLRuleTableActivationButton(@NonNull OWL2RLModel owl2RLModel, OWL2RLNames.OWL2RLRuleTable ruleTable) {
        super(ruleTable.toString());
        this.owl2RLModel = owl2RLModel;
        this.ruleTable = ruleTable;
    }

    @Override
    public void initialize() {
        this.setPreferredSize(new Dimension(160, 30));
        this.setToolTipText("Click to enable or disable OWL 2 RL ruleTable " + this.ruleTable.toString() + ".");
        this.setEnabled(this.owl2RLModel.getOWL2RLEngine().hasSwitchableRules(this.ruleTable));
        this.setSelected(this.owl2RLModel.getOWL2RLEngine().hasEnabledRules(this.ruleTable));
        this.addActionListener(this);
    }

    @Override
    public void update() {
        this.setSelected(this.getOWL2RLModel().getOWL2RLEngine().hasEnabledRules(this.ruleTable));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isSelected()) {
            this.getOWL2RLModel().getOWL2RLEngine().enableTables(this.ruleTable);
        } else {
            this.getOWL2RLModel().getOWL2RLEngine().disableTables(this.ruleTable);
        }
        this.getOWL2RLModel().updateView();
    }

    private @NonNull OWL2RLModel getOWL2RLModel() {
        return this.owl2RLModel;
    }
}

