/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.owl2rl;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.owl2rl.OWL2RLNames;
import org.swrlapi.ui.model.OWL2RLModel;
import org.swrlapi.ui.view.SWRLAPIView;
import org.swrlapi.ui.view.owl2rl.OWL2RLRuleActivationButton;

public class OWL2RLRuleTableView
extends JPanel
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private final @NonNull OWL2RLModel owl2RLModel;
    private final @NonNull List<@NonNull OWL2RLRuleActivationButton> ruleActivationButtons;
    private final OWL2RLNames.OWL2RLRuleTable owl2RLRuleTable;

    public OWL2RLRuleTableView(@NonNull OWL2RLModel owl2RLModel, OWL2RLNames.OWL2RLRuleTable owl2RLRuleTable) {
        this.owl2RLModel = owl2RLModel;
        this.owl2RLRuleTable = owl2RLRuleTable;
        this.ruleActivationButtons = new ArrayList<OWL2RLRuleActivationButton>();
    }

    @Override
    public void initialize() {
        int numberOfButtons = this.getOWL2RLModel().getOWL2RLEngine().getRules(this.owl2RLRuleTable).size();
        int n = 1 + (int)Math.sqrt(numberOfButtons);
        this.setLayout(new GridLayout(n, n));
        for (OWL2RLNames.OWL2RLRule rule : this.owl2RLModel.getOWL2RLEngine().getRules(this.owl2RLRuleTable)) {
            OWL2RLRuleActivationButton button = new OWL2RLRuleActivationButton(this.getOWL2RLModel(), rule);
            this.ruleActivationButtons.add(button);
            button.initialize();
            this.add(button);
        }
    }

    @Override
    public void update() {
        this.ruleActivationButtons.forEach(OWL2RLRuleActivationButton::update);
    }

    private @NonNull OWL2RLModel getOWL2RLModel() {
        return this.owl2RLModel;
    }
}

