/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.owl2rl;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.owl2rl.OWL2RLNames;
import org.swrlapi.ui.model.OWL2RLModel;
import org.swrlapi.ui.view.SWRLAPIView;
import org.swrlapi.ui.view.owl2rl.OWL2RLControlView;
import org.swrlapi.ui.view.owl2rl.OWL2RLRuleTableView;

public class OWL2RLRuleTablesView
extends JTabbedPane
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private final @NonNull OWL2RLModel owl2RLModel;
    private final @NonNull OWL2RLControlView owl2RLControlView;
    private final @NonNull List<@NonNull OWL2RLRuleTableView> owl2RLTableViews;

    public OWL2RLRuleTablesView(@NonNull OWL2RLModel owl2RLModel) {
        this.owl2RLModel = owl2RLModel;
        this.owl2RLTableViews = new ArrayList<OWL2RLRuleTableView>();
        this.owl2RLControlView = new OWL2RLControlView(this.owl2RLModel);
    }

    @Override
    public void initialize() {
        this.owl2RLControlView.initialize();
        this.addTab("OWL2RL Control", this.owl2RLControlView);
        for (OWL2RLNames.OWL2RLRuleTable ruleTable : this.owl2RLModel.getOWL2RLEngine().getRuleTables()) {
            OWL2RLRuleTableView owl2RLTableView = new OWL2RLRuleTableView(this.getOWL2RLModel(), ruleTable);
            owl2RLTableView.initialize();
            this.owl2RLTableViews.add(owl2RLTableView);
            this.addTab(ruleTable.toString(), owl2RLTableView);
        }
    }

    @Override
    public void update() {
        this.owl2RLTableViews.forEach(OWL2RLRuleTableView::update);
        this.owl2RLControlView.update();
    }

    private @NonNull OWL2RLModel getOWL2RLModel() {
        return this.owl2RLModel;
    }
}

