/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.owl2rl;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.owl2rl.OWL2RLNames;
import org.swrlapi.ui.model.OWL2RLModel;
import org.swrlapi.ui.view.SWRLAPIView;
import org.swrlapi.ui.view.owl2rl.OWL2RLRuleTableActivationButton;

public class OWL2RLTablesControlView
extends JPanel
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private final @NonNull OWL2RLModel owl2RLModel;
    private final @NonNull List<@NonNull OWL2RLRuleTableActivationButton> ruleTableActivationButtons;

    public OWL2RLTablesControlView(@NonNull OWL2RLModel owl2RLModel) {
        this.owl2RLModel = owl2RLModel;
        this.ruleTableActivationButtons = new ArrayList<OWL2RLRuleTableActivationButton>();
    }

    @Override
    public void initialize() {
        this.setLayout(new GridLayout(1, this.owl2RLModel.getOWL2RLEngine().getNumberOfTables()));
        for (OWL2RLNames.OWL2RLRuleTable ruleTable : this.owl2RLModel.getOWL2RLEngine().getRuleTables()) {
            OWL2RLRuleTableActivationButton button = new OWL2RLRuleTableActivationButton(this.owl2RLModel, ruleTable);
            button.initialize();
            this.ruleTableActivationButtons.add(button);
            this.add(button);
        }
    }

    @Override
    public void update() {
        this.ruleTableActivationButtons.forEach(OWL2RLRuleTableActivationButton::update);
    }
}

