/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.queries;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.sqwrl.SQWRLQueryEngine;
import org.swrlapi.sqwrl.SQWRLResult;
import org.swrlapi.sqwrl.exceptions.SQWRLException;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidQueryNameException;
import org.swrlapi.ui.model.SQWRLQueryEngineModel;
import org.swrlapi.ui.view.SWRLAPIView;
import org.swrlapi.ui.view.queries.SQWRLQuerySelector;
import org.swrlapi.ui.view.queries.SQWRLResultView;

public class SQWRLQueryControlView
extends JPanel
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private static final int VIEW_PREFERRED_WIDTH = 900;
    private static final int VIEW_PREFERRED_HEIGHT = 300;
    private static final int TOOLTIP_PREFERRED_WIDTH = 160;
    private static final int TOOLTIP_PREFERRED_HEIGHT = 30;
    private static final int CONSOLE_ROWS = 10;
    private static final int CONSOLE_COLUMNS = 80;
    private static final int MAXIMUM_OPEN_RESULT_VIEWS = 12;
    private final @NonNull SQWRLQueryEngineModel queryEngineModel;
    private final @NonNull SQWRLQuerySelector sqwrlQuerySelector;
    private final @NonNull JTextArea console;
    private final @NonNull JScrollPane consoleScrollPane;
    private final @NonNull Map<@NonNull String, SQWRLResultView> sqwrlResultViews = new HashMap<String, SQWRLResultView>();

    public SQWRLQueryControlView(@NonNull SQWRLQueryEngineModel queryEngineModel, @NonNull SQWRLQuerySelector sqwrlQuerySelector) {
        this.queryEngineModel = queryEngineModel;
        this.sqwrlQuerySelector = sqwrlQuerySelector;
        this.console = new JTextArea(10, 80);
        this.consoleScrollPane = new JScrollPane(this.console);
    }

    @Override
    public void initialize() {
        this.setLayout(new BorderLayout());
        this.console.setLineWrap(true);
        this.console.setBackground(Color.WHITE);
        this.console.setEditable(false);
        this.consoleScrollPane.setPreferredSize(new Dimension(900, 300));
        this.add("Center", this.consoleScrollPane);
        JPanel controlPanel = new JPanel(new FlowLayout());
        JButton runSQWRLQueryButton = this.createButton("Run", "Run a SQWRL query", new RunSQWRLQueryActionListener(this.console, this));
        controlPanel.add(runSQWRLQueryButton);
        this.add("South", controlPanel);
        this.console.append("Select a SQWRL query from the list above and press the 'Run' button.\n");
        this.console.append("If the selected query generates a result, the result will appear in a new sub tab.\n\n");
        this.console.append("The SWRLAPI supports an OWL profile called OWL 2 RL and uses an OWL 2 RL-based reasoner to perform querying.\n");
        this.console.append("See the 'OWL 2 RL' subtab for more information on this reasoner.\n\n");
        this.console.append("Executing queries in this tab does not modify the ontology.\n\n");
        this.console.append("Using " + this.queryEngineModel.getSQWRLQueryEngine().getRuleEngineName() + " for query execution.\n\n");
    }

    @Override
    public void update() {
        this.validate();
    }

    public void appendToConsole(final @NonNull String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQWRLQueryControlView.this.console.append(text);
                SQWRLQueryControlView.this.console.setCaretPosition(SQWRLQueryControlView.this.console.getDocument().getLength());
            }
        });
    }

    public void removeSQWRLResultView(@NonNull String queryName) {
        if (this.sqwrlResultViews.containsKey(queryName)) {
            SQWRLResultView sqwrlResultView = this.sqwrlResultViews.get(queryName);
            this.sqwrlResultViews.remove(queryName);
            this.getParent().remove(sqwrlResultView);
            ((JTabbedPane)this.getParent()).setSelectedIndex(0);
        }
    }

    public void removeAllSQWRLResultViews() {
        for (SQWRLResultView sqwrlResultView : this.sqwrlResultViews.values()) {
            this.getParent().remove(sqwrlResultView);
        }
        this.sqwrlResultViews.clear();
    }

    private @NonNull JButton createButton(@NonNull String text, @NonNull String toolTipText, @NonNull ActionListener listener) {
        JButton button = new JButton(text);
        button.setToolTipText(toolTipText);
        button.setPreferredSize(new Dimension(160, 30));
        button.addActionListener(listener);
        return button;
    }

    private @NonNull SQWRLQueryEngine getSQWRLQueryEngine() {
        return this.queryEngineModel.getSQWRLQueryEngine();
    }

    private @NonNull String buildChainedErrorMessage(Throwable t) {
        String message = t.getMessage() != null ? t.getMessage() : "";
        Throwable currentThrowable = t;
        while (currentThrowable != null) {
            Throwable cause = currentThrowable.getCause();
            if (cause != null && cause.getMessage() != null) {
                message = message + ": " + cause.getMessage();
            }
            currentThrowable = cause;
        }
        return message;
    }

    private class RunSQWRLQueryActionListener
    extends ListenerBase
    implements ActionListener {
        public RunSQWRLQueryActionListener(@NonNull JTextArea console, SQWRLQueryControlView sqwrlQueryControlView) {
            super(console, sqwrlQueryControlView);
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent event) {
            this.runSQWRLQuery();
        }

        private void runSQWRLQuery() {
            Optional<@NonNull Object> queryName = Optional.empty();
            if (SQWRLQueryControlView.this.sqwrlResultViews.size() == 12) {
                SQWRLQueryControlView.this.appendToConsole("A maximum of 12 result tabs may be open at once. ");
                SQWRLQueryControlView.this.appendToConsole("Please close an existing tab to display results for the selected query.\n");
            } else {
                try {
                    SQWRLQuerySelector querySelector = SQWRLQueryControlView.this.sqwrlQuerySelector;
                    if (querySelector == null) {
                        SQWRLQueryControlView.this.appendToConsole("Configuration error: no query selector supplied. No queries can be executed!\n");
                    } else {
                        queryName = SQWRLQueryControlView.this.sqwrlQuerySelector.getSelectedQueryName();
                        if (queryName.isPresent()) {
                            long startTime = System.currentTimeMillis();
                            SQWRLResult sqwrlResult = SQWRLQueryControlView.this.getSQWRLQueryEngine().runSQWRLQuery((String)queryName.get());
                            if (sqwrlResult == null || sqwrlResult.getNumberOfRows() == 0) {
                                this.indicateEmptySQWRLResult((String)queryName.get());
                            } else {
                                this.displaySQWRLResult((String)queryName.get(), sqwrlResult, startTime);
                            }
                        } else {
                            SQWRLQueryControlView.this.appendToConsole("No enabled SQWRL query selected.\n");
                        }
                    }
                }
                catch (SQWRLInvalidQueryNameException e) {
                    if (queryName.isPresent()) {
                        SQWRLQueryControlView.this.appendToConsole((String)queryName.get() + " is not a valid SQWRL query or is not enabled.\n");
                    } else {
                        SQWRLQueryControlView.this.appendToConsole("No enabled SQWRL query selected.\n");
                    }
                }
                catch (RuntimeException | SQWRLException e) {
                    if (queryName.isPresent()) {
                        SQWRLQueryControlView.this.appendToConsole("Exception running SQWRL query " + (String)queryName.get() + ": " + SQWRLQueryControlView.this.buildChainedErrorMessage(e) + "\n");
                    }
                    SQWRLQueryControlView.this.appendToConsole("Exception running SQWRL queries: " + SQWRLQueryControlView.this.buildChainedErrorMessage(e) + "\n");
                }
            }
        }

        private void indicateEmptySQWRLResult(@NonNull String queryName) {
            SQWRLQueryControlView.this.appendToConsole("SQWRL query " + queryName + " did not generate any result.\n");
            if (SQWRLQueryControlView.this.sqwrlResultViews.containsKey(queryName)) {
                SQWRLResultView queryResultsView = (SQWRLResultView)SQWRLQueryControlView.this.sqwrlResultViews.get(queryName);
                SQWRLQueryControlView.this.sqwrlResultViews.remove(queryName);
                SQWRLQueryControlView.this.getParent().remove(queryResultsView);
            }
        }

        private void displaySQWRLResult(@NonNull String queryName, @NonNull SQWRLResult sqwrlResult, long startTime) throws SQWRLException {
            SQWRLResultView sqwrlResultView;
            SQWRLQueryControlView.this.appendToConsole("See the " + queryName + " tab to review results of the SQWRL query.\n");
            SQWRLQueryControlView.this.appendToConsole("The query took " + (System.currentTimeMillis() - startTime) + " milliseconds. ");
            if (sqwrlResult.getNumberOfRows() == 1) {
                SQWRLQueryControlView.this.appendToConsole("1 row was returned.\n");
            } else {
                SQWRLQueryControlView.this.appendToConsole("" + sqwrlResult.getNumberOfRows() + " rows were returned.\n");
            }
            if (SQWRLQueryControlView.this.sqwrlResultViews.containsKey(queryName)) {
                sqwrlResultView = (SQWRLResultView)SQWRLQueryControlView.this.sqwrlResultViews.get(queryName);
            } else {
                sqwrlResultView = new SQWRLResultView(SQWRLQueryControlView.this.queryEngineModel, queryName, sqwrlResult, this.sqwrlQueryControlView);
                sqwrlResultView.initialize();
                SQWRLQueryControlView.this.sqwrlResultViews.put(queryName, sqwrlResultView);
                ((JTabbedPane)SQWRLQueryControlView.this.getParent()).addTab(queryName, null, sqwrlResultView, "SQWRL Result for query '" + queryName + "'");
            }
            sqwrlResultView.validate();
            this.sqwrlQueryControlView.getParent().validate();
            this.console.validate();
        }
    }

    private class ListenerBase {
        protected final @NonNull SQWRLQueryControlView sqwrlQueryControlView;
        protected final @NonNull JTextArea console;

        public ListenerBase(@NonNull JTextArea console, SQWRLQueryControlView sqwrlQueryControlView) {
            this.console = console;
            this.sqwrlQueryControlView = sqwrlQueryControlView;
        }
    }
}

