/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.queries;

import javax.swing.JTabbedPane;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.ui.model.SQWRLQueryEngineModel;
import org.swrlapi.ui.view.SWRLAPIView;
import org.swrlapi.ui.view.owl2rl.OWL2RLRuleTablesView;
import org.swrlapi.ui.view.queries.SQWRLQueryControlView;
import org.swrlapi.ui.view.queries.SQWRLQuerySelector;

public class SQWRLQueryExecutionView
extends JTabbedPane
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private final @NonNull SQWRLQueryEngineModel queryEngineModel;
    private final @NonNull SQWRLQuerySelector querySelector;

    public SQWRLQueryExecutionView(@NonNull SQWRLQueryEngineModel queryEngineModel, @NonNull SQWRLQuerySelector querySelector) throws SWRLAPIException {
        this.queryEngineModel = queryEngineModel;
        this.querySelector = querySelector;
    }

    @Override
    public void initialize() {
        SQWRLQueryControlView queryControlView = new SQWRLQueryControlView(this.queryEngineModel, this.querySelector);
        OWL2RLRuleTablesView ruleTablesView = new OWL2RLRuleTablesView(this.queryEngineModel.getOWL2RLModel());
        queryControlView.initialize();
        ruleTablesView.initialize();
        this.addTab("SQWRL Queries", null, queryControlView, "SQWRL Queries Tab");
        this.addTab("OWL 2 RL", null, ruleTablesView, "OWL 2 RL Tab");
    }

    @Override
    public void update() {
        this.validate();
    }
}

