/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.queries;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swrlapi.sqwrl.SQWRLQueryEngine;
import org.swrlapi.sqwrl.SQWRLResult;
import org.swrlapi.sqwrl.exceptions.SQWRLException;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidQueryNameException;
import org.swrlapi.sqwrl.values.SQWRLClassExpressionResultValue;
import org.swrlapi.sqwrl.values.SQWRLDataPropertyExpressionResultValue;
import org.swrlapi.sqwrl.values.SQWRLEntityResultValue;
import org.swrlapi.sqwrl.values.SQWRLLiteralResultValue;
import org.swrlapi.sqwrl.values.SQWRLObjectPropertyExpressionResultValue;
import org.swrlapi.sqwrl.values.SQWRLResultValue;
import org.swrlapi.ui.model.SQWRLQueryEngineModel;
import org.swrlapi.ui.view.SWRLAPIView;
import org.swrlapi.ui.view.queries.SQWRLQueryControlView;

public class SQWRLResultView
extends JPanel
implements SWRLAPIView {
    private static final Logger log = LoggerFactory.getLogger(SQWRLResultView.class);
    private static final long serialVersionUID = 1L;
    private final @NonNull SQWRLQueryEngineModel queryEngineModel;
    private final @NonNull SQWRLQueryControlView sqwrlQueryControlView;
    private final @NonNull SQWRLQueryResultTableModel sqwrlQueryResultTableModel;
    private final @NonNull String queryName;
    private @NonNull SQWRLResult sqwrlResult;
    private static @Nullable File currentDirectory = null;

    public SQWRLResultView(@NonNull SQWRLQueryEngineModel queryEngineModel, @NonNull String queryName, @NonNull SQWRLResult sqwrlResult, @NonNull SQWRLQueryControlView sqwrlQueryControlView) {
        this.queryEngineModel = queryEngineModel;
        this.sqwrlQueryControlView = sqwrlQueryControlView;
        this.sqwrlQueryResultTableModel = new SQWRLQueryResultTableModel();
        this.queryName = queryName;
        this.sqwrlResult = sqwrlResult;
    }

    @Override
    public void initialize() {
        this.sqwrlQueryControlView.initialize();
        this.setLayout(new BorderLayout());
        JTable sqwrlQueryResultTable = new JTable(this.sqwrlQueryResultTableModel);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton saveSQWRLResultButton = this.createButton("Save as CSV...", "Save the result as a CSV file...", new SaveSQWRLResultActionListener(this));
        buttonsPanel.add(saveSQWRLResultButton);
        JButton runSQWRLQueryButton = this.createButton("Rerun", "Rerun this SQWRL query", new RunSQWRLQueryActionListener());
        buttonsPanel.add(runSQWRLQueryButton);
        JButton closeSQWRLResultButton = this.createButton("Close", "Close the tab for this query", new CloseSQWRLResultActionListener());
        buttonsPanel.add(closeSQWRLResultButton);
        JScrollPane scrollPane = new JScrollPane(sqwrlQueryResultTable);
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(sqwrlQueryResultTable.getBackground());
        this.add("Center", scrollPane);
        this.add("South", buttonsPanel);
    }

    @Override
    public void validate() {
        this.sqwrlQueryResultTableModel.fireTableStructureChanged();
        super.validate();
    }

    @Override
    public void update() {
        this.validate();
    }

    private @NonNull SQWRLQueryEngine getSQWRLQueryEngine() {
        return this.queryEngineModel.getSQWRLQueryEngine();
    }

    private @NonNull JButton createButton(@NonNull String text, @NonNull String toolTipText, @NonNull ActionListener listener) {
        JButton button = new JButton(text);
        button.setToolTipText(toolTipText);
        button.setPreferredSize(new Dimension(160, 30));
        button.addActionListener(listener);
        return button;
    }

    private class SQWRLQueryResultTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private SQWRLQueryResultTableModel() {
        }

        @Override
        public int getRowCount() {
            try {
                return SQWRLResultView.this.sqwrlResult == null ? 0 : SQWRLResultView.this.sqwrlResult.getNumberOfRows();
            }
            catch (SQWRLException e) {
                return 0;
            }
        }

        @Override
        public int getColumnCount() {
            try {
                return SQWRLResultView.this.sqwrlResult == null ? 0 : SQWRLResultView.this.sqwrlResult.getNumberOfColumns();
            }
            catch (SQWRLException e) {
                return 0;
            }
        }

        @Override
        public @NonNull String getColumnName(int columnIndex) {
            try {
                return SQWRLResultView.this.sqwrlResult == null ? "" : SQWRLResultView.this.sqwrlResult.getColumnName(columnIndex);
            }
            catch (SQWRLException e) {
                return "<INVALID>";
            }
        }

        @Override
        public @NonNull Object getValueAt(int row, int column) {
            try {
                SQWRLResultValue sqwrlResultValue;
                SQWRLResultValue sQWRLResultValue = sqwrlResultValue = SQWRLResultView.this.sqwrlResult == null ? null : SQWRLResultView.this.sqwrlResult.getValue(column, row);
                if (sqwrlResultValue != null && sqwrlResultValue.isEntity()) {
                    SQWRLEntityResultValue sqwrlEntityResultValue = sqwrlResultValue.asEntityResult();
                    return sqwrlEntityResultValue.getShortName();
                }
                if (sqwrlResultValue != null && sqwrlResultValue.isClassExpression()) {
                    SQWRLClassExpressionResultValue sqwrlClassExpressionResultValue = sqwrlResultValue.asClassExpressionResult();
                    return sqwrlClassExpressionResultValue.getRendering();
                }
                if (sqwrlResultValue != null && sqwrlResultValue.isObjectPropertyExpression()) {
                    SQWRLObjectPropertyExpressionResultValue sqwrlObjectPropertyExpressionResultValue = sqwrlResultValue.asObjectPropertyExpressionResult();
                    return sqwrlObjectPropertyExpressionResultValue.getRendering();
                }
                if (sqwrlResultValue != null && sqwrlResultValue.isDataPropertyExpression()) {
                    SQWRLDataPropertyExpressionResultValue sqwrlDataPropertyExpressionResultValue = sqwrlResultValue.asDataPropertyExpressionResult();
                    return sqwrlDataPropertyExpressionResultValue.getRendering();
                }
                if (sqwrlResultValue != null && sqwrlResultValue.isLiteral()) {
                    SQWRLLiteralResultValue sqwrLiteralResultValue = sqwrlResultValue.asLiteralResult();
                    if (sqwrLiteralResultValue.isInteger() || sqwrLiteralResultValue.isDecimal() || sqwrLiteralResultValue.isString() || sqwrLiteralResultValue.isBoolean()) {
                        return sqwrLiteralResultValue.getValue();
                    }
                    return "\"" + sqwrLiteralResultValue.getValue() + "\"^^" + sqwrLiteralResultValue.getDatatypePrefixedName();
                }
                return "<INVALID>";
            }
            catch (SQWRLException e) {
                return "<INVALID>";
            }
        }
    }

    private class SaveSQWRLResultActionListener
    implements ActionListener {
        private final @NonNull Component component;
        private final @NonNull JFileChooser chooser;

        public SaveSQWRLResultActionListener(Component component) {
            this.component = component;
            this.chooser = new JFileChooser();
            this.chooser.setCurrentDirectory(currentDirectory);
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent event) {
            this.saveSQWRLResultAsCSV();
        }

        private void saveSQWRLResultAsCSV() {
            try {
                int returnValue = this.chooser.showOpenDialog(SQWRLResultView.this.sqwrlQueryControlView);
                if (returnValue == 0) {
                    File selectedFile = this.chooser.getSelectedFile();
                    currentDirectory = this.chooser.getCurrentDirectory();
                    FileOutputStream fileOutputStream = new FileOutputStream(selectedFile);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
                    SQWRLResultView.this.sqwrlResult = SQWRLResultView.this.getSQWRLQueryEngine().getSQWRLResult(SQWRLResultView.this.queryName);
                    if (SQWRLResultView.this.sqwrlResult != null) {
                        int i;
                        int numberOfColumns = SQWRLResultView.this.sqwrlResult.getNumberOfColumns();
                        for (i = 0; i < numberOfColumns; ++i) {
                            if (i != 0) {
                                writer.write(", ");
                            }
                            writer.write(SQWRLResultView.this.sqwrlResult.getColumnName(i));
                        }
                        writer.write("\n");
                        while (SQWRLResultView.this.sqwrlResult.next()) {
                            for (i = 0; i < numberOfColumns; ++i) {
                                SQWRLResultValue value = SQWRLResultView.this.sqwrlResult.getValue(i);
                                if (i != 0) {
                                    writer.write(", ");
                                }
                                if (value instanceof SQWRLLiteralResultValue && ((SQWRLLiteralResultValue)value).isQuotableType()) {
                                    writer.write("\"" + value + "\"");
                                    continue;
                                }
                                writer.write("" + value);
                            }
                            writer.write("\n");
                        }
                        SQWRLResultView.this.sqwrlResult.reset();
                        writer.close();
                        SQWRLResultView.this.sqwrlQueryControlView.appendToConsole("Successfully saved results of query " + SQWRLResultView.this.queryName + " to CSV file " + selectedFile.getPath() + ".\n");
                    }
                }
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(this.component, "Error saving file: " + (e.getMessage() != null ? e.getMessage() : ""), "Error saving file", 0);
            }
        }
    }

    private class CloseSQWRLResultActionListener
    implements ActionListener {
        private CloseSQWRLResultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SQWRLResultView.this.sqwrlQueryControlView.removeSQWRLResultView(SQWRLResultView.this.queryName);
            SQWRLResultView.this.sqwrlQueryControlView.appendToConsole("'" + SQWRLResultView.this.queryName + "' tab closed.\n");
        }
    }

    private class RunSQWRLQueryActionListener
    implements ActionListener {
        private RunSQWRLQueryActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                SQWRLResultView.this.sqwrlResult = SQWRLResultView.this.getSQWRLQueryEngine().runSQWRLQuery(SQWRLResultView.this.queryName);
                if (SQWRLResultView.this.sqwrlResult == null || SQWRLResultView.this.sqwrlResult.getNumberOfRows() == 0) {
                    SQWRLResultView.this.sqwrlQueryControlView.appendToConsole("No result returned for SQWRL query '" + SQWRLResultView.this.queryName + "' - closing tab.\n");
                    SQWRLResultView.this.sqwrlQueryControlView.removeSQWRLResultView(SQWRLResultView.this.queryName);
                } else {
                    SQWRLResultView.this.validate();
                }
            }
            catch (SQWRLInvalidQueryNameException e) {
                SQWRLResultView.this.sqwrlQueryControlView.appendToConsole("Invalid query name " + SQWRLResultView.this.queryName + ".\n");
            }
            catch (SQWRLException e) {
                SQWRLResultView.this.sqwrlQueryControlView.appendToConsole("Exception running SQWRL query '" + SQWRLResultView.this.queryName + "': " + (e != null ? e.getMessage() : "") + "\n");
            }
        }
    }
}

