/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.rules;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLObject;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.ui.model.SWRLRuleEngineModel;
import org.swrlapi.ui.view.SWRLAPIView;

public class AssertedOWLAxiomsView
extends JPanel
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private final @NonNull SWRLRuleEngineModel ruleEngineModel;
    private final @NonNull AssertedAxiomsTableModel assertedAxiomsTableModel;
    private final @NonNull JTable table;

    public AssertedOWLAxiomsView(@NonNull SWRLRuleEngineModel ruleEngineModel) {
        this.ruleEngineModel = ruleEngineModel;
        this.assertedAxiomsTableModel = new AssertedAxiomsTableModel();
        this.table = new JTable(this.assertedAxiomsTableModel);
    }

    @Override
    public void initialize() {
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.table);
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(this.table.getBackground());
        this.add("Center", scrollPane);
    }

    @Override
    public void validate() {
        this.assertedAxiomsTableModel.fireTableDataChanged();
        super.validate();
    }

    @Override
    public void update() {
        this.validate();
    }

    private @NonNull SWRLRuleEngine getSWRLRuleEngine() {
        return this.ruleEngineModel.getSWRLRuleEngine();
    }

    private class AssertedAxiomsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private AssertedAxiomsTableModel() {
        }

        @Override
        public int getRowCount() {
            return AssertedOWLAxiomsView.this.getSWRLRuleEngine().getNumberOfAssertedOWLAxioms();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < 0 || row >= this.getRowCount()) {
                return "<OUT OF BOUNDS>";
            }
            OWLObject owlObject = (OWLObject)AssertedOWLAxiomsView.this.getSWRLRuleEngine().getAssertedOWLAxioms().toArray()[row];
            return AssertedOWLAxiomsView.this.ruleEngineModel.getSWRLRuleEngine().getSWRLAPIOWLOntology().getIRIResolver().render(owlObject);
        }
    }
}

