/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.rules;

import java.awt.BorderLayout;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.core.SWRLAPIRule;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.core.SWRLRuleRenderer;
import org.swrlapi.ui.model.SWRLRuleEngineModel;
import org.swrlapi.ui.view.SWRLAPIView;

public class ImportedSWRLRulesView
extends JPanel
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private final @NonNull SWRLRuleEngineModel swrlRuleEngineModel;
    private final @NonNull SWRLRulesTableModel swrlRulesTableModel;
    private final @NonNull JTable swrlRulesTable;

    public ImportedSWRLRulesView(@NonNull SWRLRuleEngineModel ruleEngineModel) {
        this.swrlRuleEngineModel = ruleEngineModel;
        this.swrlRulesTableModel = new SWRLRulesTableModel();
        this.swrlRulesTable = new JTable(this.swrlRulesTableModel);
    }

    @Override
    public void initialize() {
        JScrollPane scrollPane = new JScrollPane(this.swrlRulesTable);
        JViewport viewPort = scrollPane.getViewport();
        this.setLayout(new BorderLayout());
        viewPort.setBackground(this.swrlRulesTable.getBackground());
        this.add("Center", scrollPane);
    }

    @Override
    public void validate() {
        this.swrlRulesTableModel.fireTableDataChanged();
        super.validate();
    }

    @Override
    public void update() {
        this.validate();
    }

    private @NonNull SWRLRuleEngine getSWRLRuleEngine() {
        return this.swrlRuleEngineModel.getSWRLRuleEngine();
    }

    private @NonNull SWRLRuleRenderer createSWRLRuleRenderer() {
        return this.swrlRuleEngineModel.createSWRLRuleRenderer();
    }

    private class SWRLRulesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private SWRLRulesTableModel() {
        }

        @Override
        public int getRowCount() {
            return ImportedSWRLRulesView.this.getSWRLRuleEngine().getNumberOfImportedSWRLRules();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public @NonNull Object getValueAt(int row, int column) {
            if (row < 0 || row >= this.getRowCount()) {
                return "<OUT OF BOUNDS>";
            }
            Set<@NonNull SWRLAPIRule> swrlRules = ImportedSWRLRulesView.this.getSWRLRuleEngine().getSWRLRules();
            SWRLAPIRule[] swrlRuleArray = swrlRules.toArray(new SWRLAPIRule[swrlRules.size()]);
            SWRLAPIRule swrlRule = swrlRuleArray[row];
            return swrlRule.accept(ImportedSWRLRulesView.this.createSWRLRuleRenderer());
        }
    }
}

