/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.rules;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLObject;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.ui.model.SWRLRuleEngineModel;
import org.swrlapi.ui.view.SWRLAPIView;

public class InferredOWLAxiomsView
extends JPanel
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private final @NonNull SWRLRuleEngineModel ruleEngineModel;
    private final @NonNull InferredAxiomsTableModel inferredAxiomsTableModel;

    public InferredOWLAxiomsView(@NonNull SWRLRuleEngineModel ruleEngineModel) {
        this.ruleEngineModel = ruleEngineModel;
        this.inferredAxiomsTableModel = new InferredAxiomsTableModel();
    }

    @Override
    public void initialize() {
        JTable inferredAxiomsTable = new JTable(this.inferredAxiomsTableModel);
        JScrollPane scrollPane = new JScrollPane(inferredAxiomsTable);
        JViewport viewPort = scrollPane.getViewport();
        this.setLayout(new BorderLayout());
        viewPort.setBackground(inferredAxiomsTable.getBackground());
        this.add("Center", scrollPane);
    }

    @Override
    public void validate() {
        this.inferredAxiomsTableModel.fireTableDataChanged();
        super.validate();
    }

    @Override
    public void update() {
        this.validate();
    }

    private @NonNull SWRLRuleEngine getSWRLRuleEngine() {
        return this.ruleEngineModel.getSWRLRuleEngine();
    }

    private class InferredAxiomsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private InferredAxiomsTableModel() {
        }

        @Override
        public int getRowCount() {
            return InferredOWLAxiomsView.this.getSWRLRuleEngine().getNumberOfInferredOWLAxioms();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < 0 || row >= this.getRowCount()) {
                return "<OUT OF BOUNDS>";
            }
            OWLObject owlObject = (OWLObject)InferredOWLAxiomsView.this.getSWRLRuleEngine().getInferredOWLAxioms().toArray()[row];
            return InferredOWLAxiomsView.this.ruleEngineModel.getSWRLRuleEngine().getSWRLAPIOWLOntology().getIRIResolver().render(owlObject);
        }
    }
}

