/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.rules;

import javax.swing.JTabbedPane;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.ui.model.SWRLRuleEngineModel;
import org.swrlapi.ui.view.SWRLAPIView;
import org.swrlapi.ui.view.owl2rl.OWL2RLRuleTablesView;
import org.swrlapi.ui.view.rules.AssertedOWLAxiomsView;
import org.swrlapi.ui.view.rules.ImportedSWRLRulesView;
import org.swrlapi.ui.view.rules.InferredOWLAxiomsView;
import org.swrlapi.ui.view.rules.SWRLRulesControlView;

public class SWRLRuleExecutionView
extends JTabbedPane
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private final @NonNull SWRLRuleEngineModel swrlRuleEngineModel;

    public SWRLRuleExecutionView(@NonNull SWRLRuleEngineModel swrlRuleEngineModel) throws SWRLAPIException {
        this.swrlRuleEngineModel = swrlRuleEngineModel;
    }

    @Override
    public void initialize() {
        OWL2RLRuleTablesView ruleTablesView = new OWL2RLRuleTablesView(this.swrlRuleEngineModel.getOWL2RLModel());
        SWRLRulesControlView swrlRulesControlView = new SWRLRulesControlView(this.swrlRuleEngineModel);
        ImportedSWRLRulesView importedSWRLRulesView = new ImportedSWRLRulesView(this.swrlRuleEngineModel);
        AssertedOWLAxiomsView assertedOWLAxiomsView = new AssertedOWLAxiomsView(this.swrlRuleEngineModel);
        InferredOWLAxiomsView inferredOWLAxiomsView = new InferredOWLAxiomsView(this.swrlRuleEngineModel);
        ruleTablesView.initialize();
        swrlRulesControlView.initialize();
        importedSWRLRulesView.initialize();
        assertedOWLAxiomsView.initialize();
        inferredOWLAxiomsView.initialize();
        this.addTab("Control", null, swrlRulesControlView, "Control Tab");
        this.addTab("Rules", null, importedSWRLRulesView, "Rules Tab");
        this.addTab("Asserted Axioms", null, assertedOWLAxiomsView, "Asserted OWL Axioms Tab");
        this.addTab("Inferred Axioms", null, inferredOWLAxiomsView, "Inferred OWL Axioms Tab");
        this.addTab("OWL 2 RL", null, ruleTablesView, "OWL 2 RL Tab");
    }

    @Override
    public void update() {
        this.validate();
    }
}

