/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.ui.view.rules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.exceptions.SWRLRuleEngineException;
import org.swrlapi.ui.model.SWRLRuleEngineModel;
import org.swrlapi.ui.view.SWRLAPIView;

public class SWRLRulesControlView
extends JPanel
implements SWRLAPIView {
    private static final long serialVersionUID = 1L;
    private static final int VIEW_PREFERRED_WIDTH = 900;
    private static final int VIEW_PREFERRED_HEIGHT = 300;
    private static final int BUTTON_PREFERRED_WIDTH = 160;
    private static final int BUTTON_PREFERRED_HEIGHT = 30;
    private static final int CONSOLE_ROWS = 10;
    private static final int CONSOLE_COLUMNS = 80;
    private final @NonNull SWRLRuleEngineModel swrlRuleEngineModel;

    public SWRLRulesControlView(@NonNull SWRLRuleEngineModel swrlRuleEngineModel) {
        this.swrlRuleEngineModel = swrlRuleEngineModel;
    }

    @Override
    public void initialize() {
        String ruleEngineName = this.swrlRuleEngineModel.getSWRLRuleEngine().getRuleEngineName();
        String ruleEngineVersion = this.swrlRuleEngineModel.getSWRLRuleEngine().getRuleEngineVersion();
        JTextArea console = this.createConsole();
        JScrollPane scrollPane = new JScrollPane(console);
        scrollPane.setPreferredSize(new Dimension(900, 300));
        this.setLayout(new BorderLayout());
        this.add("Center", scrollPane);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton button = this.createButton("OWL+SWRL->" + ruleEngineName, "Translate SWRL rules and relevant OWL knowledge to rule engine", new ImportActionListener(this.swrlRuleEngineModel, console, this));
        buttonsPanel.add(button);
        button = this.createButton("Run " + ruleEngineName, "Run the rule engine", new RunActionListener(this.swrlRuleEngineModel, console, this));
        buttonsPanel.add(button);
        button = this.createButton(ruleEngineName + "->OWL", "Translate asserted rule engine knowledge to OWL knowledge", new ExportActionListener(this.swrlRuleEngineModel, console, this));
        buttonsPanel.add(button);
        this.add("South", buttonsPanel);
        console.append("Using the " + ruleEngineName + " rule engine.\n\n");
        console.append("Press the 'OWL+SWRL->" + ruleEngineName + "' button to transfer SWRL rules and relevant OWL knowledge to the rule engine.\n");
        console.append("Press the 'Run " + ruleEngineName + "' button to run the rule engine.\n");
        console.append("Press the '" + ruleEngineName + "->OWL' button to transfer the inferred rule engine knowledge to OWL knowledge.\n\n");
        console.append("The SWRLAPI supports an OWL profile called OWL 2 RL and uses an OWL 2 RL-based reasoner to perform reasoning.\n");
        console.append("See the 'OWL 2 RL' sub-tab for more information on this reasoner.");
    }

    @Override
    public void update() {
        this.validate();
    }

    private @NonNull JButton createButton(@NonNull String text, @NonNull String toolTipText, @NonNull ActionListener listener) {
        JButton button = new JButton(text);
        button.setToolTipText(toolTipText);
        button.setPreferredSize(new Dimension(160, 30));
        button.addActionListener(listener);
        return button;
    }

    private @NonNull JTextArea createConsole() {
        JTextArea textArea = new JTextArea(10, 80);
        textArea.setLineWrap(true);
        textArea.setBackground(Color.WHITE);
        textArea.setEditable(false);
        return textArea;
    }

    private @NonNull SWRLRuleEngine getSWRLRuleEngine() {
        return this.swrlRuleEngineModel.getSWRLRuleEngine();
    }

    private @NonNull String buildChainedErrorMessage(Throwable t) {
        String message = t.getMessage() != null ? t.getMessage() : "";
        Throwable currentThrowable = t;
        while (currentThrowable != null) {
            Throwable cause = currentThrowable.getCause();
            if (cause != null && cause.getMessage() != null) {
                message = message + ": " + cause.getMessage();
            }
            currentThrowable = cause;
        }
        return message;
    }

    private class ExportActionListener
    extends ListenerBase
    implements ActionListener {
        public ExportActionListener(@NonNull SWRLRuleEngineModel ruleEngineModel, @NonNull JTextArea textArea, SWRLRulesControlView controlPanel) {
            super(ruleEngineModel, textArea, controlPanel);
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent event) {
            this.displayExportResults();
        }

        private void displayExportResults() {
            try {
                long startTime = System.currentTimeMillis();
                this.getSWRLRuleEngine().exportInferredOWLAxioms();
                this.appendToConsole("Successfully transferred inferred axioms to OWL model.\n");
                this.appendToConsole("The process took " + (System.currentTimeMillis() - startTime) + " millisecond(s).\n");
            }
            catch (SWRLRuleEngineException e) {
                this.appendToConsole("Exception exporting knowledge to OWL: " + e.toString() + "\n");
            }
            this.controlPanel.getParent().validate();
        }
    }

    private class RunActionListener
    extends ListenerBase
    implements ActionListener {
        public RunActionListener(@NonNull SWRLRuleEngineModel ruleEngineModel, @NonNull JTextArea textArea, SWRLRulesControlView controlPanel) {
            super(ruleEngineModel, textArea, controlPanel);
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent event) {
            this.displayRunResults();
        }

        private void displayRunResults() {
            try {
                long startTime = System.currentTimeMillis();
                this.getSWRLRuleEngine().run();
                this.appendToConsole("Successful execution of rule engine.\n");
                this.appendToConsole("Number of inferred axioms: " + this.getSWRLRuleEngine().getNumberOfInferredOWLAxioms() + "\n");
                if (this.getSWRLRuleEngine().getNumberOfInjectedOWLAxioms() != 0) {
                    this.appendToConsole("Number of axioms injected by built-ins: " + this.getSWRLRuleEngine().getNumberOfInjectedOWLAxioms() + "\n");
                }
                this.appendToConsole("The process took " + (System.currentTimeMillis() - startTime) + " millisecond(s).\n");
                this.appendToConsole("Look at the 'Inferred Axioms' tab to see the inferred axioms.\n");
                this.appendToConsole("Press the '" + SWRLRulesControlView.this.getSWRLRuleEngine().getRuleEngineName() + "->OWL' button to translate the inferred axioms to OWL knowledge.\n");
            }
            catch (Exception e) {
                String errorMessage = SWRLRulesControlView.this.buildChainedErrorMessage(e);
                this.appendToConsole("Exception running rule engine: " + errorMessage + "\n");
            }
            this.controlPanel.getParent().validate();
        }
    }

    private class ImportActionListener
    extends ListenerBase
    implements ActionListener {
        public ImportActionListener(@NonNull SWRLRuleEngineModel ruleEngineModel, @NonNull JTextArea console, SWRLRulesControlView controlPanel) {
            super(ruleEngineModel, console, controlPanel);
        }

        @Override
        public void actionPerformed(@NonNull ActionEvent event) {
            try {
                long startTime = System.currentTimeMillis();
                this.getSWRLRuleEngine().importAssertedOWLAxioms();
                this.clearConsole();
                this.appendToConsole("OWL axioms successfully transferred to rule engine.\n");
                this.appendToConsole("Number of SWRL rules exported to rule engine: " + this.getSWRLRuleEngine().getNumberOfImportedSWRLRules() + "\n");
                this.appendToConsole("Number of OWL class declarations exported to rule engine: " + this.getSWRLRuleEngine().getNumberOfAssertedOWLClassDeclarationAxioms() + "\n");
                this.appendToConsole("Number of OWL individual declarations exported to rule engine: " + this.getSWRLRuleEngine().getNumberOfAssertedOWLIndividualDeclarationsAxioms() + "\n");
                this.appendToConsole("Number of OWL object property declarations exported to rule engine: " + this.getSWRLRuleEngine().getNumberOfAssertedOWLObjectPropertyDeclarationAxioms() + "\n");
                this.appendToConsole("Number of OWL data property declarations exported to rule engine: " + this.getSWRLRuleEngine().getNumberOfAssertedOWLDataPropertyDeclarationAxioms() + "\n");
                this.appendToConsole("Total number of OWL axioms exported to rule engine: " + this.getSWRLRuleEngine().getNumberOfAssertedOWLAxioms() + "\n");
                this.appendToConsole("The transfer took " + (System.currentTimeMillis() - startTime) + " millisecond(s).\n");
                this.appendToConsole("Press the 'Run " + SWRLRulesControlView.this.getSWRLRuleEngine().getRuleEngineName() + "' button to run the rule engine.\n");
            }
            catch (SWRLRuleEngineException e) {
                this.appendToConsole("Exception importing SWRL rules and OWL knowledge: " + e.toString() + "\n");
            }
            this.controlPanel.getParent().validate();
        }
    }

    private class ListenerBase {
        protected final @NonNull SWRLRuleEngineModel ruleEngineModel;
        protected final @NonNull JTextArea console;
        protected final @NonNull SWRLRulesControlView controlPanel;

        public ListenerBase(@NonNull SWRLRuleEngineModel ruleEngineModel, @NonNull JTextArea console, SWRLRulesControlView controlPanel) {
            this.ruleEngineModel = ruleEngineModel;
            this.console = console;
            this.controlPanel = controlPanel;
        }

        protected SWRLRuleEngine getSWRLRuleEngine() {
            return this.ruleEngineModel.getSWRLRuleEngine();
        }

        protected void clearConsole() {
            this.console.setText("");
        }

        protected void appendToConsole(@NonNull String text) {
            this.console.append(text);
        }
    }
}

