/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.ft.fmrc.FmrcInv;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.Misc;

public class TimeCoord
implements Comparable {
    public static final TimeCoord EMPTY = new TimeCoord(new Date(), new double[0]);
    private Date runDate;
    private List<GridDatasetInv.Grid> gridInv;
    private int id;
    private String axisName;
    private boolean isInterval = false;
    private double[] offset;
    private double[] bound1;
    private double[] bound2;

    TimeCoord(Date runDate) {
        this.runDate = runDate;
    }

    TimeCoord(Date runDate, double[] offset) {
        this.runDate = runDate;
        this.offset = offset;
    }

    TimeCoord(TimeCoord from) {
        this.runDate = from.runDate;
        this.axisName = from.axisName;
        this.offset = from.offset;
        this.isInterval = from.isInterval;
        this.bound1 = from.bound1;
        this.bound2 = from.bound2;
        this.id = from.id;
    }

    TimeCoord(Date runDate, CoordinateAxis1DTime axis) {
        this.runDate = runDate;
        this.axisName = axis.getName();
        DateUnit unit = null;
        try {
            unit = new DateUnit(axis.getUnitsString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a unit of time " + axis.getUnitsString());
        }
        int n = (int)axis.getSize();
        if (axis.isInterval()) {
            this.isInterval = true;
            this.bound1 = axis.getBound1();
            this.bound2 = axis.getBound2();
        } else {
            this.offset = new double[n];
            int i = 0;
            while ((long)i < axis.getSize()) {
                Date d = unit.makeDate(axis.getCoordValue(i));
                this.offset[i] = FmrcInv.getOffsetInHours(runDate, d);
                ++i;
            }
        }
    }

    void addGridInventory(GridDatasetInv.Grid grid) {
        if (this.gridInv == null) {
            this.gridInv = new ArrayList<GridDatasetInv.Grid>();
        }
        this.gridInv.add(grid);
    }

    public Date getRunDate() {
        return this.runDate;
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public List<GridDatasetInv.Grid> getGridInventory() {
        return this.gridInv == null ? new ArrayList() : this.gridInv;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        if (this == EMPTY) {
            return "EMPTY";
        }
        return this.id == 0 ? "time" : "time" + this.id;
    }

    public String getAxisName() {
        return this.axisName;
    }

    public int getNCoords() {
        return this.isInterval ? this.bound1.length : this.offset.length;
    }

    public double[] getOffsetTimes() {
        return this.isInterval ? this.bound2 : this.offset;
    }

    public double[] getBound1() {
        return this.bound1;
    }

    public double[] getBound2() {
        return this.bound2;
    }

    public void setOffsetTimes(double[] offset) {
        this.offset = offset;
    }

    public void setBounds(double[] bound1, double[] bound2) {
        this.bound1 = bound1;
        this.bound2 = bound2;
        this.isInterval = true;
    }

    public void setBounds(List<Tinv> tinvs) {
        this.bound1 = new double[tinvs.size()];
        this.bound2 = new double[tinvs.size()];
        int count = 0;
        for (Tinv tinv : tinvs) {
            this.bound1[count] = tinv.b1;
            this.bound2[count] = tinv.b2;
            ++count;
        }
        this.isInterval = true;
    }

    public String toString() {
        DateFormatter df = new DateFormatter();
        Formatter out = new Formatter();
        out.format("%-10s %-26s offsets=", this.getName(), df.toDateTimeString(this.runDate));
        if (this.isInterval) {
            for (int i = 0; i < this.bound1.length; ++i) {
                out.format("(%3.1f,%3.1f) ", this.bound1[i], this.bound2[i]);
            }
        } else {
            for (double val : this.offset) {
                out.format("%3.1f, ", val);
            }
        }
        return out.toString();
    }

    public boolean equalsData(TimeCoord tother) {
        if (this.getRunDate() != null && !this.getRunDate().equals(tother.getRunDate())) {
            return false;
        }
        if (this.isInterval != tother.isInterval) {
            return false;
        }
        if (this.isInterval) {
            if (this.bound1.length != tother.bound1.length) {
                return false;
            }
            for (int i = 0; i < this.bound1.length; ++i) {
                if (!Misc.closeEnough(this.bound1[i], tother.bound1[i])) {
                    return false;
                }
                if (Misc.closeEnough(this.bound2[i], tother.bound2[i])) continue;
                return false;
            }
            return true;
        }
        if (this.offset.length != tother.offset.length) {
            return false;
        }
        for (int i = 0; i < this.offset.length; ++i) {
            if (Misc.closeEnough(this.offset[i], tother.offset[i])) continue;
            return false;
        }
        return true;
    }

    public int findInterval(double b1, double b2) {
        for (int i = 0; i < this.getNCoords(); ++i) {
            if (!Misc.closeEnough(this.bound1[i], b1) || !Misc.closeEnough(this.bound2[i], b2)) continue;
            return i;
        }
        return -1;
    }

    public int findIndex(double offsetHour) {
        double[] off = this.getOffsetTimes();
        for (int i = 0; i < off.length; ++i) {
            if (!Misc.closeEnough(off[i], offsetHour)) continue;
            return i;
        }
        return -1;
    }

    public int compareTo(Object o) {
        TimeCoord ot = (TimeCoord)o;
        return this.id - ot.id;
    }

    public static TimeCoord findTimeCoord(List<TimeCoord> timeCoords, TimeCoord want) {
        if (want == null) {
            return null;
        }
        for (TimeCoord tc : timeCoords) {
            if (!want.equalsData(tc)) continue;
            return tc;
        }
        TimeCoord result = new TimeCoord(want);
        timeCoords.add(result);
        return result;
    }

    public static TimeCoord makeUnion(List<TimeCoord> timeCoords, Date baseDate) {
        if (timeCoords.size() == 0) {
            return new TimeCoord(baseDate);
        }
        if (timeCoords.size() == 1) {
            return timeCoords.get(0);
        }
        if (timeCoords.get((int)0).isInterval) {
            return TimeCoord.makeUnionIntv(timeCoords, baseDate);
        }
        return TimeCoord.makeUnionReg(timeCoords, baseDate);
    }

    private static TimeCoord makeUnionReg(List<TimeCoord> timeCoords, Date baseDate) {
        HashSet<Double> offsets = new HashSet<Double>();
        for (TimeCoord tc : timeCoords) {
            if (tc.isInterval) {
                throw new IllegalArgumentException("Cant mix interval coordinates");
            }
            for (double off : tc.getOffsetTimes()) {
                offsets.add(off);
            }
        }
        List<Double> offsetList = Arrays.asList(offsets.toArray(new Double[offsets.size()]));
        Collections.sort(offsetList);
        double[] offset = new double[offsetList.size()];
        int count = 0;
        for (double off : offsetList) {
            offset[count++] = off;
        }
        TimeCoord result = new TimeCoord(baseDate);
        result.setOffsetTimes(offset);
        return result;
    }

    private static TimeCoord makeUnionIntv(List<TimeCoord> timeCoords, Date baseDate) {
        HashSet<Tinv> offsets = new HashSet<Tinv>();
        for (TimeCoord tc : timeCoords) {
            if (!tc.isInterval) {
                throw new IllegalArgumentException("Cant mix non-interval coordinates");
            }
            for (int i = 0; i < tc.bound1.length; ++i) {
                offsets.add(new Tinv(tc.bound1[i], tc.bound2[i]));
            }
        }
        List<Tinv> bounds = Arrays.asList(offsets.toArray(new Tinv[offsets.size()]));
        Collections.sort(bounds);
        int n = bounds.size();
        double[] bounds1 = new double[n];
        double[] bounds2 = new double[n];
        for (int i = 0; i < n; ++i) {
            Tinv tinv = bounds.get(i);
            bounds1[i] = tinv.b1;
            bounds2[i] = tinv.b2;
        }
        TimeCoord result = new TimeCoord(baseDate);
        result.setBounds(bounds1, bounds2);
        return result;
    }

    public static class Tinv
    implements Comparable<Tinv> {
        private double b1;
        private double b2;

        public Tinv(double offset) {
            this.b2 = offset;
        }

        public Tinv(double b1, double b2) {
            this.b1 = b1;
            this.b2 = b2;
        }

        public boolean equals(Object o) {
            Tinv tinv = (Tinv)o;
            if (Double.compare(tinv.b1, this.b1) != 0) {
                return false;
            }
            return Double.compare(tinv.b2, this.b2) == 0;
        }

        public int hashCode() {
            long temp = this.b1 != 0.0 ? Double.doubleToLongBits(this.b1) : 0L;
            int result = (int)(temp ^ temp >>> 32);
            temp = this.b2 != 0.0 ? Double.doubleToLongBits(this.b2) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        @Override
        public int compareTo(Tinv o) {
            int c1 = Double.compare(this.b2, o.b2);
            if (c1 == 0) {
                return Double.compare(this.b1, o.b1);
            }
            return c1;
        }
    }
}

