/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import ucar.unidata.io.RandomAccessFile;

class MMapRandomAccessFile
extends RandomAccessFile {
    private MappedByteBuffer source;

    MMapRandomAccessFile(String location, String mode) throws IOException {
        super(location, mode, 1);
        FileChannel channel = this.file.getChannel();
        this.source = channel.map(this.readonly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, channel.size());
        channel.close();
        this.bufferStart = 0L;
        this.dataSize = (int)channel.size();
        this.dataEnd = channel.size();
        this.filePosition = 0L;
        this.buffer = null;
        this.endOfFile = false;
    }

    public void flush() throws IOException {
        if (this.bufferModified) {
            this.source.force();
            this.bufferModified = false;
        }
    }

    public void close() throws IOException {
        if (!this.readonly) {
            this.flush();
        }
        this.source = null;
    }

    public long length() {
        return this.dataEnd;
    }

    public void seek(long pos) {
        this.filePosition = pos;
        if (this.filePosition < this.dataEnd) {
            this.source.position((int)this.filePosition);
        } else {
            this.endOfFile = true;
        }
    }

    public void unread() {
        this.seek(this.filePosition - 1L);
    }

    public int read() throws IOException {
        if (this.filePosition < this.dataEnd) {
            ++this.filePosition;
            return this.source.get() & 0xFF;
        }
        return -1;
    }

    protected int readBytes(byte[] dst, int offset, int length) throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        if ((length = (int)Math.min((long)length, this.dataEnd - this.filePosition)) > 0) {
            this.source.get(dst, offset, length);
            this.filePosition += (long)length;
        }
        return length;
    }

    public void write(int b) throws IOException {
        this.source.put((byte)b);
        ++this.filePosition;
        this.bufferModified = true;
    }

    public void writeBytes(byte[] dst, int offset, int length) throws IOException {
        this.source.put(dst, offset, length);
        this.filePosition += (long)length;
    }
}

