/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.util.Format;

public class ProjectionRect
extends Rectangle2D.Double
implements Serializable {
    public ProjectionRect() {
        this(-5000.0, -5000.0, 5000.0, 5000.0);
    }

    public ProjectionRect(Rectangle2D r) {
        this(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY());
    }

    public ProjectionRect(double x1, double y1, double x2, double y2) {
        double wx0 = 0.5 * (x1 + x2);
        double wy0 = 0.5 * (y1 + y2);
        double width = Math.abs(x1 - x2);
        double height = Math.abs(y1 - y2);
        this.setRect(wx0 - width / 2.0, wy0 - height / 2.0, width, height);
    }

    public ProjectionPoint getLowerRightPoint() {
        return new ProjectionPointImpl(this.getMaxPoint().getX(), this.getMinPoint().getY());
    }

    public ProjectionPoint getUpperRightPoint() {
        return this.getMaxPoint();
    }

    public ProjectionPoint getLowerLeftPoint() {
        return this.getMinPoint();
    }

    public ProjectionPoint getUpperLeftPoint() {
        return new ProjectionPointImpl(this.getMinPoint().getX(), this.getMaxPoint().getY());
    }

    public ProjectionPoint getMinPoint() {
        return new ProjectionPointImpl(this.getX(), this.getY());
    }

    public ProjectionPoint getMaxPoint() {
        return new ProjectionPointImpl(this.getX() + this.getWidth(), this.getY() + this.getHeight());
    }

    @Override
    public String toString() {
        return "min: " + Format.d(this.getX(), 3) + " " + Format.d(this.getY(), 3) + " size: " + Format.d(this.getWidth(), 3) + " " + Format.d(this.getHeight(), 3);
    }

    public String toString2() {
        return "min: " + Format.d(this.getX(), 3) + " " + Format.d(this.getY(), 3) + " max: " + Format.d(this.getX() + this.getWidth(), 3) + " " + Format.d(this.getY() + this.getHeight(), 3);
    }

    public void setX(double x) {
        this.setRect(x, this.getY(), this.getWidth(), this.getHeight());
    }

    public void setY(double y) {
        this.setRect(this.getX(), y, this.getWidth(), this.getHeight());
    }

    public void setWidth(double w) {
        this.setRect(this.getX(), this.getY(), w, this.getHeight());
    }

    public void setHeight(double h) {
        this.setRect(this.getX(), this.getY(), this.getWidth(), h);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        double x = s.readDouble();
        double y = s.readDouble();
        double w = s.readDouble();
        double h = s.readDouble();
        this.setRect(x, y, w, h);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeDouble(this.getX());
        s.writeDouble(this.getY());
        s.writeDouble(this.getWidth());
        s.writeDouble(this.getHeight());
    }
}

