/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.crawler;

public class CrawlConfig {
    private String crawlStorageFolder;
    private boolean resumableCrawling = false;
    private int maxDepthOfCrawling = -1;
    private int maxPagesToFetch = -1;
    private String userAgentString = "crawler4j (http://code.google.com/p/crawler4j/)";
    private int politenessDelay = 200;
    private boolean includeHttpsPages = false;
    private boolean includeBinaryContentInCrawling = false;
    private int maxConnectionsPerHost = 100;
    private int maxTotalConnections = 100;
    private int socketTimeout = 20000;
    private int connectionTimeout = 30000;
    private int maxOutgoingLinksToFollow = 5000;
    private int maxDownloadSize = 0x100000;
    private boolean followRedirects = true;
    private String proxyHost = null;
    private int proxyPort = 80;
    private String proxyUsername = null;
    private String proxyPassword = null;

    public void validate() throws Exception {
        if (this.crawlStorageFolder == null) {
            throw new Exception("Crawl storage folder is not set in the CrawlConfig.");
        }
        if (this.politenessDelay < 0) {
            throw new Exception("Invalid value for politeness delay: " + this.politenessDelay);
        }
        if (this.maxDepthOfCrawling < -1) {
            throw new Exception("Maximum crawl depth should be either a positive number or -1 for unlimited depth.");
        }
        if (this.maxDepthOfCrawling > Short.MAX_VALUE) {
            throw new Exception("Maximum value for crawl depth is 32767");
        }
    }

    public String getCrawlStorageFolder() {
        return this.crawlStorageFolder;
    }

    public void setCrawlStorageFolder(String crawlStorageFolder) {
        this.crawlStorageFolder = crawlStorageFolder;
    }

    public boolean isResumableCrawling() {
        return this.resumableCrawling;
    }

    public void setResumableCrawling(boolean resumableCrawling) {
        this.resumableCrawling = resumableCrawling;
    }

    public int getMaxDepthOfCrawling() {
        return this.maxDepthOfCrawling;
    }

    public void setMaxDepthOfCrawling(int maxDepthOfCrawling) {
        this.maxDepthOfCrawling = maxDepthOfCrawling;
    }

    public int getMaxPagesToFetch() {
        return this.maxPagesToFetch;
    }

    public void setMaxPagesToFetch(int maxPagesToFetch) {
        this.maxPagesToFetch = maxPagesToFetch;
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public int getPolitenessDelay() {
        return this.politenessDelay;
    }

    public void setPolitenessDelay(int politenessDelay) {
        this.politenessDelay = politenessDelay;
    }

    public boolean isIncludeHttpsPages() {
        return this.includeHttpsPages;
    }

    public void setIncludeHttpsPages(boolean includeHttpsPages) {
        this.includeHttpsPages = includeHttpsPages;
    }

    public boolean isIncludeBinaryContentInCrawling() {
        return this.includeBinaryContentInCrawling;
    }

    public void setIncludeBinaryContentInCrawling(boolean includeBinaryContentInCrawling) {
        this.includeBinaryContentInCrawling = includeBinaryContentInCrawling;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxOutgoingLinksToFollow() {
        return this.maxOutgoingLinksToFollow;
    }

    public void setMaxOutgoingLinksToFollow(int maxOutgoingLinksToFollow) {
        this.maxOutgoingLinksToFollow = maxOutgoingLinksToFollow;
    }

    public int getMaxDownloadSize() {
        return this.maxDownloadSize;
    }

    public void setMaxDownloadSize(int maxDownloadSize) {
        this.maxDownloadSize = maxDownloadSize;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Crawl storage folder: " + this.getCrawlStorageFolder() + "\n");
        sb.append("Resumable crawling: " + this.isResumableCrawling() + "\n");
        sb.append("Max depth of crawl: " + this.getMaxDepthOfCrawling() + "\n");
        sb.append("Max pages to fetch: " + this.getMaxPagesToFetch() + "\n");
        sb.append("User agent string: " + this.getUserAgentString() + "\n");
        sb.append("Include https pages: " + this.isIncludeHttpsPages() + "\n");
        sb.append("Include binary content: " + this.isIncludeBinaryContentInCrawling() + "\n");
        sb.append("Max connections per host: " + this.getMaxConnectionsPerHost() + "\n");
        sb.append("Max total connections: " + this.getMaxTotalConnections() + "\n");
        sb.append("Socket timeout: " + this.getSocketTimeout() + "\n");
        sb.append("Max total connections: " + this.getMaxTotalConnections() + "\n");
        sb.append("Max outgoing links to follow: " + this.getMaxOutgoingLinksToFollow() + "\n");
        sb.append("Max download size: " + this.getMaxDownloadSize() + "\n");
        sb.append("Should follow redirects?: " + this.isFollowRedirects() + "\n");
        sb.append("Proxy host: " + this.getProxyHost() + "\n");
        sb.append("Proxy port: " + this.getProxyPort() + "\n");
        sb.append("Proxy username: " + this.getProxyUsername() + "\n");
        sb.append("Proxy password: " + this.getProxyPassword() + "\n");
        return sb.toString();
    }
}

