/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.frontier;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import edu.uci.ics.crawler4j.crawler.Configurable;
import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.util.Util;
import org.apache.log4j.Logger;

public class DocIDServer
extends Configurable {
    protected static final Logger logger = Logger.getLogger((String)DocIDServer.class.getName());
    protected Database docIDsDB = null;
    protected final Object mutex = new Object();
    protected int lastDocID;

    public DocIDServer(Environment env, CrawlConfig config) throws DatabaseException {
        super(config);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(config.isResumableCrawling());
        dbConfig.setDeferredWrite(!config.isResumableCrawling());
        this.docIDsDB = env.openDatabase(null, "DocIDs", dbConfig);
        if (config.isResumableCrawling()) {
            int docCount = this.getDocCount();
            if (docCount > 0) {
                logger.info((Object)("Loaded " + docCount + " URLs that had been detected in previous crawl."));
                this.lastDocID = docCount;
            }
        } else {
            this.lastDocID = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDocId(String url) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.docIDsDB == null) {
                return -1;
            }
            DatabaseEntry value = new DatabaseEntry();
            try {
                DatabaseEntry key = new DatabaseEntry(url.getBytes());
                OperationStatus result = this.docIDsDB.get(null, key, value, null);
                if (result == OperationStatus.SUCCESS && value.getData().length > 0) {
                    return Util.byteArray2Int(value.getData());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewDocID(String url) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                int docid = this.getDocId(url);
                if (docid > 0) {
                    return docid;
                }
                ++this.lastDocID;
                this.docIDsDB.put(null, new DatabaseEntry(url.getBytes()), new DatabaseEntry(Util.int2ByteArray(this.lastDocID)));
                return this.lastDocID;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrlAndDocId(String url, int docId) throws Exception {
        Object object = this.mutex;
        synchronized (object) {
            if (docId <= this.lastDocID) {
                throw new Exception("Requested doc id: " + docId + " is not larger than: " + this.lastDocID);
            }
            int prevDocid = this.getDocId(url);
            if (prevDocid > 0) {
                if (prevDocid == docId) {
                    return;
                }
                throw new Exception("Doc id: " + prevDocid + " is already assigned to URL: " + url);
            }
            this.docIDsDB.put(null, new DatabaseEntry(url.getBytes()), new DatabaseEntry(Util.int2ByteArray(docId)));
            this.lastDocID = docId;
        }
    }

    public boolean isSeenBefore(String url) {
        return this.getDocId(url) != -1;
    }

    public int getDocCount() {
        try {
            return (int)this.docIDsDB.count();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void sync() {
        if (this.config.isResumableCrawling()) {
            return;
        }
        if (this.docIDsDB == null) {
            return;
        }
        try {
            this.docIDsDB.sync();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.docIDsDB.close();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }
}

