/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.frontier;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import edu.uci.ics.crawler4j.frontier.WorkQueues;
import edu.uci.ics.crawler4j.url.WebURL;
import org.apache.log4j.Logger;

public class InProcessPagesDB
extends WorkQueues {
    private static final Logger logger = Logger.getLogger((String)InProcessPagesDB.class.getName());

    public InProcessPagesDB(Environment env) throws DatabaseException {
        super(env, "InProcessPagesDB", true);
        long docCount = this.getLength();
        if (docCount > 0L) {
            logger.info((Object)("Loaded " + docCount + " URLs that have been in process in the previous crawl."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeURL(WebURL webUrl) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                DatabaseEntry key = this.getDatabaseEntryKey(webUrl);
                Cursor cursor = null;
                DatabaseEntry value = new DatabaseEntry();
                Transaction txn = this.env.beginTransaction(null, null);
                try {
                    cursor = this.urlsDB.openCursor(txn, null);
                    OperationStatus result = cursor.getSearchKey(key, value, null);
                    if (result != OperationStatus.SUCCESS) return false;
                    result = cursor.delete();
                    if (result != OperationStatus.SUCCESS) return false;
                    boolean bl = true;
                    return bl;
                }
                catch (DatabaseException e) {
                    if (txn == null) throw e;
                    txn.abort();
                    txn = null;
                    throw e;
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (txn != null) {
                        txn.commit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

