/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.robotstxt;

import edu.uci.ics.crawler4j.robotstxt.HostDirectives;
import java.util.StringTokenizer;

public class RobotstxtParser {
    private static final String PATTERNS_USERAGENT = "(?i)^User-agent:.*";
    private static final String PATTERNS_DISALLOW = "(?i)Disallow:.*";
    private static final String PATTERNS_ALLOW = "(?i)Allow:.*";
    private static final int PATTERNS_USERAGENT_LENGTH = 11;
    private static final int PATTERNS_DISALLOW_LENGTH = 9;
    private static final int PATTERNS_ALLOW_LENGTH = 6;

    public static HostDirectives parse(String content, String myUserAgent) {
        HostDirectives directives = null;
        boolean inMatchingUserAgent = false;
        StringTokenizer st = new StringTokenizer(content, "\n");
        while (st.hasMoreTokens()) {
            String path;
            String line = st.nextToken();
            int commentIndex = line.indexOf("#");
            if (commentIndex > -1) {
                line = line.substring(0, commentIndex);
            }
            line = line.replaceAll("<[^>]+>", "");
            if ((line = line.trim()).length() == 0) continue;
            if (line.matches(PATTERNS_USERAGENT)) {
                String ua = line.substring(11).trim().toLowerCase();
                if (ua.equals("*") || ua.contains(myUserAgent)) {
                    inMatchingUserAgent = true;
                    continue;
                }
                inMatchingUserAgent = false;
                continue;
            }
            if (line.matches(PATTERNS_DISALLOW)) {
                if (!inMatchingUserAgent) continue;
                path = line.substring(9).trim();
                if (path.endsWith("*")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((path = path.trim()).length() <= 0) continue;
                if (directives == null) {
                    directives = new HostDirectives();
                }
                directives.addDisallow(path);
                continue;
            }
            if (!line.matches(PATTERNS_ALLOW) || !inMatchingUserAgent) continue;
            path = line.substring(6).trim();
            if (path.endsWith("*")) {
                path = path.substring(0, path.length() - 1);
            }
            path = path.trim();
            if (directives == null) {
                directives = new HostDirectives();
            }
            directives.addAllow(path);
        }
        return directives;
    }
}

