/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.url;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLDList {
    private static final String TLD_NAMES_ONLINE_URL = "https://publicsuffix.org/list/effective_tld_names.dat";
    private static final String TLD_NAMES_TXT_FILENAME = "tld-names.txt";
    private static final Logger logger = LoggerFactory.getLogger(TLDList.class);
    private static boolean onlineUpdate = false;
    private final Set<String> tldSet = new HashSet<String>(10000);
    private static final TLDList instance = new TLDList();

    private TLDList() {
        File f;
        if (onlineUpdate) {
            URL url;
            try {
                url = new URL(TLD_NAMES_ONLINE_URL);
            }
            catch (MalformedURLException e) {
                logger.error("Invalid URL: {}", (Object)TLD_NAMES_ONLINE_URL);
                throw new RuntimeException(e);
            }
            try (InputStream stream = url.openStream();){
                logger.debug("Fetching the most updated TLD list online");
                int n = this.readStream(stream);
                logger.info("Obtained {} TLD from URL {}", (Object)n, (Object)TLD_NAMES_ONLINE_URL);
                return;
            }
            catch (Exception e) {
                logger.error("Couldn't fetch the online list of TLDs from: {}", (Object)TLD_NAMES_ONLINE_URL, (Object)e);
            }
        }
        if ((f = new File(TLD_NAMES_TXT_FILENAME)).exists()) {
            logger.debug("Fetching the list from a local file {}", (Object)TLD_NAMES_TXT_FILENAME);
            try (FileInputStream tldFile = new FileInputStream(f);){
                int n = this.readStream(tldFile);
                logger.info("Obtained {} TLD from local file {}", (Object)n, (Object)TLD_NAMES_TXT_FILENAME);
                return;
            }
            catch (IOException e) {
                logger.error("Couldn't read the TLD list from local file", (Throwable)e);
            }
        }
        try (InputStream tldFile = this.getClass().getClassLoader().getResourceAsStream(TLD_NAMES_TXT_FILENAME);){
            int n = this.readStream(tldFile);
            logger.info("Obtained {} TLD from packaged file {}", (Object)n, (Object)TLD_NAMES_TXT_FILENAME);
        }
        catch (IOException e) {
            logger.error("Couldn't read the TLD list from file");
            throw new RuntimeException(e);
        }
    }

    private int readStream(InputStream stream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("//")) continue;
                this.tldSet.add(line);
            }
        }
        catch (IOException e) {
            logger.warn("Error while reading TLD-list: {}", (Object)e.getMessage());
        }
        return this.tldSet.size();
    }

    public static TLDList getInstance() {
        return instance;
    }

    public static void setUseOnline(boolean online) {
        onlineUpdate = online;
    }

    public boolean contains(String str) {
        return this.tldSet.contains(str);
    }
}

