package edu.uci.qa.crypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class CryptConfig {
  
  public String passphrase;
  public String salt;
  public String cipherAlgo;
  public String specAlgo;
  public String factoryAlgo;
  public Integer iterations;
  public Integer keyLength;
  public static final Integer DEFAULT_KEYLENGTH = 128;
  
  public CryptConfig() {
    this(new File(new File(System.getProperty("user.home")), ".crypt"), new File(".crypt"));
  }
  
  public CryptConfig(final File relative) {
    this(new File(new File(System.getProperty("user.home")), ".crypt"), relative);
  }
  
  public CryptConfig(final File globalConfig, final File relative) {
    try {
      if (relative.exists()) {
        readPropStream(new FileInputStream(relative));
      }
    } catch (FileNotFoundException e) { } 
    try {
      if (globalConfig.exists()) {
        readPropStream(new FileInputStream(globalConfig));
      }
    } catch (FileNotFoundException e) { }
    
    if (keyLength == null) {
      keyLength = DEFAULT_KEYLENGTH;
    }
  }
  
  private void readPropStream(InputStream stream) {
    Properties props = new Properties();
    try {
      props.load(stream);
      
      if (passphrase == null) {
        this.passphrase = props.getProperty("passphrase");
      }
      if (salt == null) {
        this.salt = props.getProperty("salt");
      }
      if (cipherAlgo == null) {
        this.cipherAlgo = props.getProperty("cipher");
      }
      if (specAlgo == null) {
        this.specAlgo = props.getProperty("spec");
      }
      if (factoryAlgo == null) {
        this.factoryAlgo = props.getProperty("factory");
      }
      if (iterations == null) {
        if (props.getProperty("iterations") != null)
          this.iterations = Integer.valueOf(props.getProperty("iterations"));
      }
      if (keyLength == null) {
        if (props.getProperty("key-length") != null)
        this.keyLength = Integer.valueOf(props.getProperty("key-length"));
      }
      
    } catch (IOException e) {
      e.printStackTrace();
    } finally {
      try {
        if (stream != null) {
          stream.close();
        }
      } catch (IOException e) {}
    }
  }
}
