/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.crypt;

import edu.uci.qa.crypt.AES;
import edu.uci.qa.crypt.CryptConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Crypt {
    private static final Logger log = LoggerFactory.getLogger(Crypt.class);

    public static String encrypt(String input) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            return Base64.getEncoder().encodeToString(Crypt.encrypt(is).toByteArray());
        }
        catch (IOException e) {
            log.error("IOException occurred when encrypting string '" + input + "'");
            throw new RuntimeException(e);
        }
    }

    public static String encrypt(String input, String passphrase) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            return Base64.getEncoder().encodeToString(Crypt.encrypt((InputStream)is, passphrase).toByteArray());
        }
        catch (IOException e) {
            log.error("IOException occurred when encrypting string '" + input + "'");
            throw new RuntimeException(e);
        }
    }

    public static String encrypt(File input) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(input);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            return Base64.getEncoder().encodeToString(Crypt.encrypt(is).toByteArray());
        }
        catch (IOException e) {
            log.error("IOException occurred when encrypting string '" + input + "'");
            throw new RuntimeException(e);
        }
    }

    public static String encrypt(File input, String passphrase) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(input);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            return Base64.getEncoder().encodeToString(Crypt.encrypt((InputStream)is, passphrase).toByteArray());
        }
        catch (IOException e) {
            log.error("IOException occurred when encrypting string '" + input + "'");
            throw new RuntimeException(e);
        }
    }

    public static ByteArrayOutputStream encrypt(InputStream is) throws IOException {
        return Crypt.encrypt(is, new CryptConfig());
    }

    public static ByteArrayOutputStream encrypt(InputStream is, String passphrase) throws IOException {
        return Crypt.encrypt(is, passphrase.toCharArray());
    }

    public static ByteArrayOutputStream encrypt(InputStream is, char[] passphrase) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AES.encrypt(CryptConfig.DEFAULT_KEYLENGTH, passphrase, is, out);
        return out;
    }

    public static ByteArrayOutputStream encrypt(InputStream is, CryptConfig config) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AES.encrypt(config.keyLength, config.passphrase.toCharArray(), is, out);
        return out;
    }

    public static String decrypt(String input) {
        ByteArrayInputStream is = new ByteArrayInputStream(Base64.getDecoder().decode(input));
        try {
            return new String(Crypt.decrypt(is).toByteArray());
        }
        catch (IOException e) {
            log.error("IOException occurred when encrypting string '" + input + "'");
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String input, String passphrase) {
        ByteArrayInputStream is = new ByteArrayInputStream(Base64.getDecoder().decode(input));
        try {
            return new String(Crypt.decrypt((InputStream)is, passphrase).toByteArray());
        }
        catch (IOException e) {
            log.error("IOException occurred when encrypting string '" + input + "'");
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(File input) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(input);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            return new String(Crypt.decrypt(is).toByteArray());
        }
        catch (IOException e) {
            log.error("IOException occurred when encrypting string '" + input + "'");
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(File input, String passphrase) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(input);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            return new String(Crypt.decrypt((InputStream)is, passphrase).toByteArray());
        }
        catch (IOException e) {
            log.error("IOException occurred when encrypting string '" + input + "'");
            throw new RuntimeException(e);
        }
    }

    public static ByteArrayOutputStream decrypt(InputStream is) throws IOException {
        return Crypt.decrypt(is, new CryptConfig());
    }

    public static ByteArrayOutputStream decrypt(InputStream is, CryptConfig config) throws IOException {
        return Crypt.decrypt(is, config.passphrase);
    }

    public static ByteArrayOutputStream decrypt(InputStream is, String passphrase) throws IOException {
        return Crypt.decrypt(is, passphrase.toCharArray());
    }

    public static ByteArrayOutputStream decrypt(InputStream is, char[] passphrase) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AES.decrypt(passphrase, is, out);
        return out;
    }
}

