/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.crypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class CryptConfig {
    public String passphrase;
    public String salt;
    public String cipherAlgo;
    public String specAlgo;
    public String factoryAlgo;
    public Integer iterations;
    public Integer keyLength;
    public static final Integer DEFAULT_KEYLENGTH = 128;

    public CryptConfig() {
        this(new File(new File(System.getProperty("user.home")), ".crypt"), new File(".crypt"));
    }

    public CryptConfig(File relative) {
        this(new File(new File(System.getProperty("user.home")), ".crypt"), relative);
    }

    public CryptConfig(File globalConfig, File relative) {
        try {
            if (relative.exists()) {
                this.readPropStream(new FileInputStream(relative));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            if (globalConfig.exists()) {
                this.readPropStream(new FileInputStream(globalConfig));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (this.keyLength == null) {
            this.keyLength = DEFAULT_KEYLENGTH;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropStream(InputStream stream) {
        Properties props = new Properties();
        try {
            props.load(stream);
            if (this.passphrase == null) {
                this.passphrase = props.getProperty("passphrase");
            }
            if (this.salt == null) {
                this.salt = props.getProperty("salt");
            }
            if (this.cipherAlgo == null) {
                this.cipherAlgo = props.getProperty("cipher");
            }
            if (this.specAlgo == null) {
                this.specAlgo = props.getProperty("spec");
            }
            if (this.factoryAlgo == null) {
                this.factoryAlgo = props.getProperty("factory");
            }
            if (this.iterations == null && props.getProperty("iterations") != null) {
                this.iterations = Integer.valueOf(props.getProperty("iterations"));
            }
            if (this.keyLength == null && props.getProperty("key-length") != null) {
                this.keyLength = Integer.valueOf(props.getProperty("key-length"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

