/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.AssetResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetProvider;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetRequest;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetResponse;
import edu.uiuc.ncsa.security.delegation.client.request.DelegationRequest;
import edu.uiuc.ncsa.security.delegation.client.request.DelegationResponse;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.MyX509Certificates;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.net.URI;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.PKCS10CertificationRequest;

public class OA4MPService {
    public static final String SKIN_PARAMETER = "skin";
    ClientEnvironment environment;

    public OA4MPService(ClientEnvironment environment) {
        this.environment = environment;
    }

    public ClientEnvironment getEnvironment() {
        return this.environment;
    }

    public OA4MPResponse requestCert(Map additionalParameters) {
        if (additionalParameters == null) {
            additionalParameters = new HashMap();
        }
        try {
            KeyPair keyPair = KeyUtil.generateKeyPair();
            PKCS10CertificationRequest certReq = CertUtil.createCertRequest((KeyPair)keyPair);
            OA4MPResponse mpdsResponse = new OA4MPResponse();
            mpdsResponse.setPrivateKey(keyPair.getPrivate());
            additionalParameters.put("certreq", Base64.encodeBase64String((byte[])certReq.getEncoded()));
            if (!additionalParameters.containsKey(this.getEnvironment().getConstants().get("oa4mp:callback_uri"))) {
                additionalParameters.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
            }
            DelegationRequest daReq = new DelegationRequest();
            daReq.setParameters(additionalParameters);
            daReq.setClient(this.getEnvironment().getClient());
            daReq.setBaseUri(this.getEnvironment().getAuthorizationUri());
            DelegationResponse daResp = (DelegationResponse)this.getEnvironment().getDelegationService().process((Request)daReq);
            String skin = this.getEnvironment().getSkin();
            String r = daResp.getRedirectUri().toString();
            if (skin != null) {
                r = r + "&" + SKIN_PARAMETER + "=" + skin;
            }
            mpdsResponse.setRedirect(URI.create(r));
            return mpdsResponse;
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new GeneralException("Error generating request", e);
        }
    }

    public OA4MPResponse requestCert() {
        HashMap<String, Long> m = new HashMap<String, Long>();
        if (0L <= this.getEnvironment().getCertLifetime()) {
            m.put("certlifetime", this.getEnvironment().getCertLifetime());
        }
        return this.requestCert(m);
    }

    public OA4MPResponse requestCert(Identifier identifier) {
        HashMap<String, Long> m = new HashMap<String, Long>();
        if (0L <= this.getEnvironment().getCertLifetime()) {
            m.put("certlifetime", this.getEnvironment().getCertLifetime());
        }
        return this.requestCert(identifier, m);
    }

    public OA4MPResponse requestCert(Identifier identifier, Map additionalParameters) {
        OA4MPResponse response = this.requestCert(additionalParameters);
        if (!this.getEnvironment().hasAssetStore()) {
            throw new IllegalStateException("Error: There is no asset store configured.");
        }
        AssetProvider assetProvider = new AssetProvider();
        Asset asset = assetProvider.get(identifier);
        asset.setPrivateKey(response.getPrivateKey());
        asset.setRedirect(response.getRedirect());
        this.getEnvironment().getAssetStore().save((Identifiable)asset);
        return response;
    }

    public AssetResponse getCert(String tempToken, String verifier) {
        AuthorizationGrant ag = this.getEnvironment().getTokenForge().getAuthorizationGrant(new String[]{tempToken});
        Verifier v = this.getEnvironment().getTokenForge().getVerifier(new String[]{verifier});
        DelegatedAssetRequest dar = new DelegatedAssetRequest();
        HashMap m = new HashMap();
        dar.setAuthorizationGrant(ag);
        dar.setClient(this.getEnvironment().getClient());
        dar.setVerifier(v);
        dar.setParameters(m);
        HashMap m1 = new HashMap();
        dar.setAssetParameters(m1);
        DelegatedAssetResponse daResp = (DelegatedAssetResponse)this.getEnvironment().getDelegationService().process((Request)dar);
        AssetResponse par = new AssetResponse();
        MyX509Certificates myX509Certificate = (MyX509Certificates)daResp.getProtectedAsset();
        par.setX509Certificates(myX509Certificate.getX509Certificates());
        par.setUsername((String)daResp.getAdditionalInformation().get("username"));
        return par;
    }

    public AssetResponse getCert(String tempToken, String verifier, Identifier identifier) {
        AssetResponse assetResponse = this.getCert(tempToken, verifier);
        if (!this.getEnvironment().hasAssetStore()) {
            throw new IllegalStateException("Error: No asset store enabled.");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Error: null identifier encountered");
        }
        Asset asset = (Asset)((Object)this.getEnvironment().getAssetStore().get(identifier));
        if (asset == null) {
            throw new IllegalArgumentException("Error:No asset with the given identifier \"" + identifier + "\" found.");
        }
        asset.setUsername(assetResponse.getUsername());
        asset.setCertificates(assetResponse.getX509Certificates());
        this.getEnvironment().getAssetStore().save((Identifiable)asset);
        return assetResponse;
    }
}

