package edu.uiuc.ncsa.myproxy.oa4mp.client.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;

import java.io.File;

/**
 * <p>Created by Jeff Gaynor<br>
 * on 1/28/13 at  1:14 PM
 */
public class FSAssetStore extends FileStore<Asset> implements AssetStore{
    public FSAssetStore(File file, IdentifiableProvider idp, MapConverter cp) {
        super(file, idp, cp);
    }

    public FSAssetStore(File storeDirectory, File indexDirectory, IdentifiableProvider identifiableProvider, MapConverter converter) {
        super(storeDirectory, indexDirectory, identifiableProvider, converter);
    }

    @Override
    public Asset get(String identifier) {
        return AssetStoreUtil.get(identifier, this);
    }

    @Override
    public void save(String identifier, Asset identifiable) {
       AssetStoreUtil.save(identifier, identifiable, this);
    }
}
