package edu.uiuc.ncsa.myproxy.oa4mp.client.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;

import javax.inject.Provider;

/**
 * <p>Created by Jeff Gaynor<br>
 * on 1/28/13 at  2:11 PM
 */
public class SQLAssetStore extends SQLStore<Asset> implements AssetStore {
    public static final String DEFAULT_TABLENAME = "transactions";
    public SQLAssetStore() {
    }

    public SQLAssetStore(ConnectionPool connectionPool, Table table, Provider<Asset> assetProvider, MapConverter<Asset> converter) {
        super(connectionPool, table, assetProvider, converter);
    }

    @Override
    public Asset get(String identifier) {
        return AssetStoreUtil.get(identifier, this);
    }

    @Override
    public void save(String identifier, Asset asset) {
       AssetStoreUtil.save(identifier, asset, this);
    }
}
